/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.tile.module;

import epicsquid.mysticallib.LibEvents;
import epicsquid.mysticallib.handlers.MysticalEnergyStorage;
import epicsquid.mysticallib.tile.TileModular;
import epicsquid.mysticallib.tile.module.FaceConfig;
import epicsquid.mysticallib.tile.module.IModule;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ModuleEnergy
implements IModule<IEnergyStorage> {
    @Nonnull
    public static final String ENERGY_MODULE = "ENERGY_MODULE";
    @Nonnull
    private MysticalEnergyStorage battery;
    @Nonnull
    private Map<EnumFacing, EnergyIOProxy> ioProxies = new EnumMap<EnumFacing, EnergyIOProxy>(EnumFacing.class);
    @Nonnull
    private FaceConfig faceConfig;
    @Nonnull
    private TileModular tile;

    public ModuleEnergy(@Nonnull TileModular tile, int capacity, int inputLimit, int outputLimit) {
        this.tile = tile;
        this.faceConfig = tile.getFaceConfig();
        this.battery = new MysticalEnergyStorage(capacity, inputLimit, outputLimit);
        for (EnumFacing f : EnumFacing.values()) {
            this.ioProxies.put(f, this.constructIOProxy(f, this.faceConfig.getIO(f), capacity, inputLimit, outputLimit, 0));
        }
    }

    @Nonnull
    protected EnergyIOProxy constructIOProxy(@Nonnull EnumFacing face, @Nonnull FaceConfig.FaceIO ioMode, int capacity, int maxIn, int maxOut, int energy) {
        return new EnergyIOProxy(face, ioMode, capacity, maxIn, maxOut, energy);
    }

    @Nonnull
    public MysticalEnergyStorage getBattery() {
        return this.battery;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<IEnergyStorage> capability, @Nullable EnumFacing face) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Override
    @Nonnull
    public IEnergyStorage getCapability(@Nullable Capability<IEnergyStorage> capability, @Nullable EnumFacing face) {
        if (face != null) {
            return (IEnergyStorage)this.ioProxies.get(face);
        }
        return this.battery;
    }

    @Override
    @Nonnull
    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("battery", (NBTBase)this.battery.writeToNBT());
        return tag;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        this.battery.readFromNBT(tag.func_74775_l("battery"));
    }

    @Override
    public void onUpdate(@Nonnull BlockPos pos, @Nonnull World world) {
        for (EnumFacing dir : EnumFacing.values()) {
            int amount;
            IEnergyStorage adjBattery;
            TileEntity adjTile;
            if (this.faceConfig.getIO(dir) != FaceConfig.FaceIO.OUT || world.field_72995_K || (adjTile = world.func_175625_s(pos.func_177972_a(dir))) == null || !adjTile.hasCapability(CapabilityEnergy.ENERGY, dir.func_176734_d()) || (adjBattery = (IEnergyStorage)adjTile.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d())) == null || (amount = adjBattery.receiveEnergy(Math.min(this.battery.getMaxExtract(), this.battery.getEnergyStored()), true)) <= 0) continue;
            adjBattery.receiveEnergy(amount, false);
            this.battery.extractEnergy(amount, false);
            this.tile.func_70296_d();
            adjTile.func_70296_d();
            LibEvents.markForUpdate(pos.func_177972_a(dir), adjTile);
        }
    }

    @Override
    @Nonnull
    public String getModuleName() {
        return ENERGY_MODULE;
    }

    @Override
    public void onBroken(@Nonnull World world, @Nonnull BlockPos pos, @Nullable EntityPlayer player) {
    }

    @Override
    @Nonnull
    public Capability<IEnergyStorage> getCapabilityType() {
        return CapabilityEnergy.ENERGY;
    }

    public class EnergyIOProxy
    extends MysticalEnergyStorage {
        @Nonnull
        private EnumFacing face;
        @Nonnull
        private FaceConfig.FaceIO ioMode;

        public EnergyIOProxy(@Nonnull EnumFacing face, FaceConfig.FaceIO ioMode, int capacity, int maxReceive, int maxExtract, int energy) {
            super(capacity, maxReceive, maxExtract, energy);
            this.face = face;
            this.ioMode = ioMode;
        }

        public int getMaxEnergyStored() {
            return ModuleEnergy.this.battery.getMaxEnergyStored();
        }

        public int getEnergyStored() {
            return ModuleEnergy.this.battery.getEnergyStored();
        }

        public int receiveEnergy(int amount, boolean simulate) {
            if (this.ioMode == FaceConfig.FaceIO.IN || this.ioMode == FaceConfig.FaceIO.INOUT) {
                ModuleEnergy.this.tile.func_70296_d();
                return ModuleEnergy.this.battery.receiveEnergy(amount, simulate);
            }
            return 0;
        }

        public int extractEnergy(int amount, boolean simulate) {
            if (this.ioMode == FaceConfig.FaceIO.OUT || this.ioMode == FaceConfig.FaceIO.NEUTRAL || this.ioMode == FaceConfig.FaceIO.INOUT) {
                ModuleEnergy.this.tile.func_70296_d();
                return ModuleEnergy.this.battery.extractEnergy(amount, simulate);
            }
            return 0;
        }

        public boolean canReceive() {
            return super.canReceive() && (this.ioMode == FaceConfig.FaceIO.IN || this.ioMode == FaceConfig.FaceIO.INOUT);
        }

        public boolean canExtract() {
            return super.canExtract() && (this.ioMode == FaceConfig.FaceIO.OUT || this.ioMode == FaceConfig.FaceIO.INOUT);
        }
    }
}

