/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.tcon.texture;

import com.google.common.collect.Lists;
import java.awt.image.DirectColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.TinkerAPIException;
import twilightforest.TwilightForestMod;
import twilightforest.client.texture.GradientMappedTexture;
import twilightforest.client.texture.GradientNode;
import twilightforest.compat.tcon.texture.GradientMappedTConTexture;

public class FieryTConTexture
extends GradientMappedTConTexture {
    private final ResourceLocation textureIn;
    private boolean[] translucent;
    private boolean[] edge;
    private static final GradientNode[] outlineColors = new GradientNode[]{new GradientNode(0.0f, -1), new GradientNode(0.125f, -1386), new GradientNode(0.375f, -283356), new GradientNode(0.5f, -289244), new GradientNode(0.625f, -283356), new GradientNode(0.875f, -1386), new GradientNode(1.0f, -1)};
    public static final GradientNode[] innerColors = new GradientNode[]{new GradientNode(0.1f, -12836061), new GradientNode(0.7f, -15133933), new GradientNode(0.9f, -16251386)};
    private static final GradientNode[] innerColorsGlow = new GradientNode[]{new GradientNode(0.1f, -8964847), new GradientNode(0.7f, -10081015), new GradientNode(0.9f, -10672637)};
    private static final DirectColorModel colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);

    FieryTConTexture(ResourceLocation textureIn, String spriteName) {
        super(textureIn, spriteName, true, innerColors);
        this.textureIn = textureIn;
    }

    @Override
    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        this.field_110976_a = Lists.newArrayList();
        this.field_110973_g = 0;
        this.field_110983_h = 0;
        TextureAtlasSprite baseTexture = textureGetter.apply(this.textureIn);
        if (baseTexture == null || baseTexture.func_110970_k() <= 0) {
            this.field_130223_c = 1;
            this.field_130224_d = 1;
            return false;
        }
        this.func_94217_a(baseTexture);
        int[][] original = baseTexture.func_147965_a(0);
        int[][] data = new int[original.length][];
        int[][] dataSecondFrame = new int[original.length][];
        data[0] = Arrays.copyOf(original[0], original[0].length);
        dataSecondFrame[0] = Arrays.copyOf(original[0], original[0].length);
        try {
            this.preProcess(data[0]);
            for (int pxCoord = 0; pxCoord < data[0].length; ++pxCoord) {
                data[0][pxCoord] = this.colorPixel(data[0][pxCoord], pxCoord);
                this.gradientMap = innerColorsGlow;
                dataSecondFrame[0][pxCoord] = this.colorPixel(dataSecondFrame[0][pxCoord], pxCoord);
                this.gradientMap = innerColors;
            }
        }
        catch (Exception e) {
            throw new TinkerAPIException("Error occured while processing: " + this.func_94215_i(), (Throwable)e);
        }
        if (this.field_110976_a.isEmpty()) {
            this.field_110976_a.add(data);
            this.field_110976_a.add(dataSecondFrame);
        }
        ArrayList<AnimationFrame> frames = new ArrayList<AnimationFrame>();
        frames.add(new AnimationFrame(0));
        frames.add(new AnimationFrame(1));
        this.field_110982_k = new AnimationMetadataSection(frames, this.field_130223_c, this.field_130224_d, 18, true);
        TwilightForestMod.LOGGER.debug("Autogenerated " + this.func_94215_i() + " from " + this.textureIn);
        return false;
    }

    @Override
    protected void preProcess(int[] data) {
        this.edge = new boolean[this.field_130223_c * this.field_130224_d];
        this.translucent = new boolean[this.field_130223_c * this.field_130224_d];
        for (int x = 0; x < this.field_130223_c; ++x) {
            for (int y = 0; y < this.field_130224_d; ++y) {
                int c;
                if (x == 0 || y == 0 || x == this.field_130223_c - 1 || y == this.field_130224_d - 1) {
                    this.edge[this.coord((int)x, (int)y)] = true;
                }
                if ((c = data[this.coord(x, y)]) != 0 && colorModel.getAlpha(c) >= 64) continue;
                this.translucent[this.coord((int)x, (int)y)] = true;
                if (x > 0) {
                    this.edge[this.coord((int)(x - 1), (int)y)] = true;
                }
                if (y > 0) {
                    this.edge[this.coord((int)x, (int)(y - 1))] = true;
                }
                if (x < this.field_130223_c - 1) {
                    this.edge[this.coord((int)(x + 1), (int)y)] = true;
                }
                if (y >= this.field_130224_d - 1) continue;
                this.edge[this.coord((int)x, (int)(y + 1))] = true;
            }
        }
        int minimumValue = 255;
        int maximumValue = 0;
        for (int i = 0; i < data.length; ++i) {
            int pixel = data[i];
            if (this.edge[i] || this.translucent[i]) continue;
            minimumValue = Math.min(minimumValue, FieryTConTexture.getPerceptualBrightness((int)pixel));
            maximumValue = Math.max(maximumValue, FieryTConTexture.getPerceptualBrightness((int)pixel));
        }
        if (minimumValue > maximumValue) {
            this.minimumValue = (float)maximumValue / 255.0f;
            this.maximumValue = (float)minimumValue / 255.0f;
        } else {
            this.minimumValue = (float)minimumValue / 255.0f;
            this.maximumValue = (float)maximumValue / 255.0f;
        }
    }

    @Override
    protected int colorPixel(int pixel, int pxCoord) {
        if (!this.translucent[pxCoord] && this.edge[pxCoord]) {
            int ff = 255;
            int x = this.getX(pxCoord) * 255 / this.field_130223_c;
            int y = this.getY(pxCoord) * 255 / this.field_130224_d;
            int gray = ((Object)((Object)this)).hashCode() + x - y & ff;
            return GradientMappedTexture.getGradient(ff << 24 | gray << 16 | gray << 8 | gray, outlineColors, 0.0f, 1.0f);
        }
        return super.colorPixel(pixel, pxCoord);
    }
}

