/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.client.IRenderHandler;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.biomes.TFBiomeDarkForest;
import twilightforest.biomes.TFBiomeFinalPlateau;
import twilightforest.biomes.TFBiomeFireSwamp;
import twilightforest.biomes.TFBiomeGlacier;
import twilightforest.biomes.TFBiomeHighlands;
import twilightforest.biomes.TFBiomeSnow;
import twilightforest.biomes.TFBiomeSwamp;
import twilightforest.biomes.TFBiomeThornlands;

public class TFWeatherRenderer
extends IRenderHandler {
    private static final ResourceLocation RAIN_TEXTURES = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation SNOW_TEXTURES = new ResourceLocation("textures/environment/snow.png");
    private static final ResourceLocation locationBlizzardPng = new ResourceLocation("twilightforest:textures/environment/blizzard.png");
    private static final ResourceLocation locationMosquitoPng = new ResourceLocation("twilightforest:textures/environment/mosquitoes.png");
    private static final ResourceLocation locationAshesPng = new ResourceLocation("twilightforest:textures/environment/ashes.png");
    private static final ResourceLocation locationDarkstreamPng = new ResourceLocation("twilightforest:textures/environment/darkstream.png");
    private static final ResourceLocation locationBigrainPng = new ResourceLocation("twilightforest:textures/environment/bigrain.png");
    private static final ResourceLocation locationSparklesPng = new ResourceLocation("twilightforest:textures/environment/sparkles.png");
    private final float[] rainxs = new float[1024];
    private final float[] rainys = new float[1024];
    private final Random random = new Random();
    private int rendererUpdateCount;
    private StructureBoundingBox protectedBox;

    public TFWeatherRenderer() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainxs[i << 5 | j] = -f1 / f2;
                this.rainys[i << 5 | j] = f / f2;
            }
        }
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        ++this.rendererUpdateCount;
        this.renderNormalWeather(partialTicks, mc);
        if (world.func_82736_K().func_82766_b("tfEnforcedProgression") && !mc.field_71439_g.func_184812_l_() && !mc.field_71439_g.func_175149_v()) {
            this.renderLockedBiome(partialTicks, world, mc);
            this.renderLockedStructure(partialTicks, world, mc);
        }
    }

    private void renderNormalWeather(float partialTicks, Minecraft mc) {
        float f = mc.field_71441_e.func_72867_j(partialTicks);
        if (f > 0.0f) {
            mc.field_71460_t.func_180436_i();
            Entity entity = mc.func_175606_aa();
            WorldClient world = mc.field_71441_e;
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)entity.field_70163_u);
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            int l = MathHelper.func_76128_c((double)d1);
            int i1 = 5;
            if (mc.field_71474_y.field_74347_j) {
                i1 = 10;
            }
            int j1 = -1;
            float f1 = (float)this.rendererUpdateCount + partialTicks;
            vertexbuffer.func_178969_c(-d0, -d1, -d2);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)this.rainxs[i2] * 0.5;
                    double d4 = (double)this.rainys[i2] * 0.5;
                    blockpos$mutableblockpos.func_181079_c(l1, 0, k1);
                    Biome biome = world.func_180494_b((BlockPos)blockpos$mutableblockpos);
                    if (!biome.func_76738_d() && !biome.func_76746_c()) continue;
                    int j2 = world.func_175725_q((BlockPos)blockpos$mutableblockpos).func_177956_o();
                    int k2 = j - i1;
                    int l2 = j + i1;
                    if (k2 < j2) {
                        k2 = j2;
                    }
                    if (l2 < j2) {
                        l2 = j2;
                    }
                    int i3 = j2;
                    if (j2 < l) {
                        i3 = l;
                    }
                    if (k2 == l2) continue;
                    this.random.setSeed(l1 * l1 * 3121 + l1 * 45238971 ^ k1 * k1 * 418711 + k1 * 13761);
                    blockpos$mutableblockpos.func_181079_c(l1, k2, k1);
                    float f2 = biome.func_180626_a((BlockPos)blockpos$mutableblockpos);
                    if (world.func_72959_q().func_76939_a(f2, j2) >= 0.15f) {
                        if (j1 != 0) {
                            if (j1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            j1 = 0;
                            mc.func_110434_K().func_110577_a(RAIN_TEXTURES);
                            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        double d5 = -((double)(this.rendererUpdateCount + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.random.nextDouble());
                        double d6 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                        double d7 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                        float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)i1;
                        float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                        blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                        int j3 = world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
                        int k3 = j3 >> 16 & 0xFFFF;
                        int l3 = j3 & 0xFFFF;
                        vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        continue;
                    }
                    if (j1 != 1) {
                        if (j1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        j1 = 1;
                        mc.func_110434_K().func_110577_a(SNOW_TEXTURES);
                        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    double d8 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                    double d9 = this.random.nextDouble() + (double)f1 * 0.01 * (double)((float)this.random.nextGaussian());
                    double d10 = this.random.nextDouble() + (double)(f1 * (float)this.random.nextGaussian()) * 0.001;
                    double d11 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                    double d12 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                    float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)i1;
                    float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                    int i4 = (world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0) * 3 + 0xF000F0) / 4;
                    int j4 = i4 >> 16 & 0xFFFF;
                    int k4 = i4 & 0xFFFF;
                    vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                }
            }
            if (j1 >= 0) {
                tessellator.func_78381_a();
            }
            vertexbuffer.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            mc.field_71460_t.func_175072_h();
        }
    }

    private void renderLockedBiome(float partialTicks, WorldClient wc, Minecraft mc) {
        if (this.isNearLockedBiome((World)wc, mc.func_175606_aa())) {
            mc.field_71460_t.func_180436_i();
            Entity entity = mc.func_175606_aa();
            WorldClient world = mc.field_71441_e;
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)entity.field_70163_u);
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            int l = MathHelper.func_76128_c((double)d1);
            int i1 = 5;
            if (mc.field_71474_y.field_74347_j) {
                i1 = 10;
            }
            int j1 = -1;
            float f1 = (float)this.rendererUpdateCount + partialTicks;
            vertexbuffer.func_178969_c(-d0, -d1, -d2);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    float f5;
                    double d10;
                    double d9;
                    double d8;
                    int l3;
                    int k3;
                    int j3;
                    float f4;
                    float f3;
                    double d7;
                    double d6;
                    double d5;
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)this.rainxs[i2] * 0.5;
                    double d4 = (double)this.rainys[i2] * 0.5;
                    blockpos$mutableblockpos.func_181079_c(l1, 0, k1);
                    Biome biome = world.func_180494_b((BlockPos)blockpos$mutableblockpos);
                    if (!(biome instanceof TFBiomeBase) || !(entity instanceof EntityPlayer) || ((TFBiomeBase)biome).doesPlayerHaveRequiredAchievement((EntityPlayer)entity)) continue;
                    int j2 = 0;
                    int k2 = j - i1;
                    int l2 = j + i1;
                    if (k2 < j2) {
                        k2 = j2;
                    }
                    if (l2 < j2) {
                        l2 = j2;
                    }
                    int i3 = j2;
                    if (j2 < l) {
                        i3 = l;
                    }
                    if (k2 == l2) continue;
                    this.random.setSeed(l1 * l1 * 3121 + l1 * 45238971 ^ k1 * k1 * 418711 + k1 * 13761);
                    blockpos$mutableblockpos.func_181079_c(l1, k2, k1);
                    float f2 = biome.func_180626_a((BlockPos)blockpos$mutableblockpos);
                    if (biome instanceof TFBiomeSnow || biome instanceof TFBiomeGlacier) {
                        if (j1 != 0) {
                            if (j1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            j1 = 0;
                            mc.func_110434_K().func_110577_a(locationBlizzardPng);
                            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        d5 = -((double)(this.rendererUpdateCount + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.random.nextDouble());
                        d6 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                        d7 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                        f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)i1;
                        f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * 1.0f;
                        blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                        j3 = world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
                        k3 = j3 >> 16 & 0xFFFF;
                        l3 = j3 & 0xFFFF;
                        vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                        continue;
                    }
                    if (biome instanceof TFBiomeSwamp) {
                        if (j1 != 1) {
                            if (j1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            j1 = 1;
                            mc.func_110434_K().func_110577_a(locationMosquitoPng);
                            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        d8 = 0.0;
                        d9 = this.random.nextDouble() + (double)f1 * 0.01 * (double)((float)this.random.nextGaussian());
                        d10 = this.random.nextDouble() + (double)(f1 * (float)this.random.nextGaussian()) * 0.001;
                        double d11 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                        double d12 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                        float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)i1;
                        float r = this.random.nextFloat() * 0.3f;
                        float g = this.random.nextFloat() * 0.3f;
                        float b = this.random.nextFloat() * 0.3f;
                        float f52 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * 1.0f;
                        blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                        int i4 = 0xF000F0;
                        int j4 = i4 >> 16 & 0xFFFF;
                        int k4 = i4 & 0xFFFF;
                        vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(r, g, b, f52).func_187314_a(j4, k4).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(r, g, b, f52).func_187314_a(j4, k4).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(r, g, b, f52).func_187314_a(j4, k4).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(r, g, b, f52).func_187314_a(j4, k4).func_181675_d();
                        continue;
                    }
                    if (biome instanceof TFBiomeFireSwamp) {
                        if (j1 != 2) {
                            if (j1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            j1 = 2;
                            mc.func_110434_K().func_110577_a(locationAshesPng);
                            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        d8 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                        d9 = this.random.nextDouble() + (double)f1 * 0.01 * (double)((float)this.random.nextGaussian());
                        d10 = this.random.nextDouble() + (double)(f1 * (float)this.random.nextGaussian()) * 0.001;
                        double d11 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                        double d12 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                        float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)i1;
                        f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * 1.0f;
                        blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                        int i4 = 0xF000F0;
                        int j4 = i4 >> 16 & 0xFFFF;
                        int k4 = i4 & 0xFFFF;
                        float color = this.random.nextFloat() * 0.2f + 0.8f;
                        vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(color, color, color, f5).func_187314_a(j4, k4).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(color, color, color, f5).func_187314_a(j4, k4).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(color, color, color, f5).func_187314_a(j4, k4).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(color, color, color, f5).func_187314_a(j4, k4).func_181675_d();
                        continue;
                    }
                    if (biome instanceof TFBiomeDarkForest && this.random.nextInt(2) == 0) {
                        if (j1 != 3) {
                            if (j1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            j1 = 3;
                            mc.func_110434_K().func_110577_a(locationDarkstreamPng);
                            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        d8 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                        d9 = 0.0;
                        d10 = this.random.nextDouble() + (double)(f1 * (float)this.random.nextGaussian()) * 0.001;
                        double d11 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                        double d12 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                        float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)i1;
                        f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * this.random.nextFloat();
                        blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                        int i4 = 0xF000F0;
                        int j4 = i4 >> 16 & 0xFFFF;
                        int k4 = i4 & 0xFFFF;
                        vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                        vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                        continue;
                    }
                    if (!(biome instanceof TFBiomeHighlands) && !(biome instanceof TFBiomeThornlands) && !(biome instanceof TFBiomeFinalPlateau)) continue;
                    if (j1 != 4) {
                        if (j1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        j1 = 4;
                        mc.func_110434_K().func_110577_a(locationBigrainPng);
                        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    d5 = -((double)(this.rendererUpdateCount + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.random.nextDouble());
                    d6 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                    d7 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                    f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)i1;
                    f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * 1.0f;
                    blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                    j3 = world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
                    k3 = j3 >> 16 & 0xFFFF;
                    l3 = j3 & 0xFFFF;
                    vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                    vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                    vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                    vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                }
            }
            if (j1 >= 0) {
                tessellator.func_78381_a();
            }
            vertexbuffer.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            mc.field_71460_t.func_175072_h();
        }
    }

    private void renderLockedStructure(float partialTicks, WorldClient wc, Minecraft mc) {
        if (this.isNearLockedStructure((World)wc, mc.func_175606_aa())) {
            mc.field_71460_t.func_180436_i();
            Entity entity = mc.func_175606_aa();
            WorldClient world = mc.field_71441_e;
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)entity.field_70163_u);
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            int l = MathHelper.func_76128_c((double)d1);
            int i1 = 5;
            if (mc.field_71474_y.field_74347_j) {
                i1 = 10;
            }
            int j1 = -1;
            float f1 = (float)this.rendererUpdateCount + partialTicks;
            vertexbuffer.func_178969_c(-d0, -d1, -d2);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)this.rainxs[i2] * 0.5;
                    double d4 = (double)this.rainys[i2] * 0.5;
                    if (this.protectedBox == null || !this.protectedBox.func_78885_a(l1, k1, l1, k1)) continue;
                    int structureMin = this.protectedBox.field_78895_b - 4;
                    int structureMax = this.protectedBox.field_78894_e + 4;
                    int k2 = j - i1;
                    int l2 = j + i1 * 2;
                    if (k2 < structureMin) {
                        k2 = structureMin;
                    }
                    if (l2 < structureMin) {
                        l2 = structureMin;
                    }
                    if (k2 > structureMax) {
                        k2 = structureMax;
                    }
                    if (l2 > structureMax) {
                        l2 = structureMax;
                    }
                    if (k2 == l2) continue;
                    this.random.setSeed(l1 * l1 * 3121 + l1 * 45238971 ^ k1 * k1 * 418711 + k1 * 13761);
                    blockpos$mutableblockpos.func_181079_c(l1, k2, k1);
                    if (j1 != 0) {
                        if (j1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        j1 = 0;
                        mc.func_110434_K().func_110577_a(locationSparklesPng);
                        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    double d5 = -((double)(this.rendererUpdateCount + l1 * l1 * 3121 + l1 * 45238971 + k1 * k1 * 418711 + k1 * 13761 & 0x1F) + (double)partialTicks) / 32.0 * (3.0 + this.random.nextDouble());
                    double d6 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                    double d7 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                    float f3 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7)) / (float)i1;
                    float f = this.random.nextFloat();
                    float f4 = ((1.0f - f3 * f3) * 0.5f + 0.5f) * f;
                    int j3 = 0xF000F0;
                    int k3 = j3 >> 16 & 0xFFFF;
                    int l3 = j3 & 0xFFFF;
                    vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                    vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)k2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                    vertexbuffer.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                    vertexbuffer.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0, (double)l2 * 0.25 + d5).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_187314_a(k3, l3).func_181675_d();
                }
            }
            if (j1 >= 0) {
                tessellator.func_78381_a();
            }
            vertexbuffer.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            mc.field_71460_t.func_175072_h();
        }
    }

    private boolean isNearLockedBiome(World world, Entity viewEntity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int range = 15;
        int px = MathHelper.func_76128_c((double)viewEntity.field_70165_t);
        int pz = MathHelper.func_76128_c((double)viewEntity.field_70161_v);
        for (int z = pz - range; z <= pz + range; ++z) {
            for (int x = px - range; x <= px + range; ++x) {
                EntityPlayer player;
                TFBiomeBase tfBiome;
                Biome biomegenbase = world.func_180494_b((BlockPos)pos.func_181079_c(x, 0, z));
                if (!(biomegenbase instanceof TFBiomeBase) || !(viewEntity instanceof EntityPlayer) || (tfBiome = (TFBiomeBase)biomegenbase).doesPlayerHaveRequiredAchievement(player = (EntityPlayer)viewEntity)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNearLockedStructure(World world, Entity viewEntity) {
        int range = 15;
        int px = MathHelper.func_76128_c((double)viewEntity.field_70165_t);
        int pz = MathHelper.func_76128_c((double)viewEntity.field_70161_v);
        return this.protectedBox != null && this.protectedBox.func_78885_a(px - range, pz - range, px + range, pz + range);
    }

    public void setProtectedBox(StructureBoundingBox protectedBox) {
        this.protectedBox = protectedBox;
    }
}

