/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.deepresonance.network.ReturnTankInfoHelper;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketReturnTankInfo
implements IMessage {
    private int amount;
    private int capacity;
    private String fluidName;
    private NBTTagCompound tag;

    public void fromBytes(ByteBuf buf) {
        this.amount = buf.readInt();
        this.capacity = buf.readInt();
        this.fluidName = NetworkTools.readString((ByteBuf)buf);
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.amount);
        buf.writeInt(this.capacity);
        NetworkTools.writeString((ByteBuf)buf, (String)this.fluidName);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public NBTTagCompound getTag() {
        return this.tag;
    }

    public String getFluidName() {
        return this.fluidName;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public PacketReturnTankInfo() {
    }

    public PacketReturnTankInfo(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketReturnTankInfo(int amount, int capacity, String fluidName, NBTTagCompound tag) {
        this.amount = amount;
        this.capacity = capacity;
        this.fluidName = fluidName;
        this.tag = tag;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> ReturnTankInfoHelper.setEnergyLevel(this));
        ctx.setPacketHandled(true);
    }
}

