/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.generator;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import mcjty.deepresonance.blocks.generator.GeneratorBlock;
import mcjty.deepresonance.blocks.generator.GeneratorConfiguration;
import mcjty.deepresonance.blocks.generator.GeneratorSetup;
import mcjty.deepresonance.generatornetwork.DRGeneratorNetwork;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.EnergyTools;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class GeneratorTileEntity
extends GenericTileEntity
implements ITickable,
IEnergyStorage {
    private int networkId = -1;

    public void addBlockToNetwork() {
        HashSet<Integer> adjacentGeneratorIds = new HashSet<Integer>();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            BlockPos pos = this.func_174877_v().func_177972_a(direction);
            Block block = this.func_145831_w().func_180495_p(pos).func_177230_c();
            if (block != GeneratorSetup.generatorBlock) continue;
            GeneratorTileEntity generatorTileEntity = (GeneratorTileEntity)this.func_145831_w().func_175625_s(pos);
            adjacentGeneratorIds.add(generatorTileEntity.getNetworkId());
        }
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.func_145831_w());
        if (adjacentGeneratorIds.isEmpty()) {
            this.networkId = generatorNetwork.newChannel();
            DRGeneratorNetwork.Network network = generatorNetwork.getOrCreateNetwork(this.networkId);
            network.setGeneratorBlocks(1);
        } else if (adjacentGeneratorIds.size() == 1) {
            this.networkId = (Integer)adjacentGeneratorIds.iterator().next();
            DRGeneratorNetwork.Network network = generatorNetwork.getOrCreateNetwork(this.networkId);
            network.setActive(false);
            network.incGeneratorBlocks();
        } else {
            DRGeneratorNetwork.Network network;
            int energy = 0;
            for (Integer netId : adjacentGeneratorIds) {
                network = generatorNetwork.getOrCreateNetwork(netId);
                network.setActive(false);
                energy += network.getEnergy();
            }
            int id = (Integer)adjacentGeneratorIds.iterator().next();
            HashSet done = Sets.newHashSet();
            this.setBlocksToNetwork(this.field_174879_c, done, id);
            network = generatorNetwork.getOrCreateNetwork(this.networkId);
            network.setEnergy(energy);
        }
        generatorNetwork.save();
    }

    private void setBlocksToNetwork(BlockPos c, Set<BlockPos> done, int newId) {
        done.add(c);
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.func_145831_w());
        GeneratorTileEntity generatorTileEntity = (GeneratorTileEntity)this.func_145831_w().func_175625_s(c);
        int oldNetworkId = generatorTileEntity.getNetworkId();
        if (oldNetworkId != newId) {
            if (oldNetworkId != -1) {
                generatorNetwork.getOrCreateNetwork(oldNetworkId).decGeneratorBlocks();
            }
            generatorTileEntity.setNetworkId(newId);
            if (newId != -1) {
                generatorNetwork.getOrCreateNetwork(newId).incGeneratorBlocks();
            }
        }
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            Block block;
            BlockPos newC = c.func_177972_a(direction);
            if (done.contains(newC) || (block = this.func_145831_w().func_180495_p(newC).func_177230_c()) != GeneratorSetup.generatorBlock) continue;
            this.setBlocksToNetwork(newC, done, newId);
        }
    }

    public void removeBlockFromNetwork() {
        DRGeneratorNetwork generatorNetwork;
        int totalEnergy = 0;
        int totalBlocks = 0;
        if (this.networkId != -1) {
            generatorNetwork = DRGeneratorNetwork.getChannels(this.func_145831_w());
            EnumFacing[] network = generatorNetwork.getOrCreateNetwork(this.networkId);
            network.setActive(false);
            network.decGeneratorBlocks();
            totalEnergy = network.getEnergy();
            totalBlocks = network.getGeneratorBlocks();
            this.setNetworkId(-1);
        }
        if (totalBlocks < 1) {
            totalBlocks = 1;
        }
        generatorNetwork = DRGeneratorNetwork.getChannels(this.func_145831_w());
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            BlockPos newC = this.func_174877_v().func_177972_a(direction);
            Block block = this.func_145831_w().func_180495_p(newC).func_177230_c();
            if (block != GeneratorSetup.generatorBlock) continue;
            HashSet done = Sets.newHashSet();
            done.add(this.field_174879_c);
            this.setBlocksToNetwork(newC, done, -1);
        }
        int idToUse = this.networkId;
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            GeneratorTileEntity generatorTileEntity;
            BlockPos newC = this.func_174877_v().func_177972_a(direction);
            Block block = this.func_145831_w().func_180495_p(newC).func_177230_c();
            if (block != GeneratorSetup.generatorBlock || (generatorTileEntity = (GeneratorTileEntity)this.func_145831_w().func_175625_s(newC)).getNetworkId() != -1) continue;
            if (idToUse == -1) {
                idToUse = generatorNetwork.newChannel();
            }
            HashSet done = Sets.newHashSet();
            done.add(this.func_174877_v());
            this.setBlocksToNetwork(newC, done, idToUse);
            generatorNetwork.getOrCreateNetwork(idToUse).setEnergy(-1);
            idToUse = -1;
        }
        int energy = totalEnergy / totalBlocks;
        int remainder = totalEnergy % totalBlocks;
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            GeneratorTileEntity generatorTileEntity;
            DRGeneratorNetwork.Network network;
            BlockPos newC = this.func_174877_v().func_177972_a(direction);
            Block block = this.func_145831_w().func_180495_p(newC).func_177230_c();
            if (block != GeneratorSetup.generatorBlock || (network = (generatorTileEntity = (GeneratorTileEntity)this.func_145831_w().func_175625_s(newC)).getNetwork()).getEnergy() != -1) continue;
            network.setEnergy(energy * network.getGeneratorBlocks() + remainder);
            remainder = 0;
        }
        generatorNetwork.save();
    }

    public void setNetworkId(int newId) {
        this.networkId = newId;
        this.func_70296_d();
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public DRGeneratorNetwork.Network getNetwork() {
        if (this.networkId == -1) {
            return null;
        }
        DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.func_145831_w());
        return generatorNetwork.getOrCreateNetwork(this.networkId);
    }

    public void activate(boolean active) {
        DRGeneratorNetwork.Network network = this.getNetwork();
        if (network != null && network.isActive() != active) {
            network.setActive(active);
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(this.func_145831_w());
            generatorNetwork.save();
            HashSet done = Sets.newHashSet();
            this.activateBlocks(this.func_174877_v(), done, active);
        }
    }

    private void activateBlocks(BlockPos c, Set<BlockPos> done, boolean active) {
        done.add(c);
        IBlockState state = this.func_145831_w().func_180495_p(c);
        if ((Boolean)state.func_177229_b((IProperty)GeneratorBlock.ENABLED) != active) {
            this.func_145831_w().func_180501_a(c, state.func_177226_a((IProperty)GeneratorBlock.ENABLED, (Comparable)Boolean.valueOf(active)), 3);
        }
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            Block block;
            BlockPos newC = c.func_177972_a(direction);
            if (done.contains(newC) || (block = this.func_145831_w().func_180495_p(newC).func_177230_c()) != GeneratorSetup.generatorBlock) continue;
            this.activateBlocks(newC, done, active);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.networkId = tagCompound.func_74762_e("networkId");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("networkId", this.networkId);
        return tagCompound;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        int energyStored = this.getEnergyStored();
        if (energyStored <= 0) {
            return;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            int rfToGive;
            int received;
            EnumFacing opposite;
            BlockPos pos = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(pos);
            if (EnergyTools.isEnergyTE((TileEntity)te, (EnumFacing)(opposite = facing.func_176734_d())) && (energyStored -= this.extractEnergy(received = (int)EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (long)(rfToGive = Math.min(GeneratorConfiguration.rfPerTickGenerator, energyStored))), false)) <= 0) break;
        }
    }

    private int extraEnergyInternal(int maxExtract, boolean simulate) {
        if (this.networkId == -1) {
            return 0;
        }
        DRGeneratorNetwork.Network network = this.getNetwork();
        int energy = network.getEnergy();
        if (maxExtract > energy) {
            maxExtract = energy;
        }
        if (maxExtract > GeneratorConfiguration.rfPerTickGenerator) {
            maxExtract = GeneratorConfiguration.rfPerTickGenerator;
        }
        if (!simulate) {
            network.setEnergy(energy - maxExtract);
            DRGeneratorNetwork.getChannels(this.func_145831_w()).save();
        }
        return maxExtract;
    }

    private int getEnergyStoredInternal() {
        if (this.networkId == -1) {
            return 0;
        }
        DRGeneratorNetwork.Network network = this.getNetwork();
        return network.getEnergy();
    }

    private int getMaxEnergyStoredInternal() {
        if (this.networkId == -1) {
            return 0;
        }
        DRGeneratorNetwork.Network network = this.getNetwork();
        return network.getGeneratorBlocks() * GeneratorConfiguration.rfPerGeneratorBlock;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.extraEnergyInternal(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.getEnergyStoredInternal();
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStoredInternal();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

