/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect;

import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.tile.TileRitualLink;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.ILocatable;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ConstellationEffect
extends ConfigEntry {
    protected static final Random rand = new Random();
    private final IWeakConstellation constellation;
    protected final ILocatable origin;

    public ConstellationEffect(@Nullable ILocatable origin, IWeakConstellation constellation, String cfgName) {
        super(ConfigEntry.Section.RITUAL_EFFECTS, cfgName);
        this.origin = origin;
        this.constellation = constellation;
    }

    public IWeakConstellation getConstellation() {
        return this.constellation;
    }

    @SideOnly(value=Side.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float percEffectVisibility, boolean extendedEffects) {
    }

    public abstract boolean playEffect(World var1, BlockPos var2, float var3, ConstellationEffectProperties var4, @Nullable IMinorConstellation var5);

    @Nullable
    public TileRitualPedestal getPedestal(World world, BlockPos pos) {
        TileEntity te = MiscUtils.getTileAt((IBlockAccess)world, pos, TileEntity.class, false);
        if (te == null) {
            return null;
        }
        if (te instanceof TileRitualLink) {
            TileRitualLink link = (TileRitualLink)te;
            pos = link.getLinkedTo();
            return MiscUtils.getTileAt((IBlockAccess)world, pos, TileRitualPedestal.class, false);
        }
        return te instanceof TileRitualPedestal ? (TileRitualPedestal)te : null;
    }

    public abstract ConstellationEffectProperties provideProperties(int var1);

    public void clearCache() {
    }

    public void readFromNBT(NBTTagCompound cmp) {
    }

    public void writeToNBT(NBTTagCompound cmp) {
    }

    @Nullable
    public EntityPlayer getOwningPlayerInWorld(World world, BlockPos pos) {
        TileRitualPedestal pedestal = this.getPedestal(world, pos);
        if (pedestal != null) {
            return pedestal.getOwningPlayerInWorld(world);
        }
        return null;
    }
}

