/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.cape.impl;

import hellfirepvp.astralsorcery.common.base.MeltInteraction;
import hellfirepvp.astralsorcery.common.base.WorldMeltables;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.cape.CapeArmorEffect;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CapeEffectFornax
extends CapeArmorEffect {
    private static float fireMultiplier = 0.4f;
    private static float healMultiplier = 0.4f;
    private static boolean burningMelt = true;

    public CapeEffectFornax(NBTTagCompound cmp) {
        super(cmp, "fornax");
    }

    @Override
    public IConstellation getAssociatedConstellation() {
        return Constellations.fornax;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playActiveParticleTick(EntityPlayer pl) {
        float chance = 0.4f;
        if (pl.func_70027_ad()) {
            chance = 0.9f;
        }
        this.playConstellationCapeSparkles(pl, chance);
    }

    public void attemptMelt(EntityPlayer pl) {
        if (burningMelt && pl.func_70027_ad()) {
            BlockPos at = pl.func_180425_c().func_177977_b();
            MeltInteraction mi = WorldMeltables.getMeltable(pl.func_130014_f_(), at);
            if (mi != null) {
                PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_MELT_BLOCK, (Vec3i)at);
                PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(pl.func_130014_f_(), (Vec3i)at, 16.0));
                if ((double)rand.nextFloat() < 0.1) {
                    mi.placeResultAt(pl.func_130014_f_(), at);
                }
            }
        }
    }

    public float getDamageMultiplier() {
        return fireMultiplier;
    }

    public void healFor(EntityPlayer player, float amount) {
        player.func_70691_i(amount * healMultiplier);
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        burningMelt = cfg.getBoolean(this.getKey() + "BurningMelt", this.getConfigurationSection(), burningMelt, "If a player burns while wearing the cape, this toggles if blocks below him then melt (true) or not. (false)");
        fireMultiplier = cfg.getFloat(this.getKey() + "FireDmgMultiplier", this.getConfigurationSection(), fireMultiplier, 0.0f, 1.0f, "Sets the multiplier for how much damage you take from fire damage while wearing a fornax cape");
        healMultiplier = cfg.getFloat(this.getKey() + "FireHealMultiplier", this.getConfigurationSection(), healMultiplier, 0.0f, 5.0f, "Sets the multiplier for how much healing the player receives from the original damage when being hit by fire damage.");
    }
}

