/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.icon;

import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;

public class IconWrapper {
    private static final Map<Icon, ImageIcon> CACHE = new HashMap<Icon, ImageIcon>();

    public static void clearCache() {
        CACHE.clear();
    }

    public static ImageIcon from(@Nullable Icon icon) {
        if (icon == null) {
            return IconWrapper.from(GuiIcons.REMOVE_GRAY);
        }
        try {
            if (icon.canBeCached()) {
                ImageIcon i = CACHE.get(icon);
                if (i == null) {
                    try {
                        i = new ImageIcon(icon.readImage());
                    }
                    catch (Exception ex) {
                        i = new ImageIcon(Color4I.BLACK.readImage());
                    }
                    CACHE.put(icon, i);
                }
                return i;
            }
            return new ImageIcon(icon.readImage());
        }
        catch (Exception ex) {
            return IconWrapper.from(GuiIcons.REMOVE_GRAY);
        }
    }
}

