/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.plugins.bloodmagic;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import ipsis.Woot;
import ipsis.woot.plugins.bloodmagic.BloodMagicHelper;
import ipsis.woot.plugins.bloodmagic.IBloodMagicHandler;
import ipsis.woot.tileentity.TileEntityMobFactoryHeart;
import ipsis.woot.util.DebugSetup;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

@RitualRegister(value="ritualLifeEssenceTank")
public class RitualLifeEssenceTank
extends Ritual {
    private static final String RITUAL_NAME = "ritualLifeEssenceTank";
    private static final int CRYSTAL_LEVEL = 0;
    private static final int ACTIVATION_COST = 40000;
    private static final int REFRESH_COST = 2;
    private static final int REFRESH_TIME = 40;
    private static final String HEART_RANGE = "heart";
    private BlockPos heartOffsetPos = new BlockPos(0, 0, 0);

    public RitualLifeEssenceTank() {
        super(RITUAL_NAME, 0, 40000, "ritual.woot.ritualLifeEssenceTank");
        this.addBlockRange(HEART_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), 21));
    }

    private boolean isValidFactory(TileEntity te) {
        if (!(te instanceof TileEntityMobFactoryHeart)) {
            return false;
        }
        TileEntityMobFactoryHeart heart = (TileEntityMobFactoryHeart)te;
        return heart.getRunning() == 1;
    }

    private IBloodMagicHandler findHandler(World world, BlockPos pos) {
        BlockPos heartPos = pos.func_177971_a((Vec3i)this.heartOffsetPos);
        TileEntity te = world.func_175625_s(heartPos);
        AreaDescriptor heartRange = this.getBlockRange(HEART_RANGE);
        if (!heartRange.isWithinArea(this.heartOffsetPos) || !this.isValidFactory(te)) {
            for (BlockPos newPos : heartRange.getContainedPositions(pos)) {
                TileEntity nextTile = world.func_175625_s(newPos);
                if (!(nextTile instanceof IBloodMagicHandler)) continue;
                te = nextTile;
                this.heartOffsetPos = newPos.func_177973_b((Vec3i)pos);
                heartRange.resetCache();
                break;
            }
        }
        return this.isValidFactory(te) && te instanceof IBloodMagicHandler ? (IBloodMagicHandler)te : null;
    }

    public void performRitual(IMasterRitualStone masterRitualStone) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_LE, "performRitual - LifeEssenceTank", "");
        if (!BloodMagicHelper.canPerformRitual(masterRitualStone, this.getRefreshCost())) {
            return;
        }
        World world = masterRitualStone.getWorldObj();
        IBloodMagicHandler iBloodMagicHandler = this.findHandler(world, masterRitualStone.getBlockPos());
        if (iBloodMagicHandler != null) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_LE, "performRitual - LifeEssenceTank", "keepAlive");
            iBloodMagicHandler.keepAliveTankRitual();
        }
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_LE, "performRitual - LifeEssenceTank", "syphon:" + this.getRefreshCost());
        SoulNetwork network = NetworkHelper.getSoulNetwork((UUID)masterRitualStone.getOwner());
        network.syphon(this.getRefreshCost());
    }

    public int getRefreshCost() {
        return 2;
    }

    public int getRefreshTime() {
        return 40;
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addParallelRunes(components, 2, -1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 2, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 1, -1, EnumRuneType.WATER);
        this.addCornerRunes(components, 1, 1, EnumRuneType.WATER);
        this.addParallelRunes(components, 2, 1, EnumRuneType.AIR);
        this.addParallelRunes(components, 1, -2, EnumRuneType.WATER);
    }

    public Ritual getNewCopy() {
        return new RitualLifeEssenceTank();
    }
}

