/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.plugin.jei;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.plugin.jei.EnderStorageJEIPlugin;
import codechicken.enderstorage.recipe.Factories;
import codechicken.enderstorage.recipe.RecipeBase;
import codechicken.enderstorage.util.LogHelper;
import codechicken.lib.colour.EnumColour;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class ESCraftingRecipeWrapper
implements IRecipeWrapper,
ICustomCraftingRecipeWrapper {
    private final List<ItemStack> output;
    private final List<List<ItemStack>> inputs;
    private final RecipeBase recipe;
    private final int woolIndex;
    private final Map<EnumColour, List<ItemStack>> woolOres = new HashMap<EnumColour, List<ItemStack>>();

    public ESCraftingRecipeWrapper(RecipeBase recipe) {
        this.recipe = recipe;
        ItemStack outputStack = recipe.func_77571_b();
        this.inputs = new LinkedList<List<ItemStack>>();
        LinkedList wools = new LinkedList();
        for (EnumColour colour : EnumColour.values()) {
            NonNullList wool = OreDictionary.getOres((String)colour.getWoolOreName());
            wools.addAll(wool);
            this.woolOres.put(colour, (List<ItemStack>)wool);
        }
        NonNullList<Ingredient> ingredients = recipe.func_192400_c();
        int woolIndex = 0;
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            LinkedList stacks = new LinkedList();
            if (ingredient instanceof Factories.MultiIngredient) {
                woolIndex = i;
                stacks.addAll(wools);
            } else {
                Collections.addAll(stacks, ingredient.func_193365_a());
            }
            this.inputs.add(stacks);
        }
        this.woolIndex = woolIndex;
        this.output = new LinkedList<ItemStack>();
        for (ItemStack stack : wools) {
            EnumColour colour = EnumColour.fromWoolStack((ItemStack)stack);
            if (colour != null) {
                Frequency frequency = new Frequency(colour, colour, colour);
                this.output.add(frequency.writeToStack(outputStack.func_77946_l()));
                continue;
            }
            LogHelper.log(Level.WARN, "Colour is null for known wool stack.. wot. {}", stack);
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutput(ItemStack.class, this.output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(ItemStack.class);
        List<ItemStack> outputs = (List<ItemStack>)ingredients.getOutputs(ItemStack.class).get(0);
        IFocus iFocus = recipeLayout.getFocus();
        Object focusObject = iFocus.getValue();
        if (focusObject instanceof ItemStack) {
            ItemStack focus = (ItemStack)focusObject;
            IFocus.Mode mode = iFocus.getMode();
            if (mode == IFocus.Mode.INPUT) {
                EnumColour woolColour = EnumColour.fromWoolStack((ItemStack)focus);
                if (woolColour != null) {
                    Frequency freq = new Frequency(woolColour, woolColour, woolColour);
                    ItemStack newStack = freq.writeToStack(this.recipe.func_77571_b().func_77946_l());
                    outputs = Collections.singletonList(newStack);
                }
            } else {
                Frequency frequency = Frequency.readFromStack(focus);
                EnumColour colour = frequency.getLeft();
                inputs.set(this.woolIndex, this.woolOres.get(colour));
            }
        }
        EnderStorageJEIPlugin.gridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, 3, 3);
        guiItemStacks.set(0, (List)outputs);
    }
}

