/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.api.m_multiblocks.m_components.m_modifiers.attribute;

import com.valkyrieofnight.um.api.attribute.AAttributeCalculator;
import com.valkyrieofnight.um.api.attribute.AttributeID;
import com.valkyrieofnight.um.api.attribute.IAttribute;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class AttributeSpeed
implements IAttribute<Float> {
    public static AttributeID SPEED = new AttributeID("environmentaltech", "speed_mod", ACalculatorSpeedModifier.class);
    protected float modifier;

    public AttributeSpeed(float modifier) {
        this.modifier = modifier;
    }

    public AttributeID getAttributeID() {
        return SPEED;
    }

    public Float getValue() {
        return Float.valueOf(this.modifier);
    }

    public static final class ACalculatorSpeedModifier
    extends AAttributeCalculator<AttributeSpeed, Float, Integer, Integer> {
        public Float calculateFinalValue(List<IAttribute<Float>> attributes) {
            float total = 0.0f;
            for (IAttribute<Float> iAttribute : attributes) {
                total += ((Float)iAttribute.getValue()).floatValue();
            }
            return Float.valueOf(total);
        }

        public Integer calculateModifiedValue(Float attributeFinalValue, Integer unmodifiedValue) {
            return (int)((float)unmodifiedValue.intValue() * this.getMultiplier(attributeFinalValue.floatValue()));
        }

        public float getMultiplier(float attributeFinalValue) {
            return (float)Math.pow(0.7, attributeFinalValue);
        }

        public Object readFinalValueFromNBT(NBTTagCompound nbt) {
            return nbt.func_74762_e(this.getAttribute().toString());
        }

        public NBTTagCompound writeFinalValueToNBT(NBTTagCompound nbt, Object obj) {
            Integer data = (Integer)obj;
            nbt.func_74768_a(this.getAttribute().toString(), data.intValue());
            return nbt;
        }

        public int getLargerFinalValue(Object firstFinalValue, Object secondFinalValue) {
            Float f = (Float)firstFinalValue;
            Float s = (Float)secondFinalValue;
            if (f.floatValue() < s.floatValue()) {
                return 1;
            }
            if (f.floatValue() > s.floatValue()) {
                return 2;
            }
            return 0;
        }
    }
}

