/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.block;

import info.tehnut.soulshardsrespawn.SoulShards;
import info.tehnut.soulshardsrespawn.block.TileEntitySoulCage;
import info.tehnut.soulshardsrespawn.core.data.Binding;
import info.tehnut.soulshardsrespawn.core.data.Tier;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockSoulCage
extends Block {
    public static final IProperty<Boolean> POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final IProperty<Boolean> ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockSoulCage() {
        super(Material.field_151573_f, MapColor.field_151678_z);
        this.func_149663_c("soulshardsrespawn.soul_cage");
        this.func_149647_a(SoulShards.TAB_SS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(POWERED, (Comparable)Boolean.valueOf(false)));
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(3.0f);
        this.func_149752_b(3.0f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            return false;
        }
        TileEntitySoulCage cage = (TileEntitySoulCage)world.func_175625_s(pos);
        if (cage == null) {
            return false;
        }
        ItemStack stack = cage.inventory.extractItem(0, 1, false);
        if (stack.func_190926_b()) {
            return false;
        }
        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
        return true;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b(POWERED)).booleanValue() && !world.func_175640_z(pos)) {
            world.func_180501_a(pos, state.func_177226_a(POWERED, (Comparable)Boolean.valueOf(false)), 2);
        } else if (!((Boolean)state.func_177229_b(POWERED)).booleanValue() && world.func_175640_z(pos)) {
            world.func_180501_a(pos, state.func_177226_a(POWERED, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (((Boolean)state.func_177229_b(POWERED)).booleanValue() && !world.func_175640_z(pos)) {
            world.func_175656_a(pos, state.func_177226_a(POWERED, (Comparable)Boolean.valueOf(false)));
        } else if (!((Boolean)state.func_177229_b(POWERED)).booleanValue() && world.func_175640_z(pos)) {
            world.func_175656_a(pos, state.func_177226_a(POWERED, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (((Boolean)state.func_177229_b(POWERED)).booleanValue() && !world.func_175640_z(pos)) {
            world.func_175656_a(pos, state.func_177226_a(POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntitySoulCage cage = (TileEntitySoulCage)world.func_175625_s(pos);
        if (cage != null) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)cage.inventory.getStackInSlot(0));
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntitySoulCage cage = (TileEntitySoulCage)world.func_175625_s(pos);
        if (cage == null) {
            return 0;
        }
        Binding binding = cage.getBinding();
        if (binding == null) {
            return 0;
        }
        return (int)((double)binding.getTier().getIndex() / ((double)Tier.INDEXED.size() - 1.0) * 15.0);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        boolean powered = (meta & 1) == 1;
        boolean active = meta >> 2 == 1;
        return this.func_176223_P().func_177226_a(POWERED, (Comparable)Boolean.valueOf(powered)).func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(active));
    }

    public int func_176201_c(IBlockState state) {
        int powered = (Boolean)state.func_177229_b(POWERED) != false ? 1 : 0;
        int active = ((Boolean)state.func_177229_b(ACTIVE) != false ? 1 : 0) << 2;
        return powered | active;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{POWERED, ACTIVE}).build();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntitySoulCage();
    }
}

