/*
 * Decompiled with CFR 0.152.
 */
package nihiltres.engineersdoors.common.item;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nihiltres.engineersdoors.EngineersDoors;
import nihiltres.engineersdoors.common.item.IOre;

public class ItemEDDoor
extends ItemDoor
implements IOre {
    public String name;
    public String variantDesc;
    public Material material;
    public TreeSet<String> oreNames = new TreeSet();

    private ItemEDDoor(@Nonnull Block blockIn, @Nonnull String nameIn) {
        super(blockIn);
        this.material = blockIn.func_176223_P().func_185904_a();
        this.name = nameIn;
        ((Item)this.setRegistryName(this.name)).func_77655_b(this.name).func_77637_a(EngineersDoors.creativeTab);
    }

    public ItemEDDoor(Block block, String nameIn, @Nonnull String oreNameIn) {
        this(block, nameIn);
        this.oreNames.add(oreNameIn);
    }

    public ItemEDDoor(Block block, String nameIn, @Nonnull Collection<String> oreNamesIn) {
        this(block, nameIn);
        if (oreNamesIn.isEmpty()) {
            throw new IllegalArgumentException("Ore name list cannot be empty");
        }
        this.oreNames.addAll(oreNamesIn);
    }

    @Override
    public Set<String> getOreNames() {
        return this.oreNames;
    }

    @Override
    public ItemEDDoor addOreName(String oreNameIn) {
        this.oreNames.add(oreNameIn);
        return this;
    }

    @Override
    public ItemEDDoor addOreNames(Collection<String> oreNamesIn) {
        this.oreNames.addAll(oreNamesIn);
        return this;
    }

    public int getItemBurnTime(ItemStack stack) {
        return this.material == Material.field_151575_d ? 200 : 0;
    }

    public ItemEDDoor setVariantTooltip(String variant) {
        this.variantDesc = variant.toLowerCase();
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.variantDesc != null) {
            try {
                tooltip.add(I18n.func_135052_a((String)String.format("item_variant.door.%s", this.variantDesc), (Object[])new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

