/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.extrarails.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.shadowfacts.extrarails.ERConfig;
import net.shadowfacts.extrarails.ExtraRails;
import net.shadowfacts.extrarails.block.base.BlockExtraRail;
import net.shadowfacts.extrarails.tileentity.TileEntityRailTeleporting;

public class BlockRailTeleporting
extends BlockExtraRail {
    protected BlockRailTeleporting() {
        super(true);
        this.setRegistryName("teleporting_rail");
        this.func_149663_c(this.getRegistryName().toString());
        if (!ERConfig.teleportingRailsEnabled) {
            this.func_149647_a(null);
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityRailTeleporting) {
            ((TileEntityRailTeleporting)te).remove();
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void onBlockExploded(World world, @Nonnull BlockPos pos, @Nonnull Explosion explosion) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityRailTeleporting) {
            ((TileEntityRailTeleporting)te).remove();
        }
        super.onBlockExploded(world, pos, explosion);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing heldItem, float side, float hitX, float hitY) {
        player.openGui((Object)ExtraRails.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityRailTeleporting) {
            ((TileEntityRailTeleporting)te).handle(entity);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityRailTeleporting();
    }

    @Override
    public void initItemModel() {
        ExtraRails.proxy.registerItemModel((Block)this, 0, this.getRegistryName().func_110623_a());
    }

    @Override
    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        BlockRailBase.EnumRailDirection shape = BlockRailBase.EnumRailDirection.func_177016_a((int)(meta & 1));
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta >> 1));
        return this.func_176223_P().func_177226_a((IProperty)SHAPE, (Comparable)shape).func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        BlockRailBase.EnumRailDirection shape = (BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)SHAPE);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        int meta = 0;
        meta |= shape.func_177015_a();
        return meta |= facing.func_176736_b() << 1;
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHAPE, FACING});
    }
}

