/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.window;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import elec332.core.api.network.ElecByteBuf;
import elec332.core.api.network.IExtendedMessageContext;
import elec332.core.api.network.simple.ISimpleNetworkPacketManager;
import elec332.core.api.network.simple.ISimplePacket;
import elec332.core.api.network.simple.ISimplePacketHandler;
import elec332.core.inventory.window.IWindowHandler;
import elec332.core.inventory.window.Window;
import elec332.core.inventory.window.WindowContainer;
import elec332.core.inventory.window.WindowGui;
import elec332.core.main.ElecCore;
import elec332.core.util.FMLUtil;
import elec332.core.util.NBTTypes;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum WindowManager implements ISimplePacket,
ISimplePacketHandler
{
    INSTANCE;

    private final BiMap<Integer, String> names;
    private final Map<IWindowHandler, Entry> map;
    private final Map<String, IWindowHandler> lookup;
    private int index;

    private WindowManager() {
        ElecCore.networkHandler.registerPacket(this, (ISimplePacketHandler)this);
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onPlayerConnected(PlayerEvent.PlayerLoggedInEvent event) {
                if (event.player instanceof EntityPlayerMP) {
                    ElecCore.networkHandler.sendTo(WindowManager.this, (EntityPlayerMP)event.player);
                }
            }
        });
        this.names = HashBiMap.create();
        this.map = Maps.newHashMap();
        this.lookup = Maps.newHashMap();
        this.index = 0;
    }

    public void register(IWindowHandler windowHandler) {
        this.register(windowHandler, new ResourceLocation(FMLUtil.getLoader().activeModContainer().getModId(), windowHandler.getClass().getCanonicalName()));
    }

    public void register(IWindowHandler windowHandler, ResourceLocation name) {
        ++this.index;
        Entry entry = new Entry(windowHandler, name);
        this.register(entry, this.index);
    }

    private void register(Entry entry, int i) {
        if (!FMLUtil.isInModInitialisation()) {
            throw new IllegalStateException("Cannot register window handlers after mod loading.");
        }
        if (this.names.containsValue((Object)entry.toString())) {
            throw new IllegalArgumentException("There is already a registered WindowHandler for name: " + entry.name);
        }
        this.map.put(entry.windowHandler, entry);
        this.lookup.put(entry.name, entry.windowHandler);
        this.names.put((Object)i, (Object)entry.name);
    }

    public int getID(IWindowHandler windowHandler) {
        Entry ret = this.map.get(windowHandler);
        if (ret == null) {
            throw new RuntimeException("WindowHandler " + windowHandler + " has not been registered!");
        }
        return ret.getId();
    }

    public IWindowHandler get(int id) {
        return this.lookup.get(this.names.get((Object)id));
    }

    @Override
    public void onPacket(ElecByteBuf data, IExtendedMessageContext messageContext, ISimpleNetworkPacketManager networkHandler) {
        NBTTagCompound tag1 = data.readNBTTagCompoundFromBuffer();
        if (tag1 == null) {
            throw new IllegalArgumentException();
        }
        NBTTagList list = tag1.func_150295_c("list", (int)NBTTypes.COMPOUND.getID());
        this.names.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            this.names.put((Object)tag.func_74762_e("i"), (Object)tag.func_74779_i("n"));
        }
    }

    @Override
    public void toBytes(ElecByteBuf byteBuf) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry entry : this.names.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("i", ((Integer)entry.getKey()).intValue());
            tag.func_74778_a("n", (String)entry.getValue());
            list.func_74742_a((NBTBase)tag);
        }
        NBTTagCompound tag1 = new NBTTagCompound();
        tag1.func_74782_a("list", (NBTBase)list);
        byteBuf.writeNBTTagCompoundToBuffer(tag1);
    }

    @Override
    @Nullable
    public ISimplePacketHandler getPacketHandler() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public static void openClientWindow(Window window) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new WindowGui(ElecCore.proxy.getClientPlayer(), window));
    }

    public static void openWindow(@Nonnull EntityPlayer player, IWindowHandler windowHandler, World world, BlockPos pos) {
        WindowManager.openWindow(player, windowHandler, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (byte)0);
    }

    public static void openWindow(@Nonnull EntityPlayer player, IWindowHandler windowHandler, BlockPos pos) {
        WindowManager.openWindow(player, windowHandler, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (byte)0);
    }

    public static void openWindow(@Nonnull EntityPlayer player, IWindowHandler windowHandler, World world, BlockPos pos, byte id) {
        WindowManager.openWindow(player, windowHandler, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), id);
    }

    public static void openWindow(@Nonnull EntityPlayer player, IWindowHandler windowHandler, BlockPos pos, byte id) {
        WindowManager.openWindow(player, windowHandler, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), id);
    }

    public static void openWindow(@Nonnull EntityPlayer player, IWindowHandler windowHandler, World world, int x, int y, int z) {
        WindowManager.openWindow(player, windowHandler, world, x, y, z, (byte)0);
    }

    public static void openWindow(@Nonnull EntityPlayer player, IWindowHandler windowHandler, int x, int y, int z) {
        WindowManager.openWindow(player, windowHandler, x, y, z, (byte)0);
    }

    public static void openWindow(@Nonnull EntityPlayer player, IWindowHandler windowHandler, int x, int y, int z, byte id) {
        WindowManager.openWindow(player, windowHandler, player.func_130014_f_(), x, y, z, id);
    }

    public static void openWindow(@Nonnull EntityPlayer player, IWindowHandler windowHandler, World world, int x, int y, int z, byte id) {
        player.openGui((Object)ElecCore.instance, (id << 8) + INSTANCE.getID(windowHandler), world, x, y, z);
    }

    @Nullable
    public static Window getOpenWindow(EntityPlayer player) {
        Container container = player.field_71070_bA;
        if (container instanceof WindowContainer) {
            return ((WindowContainer)container).getWindow();
        }
        return null;
    }

    @Nullable
    public static Window getOpenWindow(EntityPlayer player, int windowID) {
        Window window = WindowManager.getOpenWindow(player);
        if (window != null && window.getWindowID() == windowID) {
            return window;
        }
        return null;
    }

    private class Entry {
        private final IWindowHandler windowHandler;
        private final String name;

        private Entry(IWindowHandler windowHandler, ResourceLocation name) {
            this.windowHandler = windowHandler;
            this.name = name.toString();
        }

        private int getId() {
            return (Integer)WindowManager.this.names.inverse().get((Object)this.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

