/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.core;

import com.wynprice.secretroomsmod.SecretBlocks;
import com.wynprice.secretroomsmod.SecretCompatibility;
import com.wynprice.secretroomsmod.base.interfaces.ISecretBlock;
import com.wynprice.secretroomsmod.base.interfaces.ISecretTileEntity;
import com.wynprice.secretroomsmod.render.FakeBlockAccess;
import com.wynprice.secretroomsmod.render.fakemodels.SecretBlockModel;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SecretRoomsHooksClient {
    public static IBlockState getBlockState(IBlockAccess world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof ISecretTileEntity) {
            IBlockState state = world.func_175625_s(pos).func_145831_w().func_180495_p(pos);
            IBlockState renderState = ((ISecretTileEntity)world.func_175625_s(pos)).getMirrorStateSafely();
            try {
                renderState = renderState.func_185899_b((IBlockAccess)new FakeBlockAccess((IBlockAccess)world.func_175625_s(pos).func_145831_w()), pos);
                state = state.func_185899_b(world, pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            state = ((IExtendedBlockState)state.func_177230_c().getExtendedState(state, world, pos)).withProperty(ISecretBlock.RENDER_PROPERTY, (Object)renderState);
            SecretBlockModel.instance().AO.set(Minecraft.func_71410_x().func_175602_ab().func_184389_a(renderState).func_177555_b());
            SecretBlockModel.instance().SRMBLOCK.set(state);
            return state;
        }
        return world.func_180495_p(pos);
    }

    public static boolean doesSideBlockRendering(Block block, IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (world.func_175625_s(pos) instanceof ISecretTileEntity) {
            IBlockState otherState = world.func_175625_s(pos).func_145831_w().func_180495_p(pos);
            return otherState.func_177230_c().doesSideBlockRendering(otherState, world, pos, face);
        }
        return block.doesSideBlockRendering(state, world, pos, face);
    }

    public static boolean shouldSideBeRendered(Block block, IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing face) {
        boolean ret;
        BlockPos offsetPos = pos.func_177972_a(face);
        if (!SecretRoomsHooksClient.isMalisisDoor(state) && access.func_175625_s(pos) instanceof ISecretTileEntity) {
            World world = access.func_175625_s(pos).func_145831_w();
            IBlockState blockState = world.func_180495_p(pos);
            boolean bl = blockState.func_177230_c().func_176225_a(blockState, (IBlockAccess)world, pos, face);
        }
        if (!(ret = block.func_176225_a(state, access, pos, face)) && pos.func_177958_n() == -125 && pos.func_177956_o() == 26 && pos.func_177952_p() == 264) {
            System.out.println(face);
        }
        if (!ret && access.func_175625_s(offsetPos) instanceof ISecretTileEntity && ((ISecretBlock)access.func_175625_s(offsetPos).func_145831_w().func_180495_p(offsetPos).func_177230_c()).isRenderTransparent()) {
            return true;
        }
        return ret;
    }

    public static IBakedModel getActualModel(IBlockAccess access, BlockPos pos, IBakedModel model) {
        if (access.func_175625_s(pos) instanceof ISecretTileEntity) {
            IBlockState state = access.func_175625_s(pos).func_145831_w().func_180495_p(pos);
            if (SecretRoomsHooksClient.isMalisisDoor(state)) {
                return model;
            }
            return SecretBlockModel.instance();
        }
        return model;
    }

    public static IBlockState getActualState(IBlockAccess access, BlockPos pos, IBlockState state) {
        if (SecretRoomsHooksClient.isMalisisDoor(state)) {
            return state;
        }
        if (state.func_177230_c() instanceof ISecretBlock) {
            IBlockState mirroredState = access.func_180495_p(pos);
            try {
                mirroredState = mirroredState.func_185899_b(access, pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return mirroredState;
        }
        return state;
    }

    private static boolean isMalisisDoor(IBlockState state) {
        return SecretCompatibility.MALISISDOORS && (state.func_177230_c() == SecretBlocks.SECRET_WOODEN_DOOR || state.func_177230_c() == SecretBlocks.SECRET_IRON_DOOR || state.func_177230_c() == SecretBlocks.SECRET_WOODEN_TRAPDOOR || state.func_177230_c() == SecretBlocks.SECRET_IRON_TRAPDOOR);
    }
}

