/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.base.interfaces;

import com.wynprice.secretroomsmod.SecretConfig;
import com.wynprice.secretroomsmod.base.interfaces.ISecretTileEntity;
import com.wynprice.secretroomsmod.handler.ParticleHandler;
import com.wynprice.secretroomsmod.render.FakeBlockAccess;
import com.wynprice.secretroomsmod.render.RenderStateUnlistedProperty;
import com.wynprice.secretroomsmod.render.fakemodels.FakeBlockModel;
import com.wynprice.secretroomsmod.render.fakemodels.SecretBlockModel;
import com.wynprice.secretroomsmod.render.fakemodels.TrueSightModel;
import com.wynprice.secretroomsmod.tileentity.TileEntityInfomationHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ISecretBlock
extends ITileEntityProvider {
    public static final IUnlistedProperty<IBlockState> RENDER_PROPERTY = new RenderStateUnlistedProperty();
    public static final ArrayList<TileEntity> ALL_SECRET_TILE_ENTITIES = new ArrayList();
    public static final ThreadLocal<IBlockState> cachedMirrorState = ThreadLocal.withInitial(() -> Blocks.field_150348_b.func_176223_P());

    default public IBlockState getState(IBlockAccess world, BlockPos pos) {
        return world.func_175625_s(pos) instanceof ISecretTileEntity ? ISecretTileEntity.getMirrorState(world, pos) : Blocks.field_150348_b.func_176223_P();
    }

    default public World getWorld(IBlockAccess access, BlockPos pos) {
        return access.func_175625_s(pos) != null ? access.func_175625_s(pos).func_145831_w() : null;
    }

    default public void forceBlockState(World world, BlockPos tePos, IBlockState state) {
        if (world.func_175625_s(tePos) instanceof ISecretTileEntity) {
            ((ISecretTileEntity)world.func_175625_s(tePos)).setMirrorStateForcable(state);
        }
    }

    default public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityInfomationHolder();
    }

    @SideOnly(value=Side.CLIENT)
    default public FakeBlockModel phaseModel(FakeBlockModel model) {
        return model;
    }

    @SideOnly(value=Side.CLIENT)
    default public Class<? extends FakeBlockModel> getModelClass() {
        return this.phaseModel(new FakeBlockModel(Blocks.field_150348_b.func_176223_P())).getClass();
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean isRenderTransparent() {
        return this.getModelClass() != FakeBlockModel.class;
    }

    @SideOnly(value=Side.CLIENT)
    default public TrueSightModel phaseTrueModel(TrueSightModel model) {
        return model;
    }

    default public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return this.getState(world, pos).func_177230_c().canCreatureSpawn(this.getState(world, pos), (IBlockAccess)new FakeBlockAccess(world), pos, type);
    }

    default public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return this.getState(world, pos).func_177230_c().canHarvestBlock((IBlockAccess)new FakeBlockAccess(world), pos, player);
    }

    default public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (source.func_175625_s(pos) instanceof ISecretTileEntity && ((ISecretTileEntity)source.func_175625_s(pos)).getMirrorStateSafely() != null) {
            return ((ISecretTileEntity)source.func_175625_s(pos)).getMirrorStateSafely().func_185900_c((IBlockAccess)new FakeBlockAccess(source), pos);
        }
        return Block.field_185505_j;
    }

    default public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.getState(world, pos).func_177230_c().canBeConnectedTo((IBlockAccess)new FakeBlockAccess(world), pos, facing);
    }

    default public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return this.getState(worldIn, pos).func_193401_d((IBlockAccess)new FakeBlockAccess(worldIn), pos, face);
    }

    default public float getBlockHardness(IBlockState blockState, World worldIn, BlockPos pos) {
        return ISecretTileEntity.getMirrorState(worldIn, pos).func_185887_b(worldIn, pos);
    }

    default public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getState(world, pos).func_177230_c().canConnectRedstone(this.getState(world, pos), (IBlockAccess)new FakeBlockAccess(world), pos, side);
    }

    default public float getSlipperiness(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return this.getState(world, pos).func_177230_c().getSlipperiness(this.getState(world, pos), (IBlockAccess)new FakeBlockAccess(world), pos, entity);
    }

    default public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getState(world, pos).func_177230_c().canPlaceTorchOnTop(this.getState(world, pos), (IBlockAccess)new FakeBlockAccess(world), pos);
    }

    default public RayTraceResult collisionRayTrace(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        return this.getState((IBlockAccess)worldIn, pos).func_185910_a(worldIn, pos, start, end);
    }

    default public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getState(world, pos).isSideSolid((IBlockAccess)new FakeBlockAccess(world), pos, side);
    }

    default public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        if (worldIn.func_175625_s(pos) instanceof ISecretTileEntity && ISecretTileEntity.getMirrorState(worldIn, pos) != null) {
            ISecretTileEntity.getMirrorState(worldIn, pos).func_185908_a(worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        } else {
            Blocks.field_150348_b.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        }
    }

    default public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        return world.func_175625_s(pos) instanceof ISecretTileEntity && ISecretTileEntity.getMirrorState(world, pos) != null ? ISecretTileEntity.getMirrorState(world, pos).func_177230_c().func_185467_w() : SoundType.field_185851_d;
    }

    default public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return SecretConfig.BLOCK_FUNCTIONALITY.copyLight ? ISecretTileEntity.getMirrorState(world, pos).getLightOpacity((IBlockAccess)new FakeBlockAccess(world), pos) : 255;
    }

    default public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return SecretConfig.BLOCK_FUNCTIONALITY.copyLight ? ISecretTileEntity.getMirrorState(world, pos).getLightValue((IBlockAccess)new FakeBlockAccess(world), pos) : 0;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean isOpaqueCube(IBlockState state) {
        if (state instanceof IExtendedBlockState && ((IExtendedBlockState)state).getValue(RENDER_PROPERTY) != null) {
            return ((IBlockState)((IExtendedBlockState)state).getValue(RENDER_PROPERTY)).func_185914_p();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public float getAmbientOcclusionLightValue(IBlockState state) {
        if (state instanceof IExtendedBlockState && ((IExtendedBlockState)state).getValue(RENDER_PROPERTY) != null) {
            return ((IBlockState)((IExtendedBlockState)state).getValue(RENDER_PROPERTY)).func_185892_j();
        }
        return 1.0f;
    }

    default public int getPackedLightmapCoords(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getState(source, pos).func_177230_c().func_185484_c(this.getState(source, pos), (IBlockAccess)new FakeBlockAccess(source), pos);
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        if (target.func_178782_a() != null && worldObj.func_175625_s(target.func_178782_a()) instanceof ISecretTileEntity && ((ISecretTileEntity)worldObj.func_175625_s(target.func_178782_a())).getMirrorStateSafely() != null) {
            int i = target.func_178782_a().func_177958_n();
            int j = target.func_178782_a().func_177956_o();
            int k = target.func_178782_a().func_177952_p();
            float f = 0.1f;
            AxisAlignedBB axisalignedbb = ((ISecretTileEntity)worldObj.func_175625_s(target.func_178782_a())).getMirrorStateSafely().func_185900_c((IBlockAccess)worldObj, target.func_178782_a());
            double d0 = (double)i + new Random().nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double d1 = (double)j + new Random().nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double d2 = (double)k + new Random().nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            if (target.field_178784_b == EnumFacing.DOWN) {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.UP) {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.NORTH) {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.SOUTH) {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.WEST) {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (target.field_178784_b == EnumFacing.EAST) {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
            }
            manager.func_78873_a(((ParticleDigging)new ParticleDigging.Factory().func_178902_a(0, worldObj, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)((ISecretTileEntity)worldObj.func_175625_s(target.func_178782_a())).getMirrorStateSafely())})).func_174846_a(target.func_178782_a()).func_70543_e(0.2f).func_70541_f(0.6f));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        if (ParticleHandler.BLOCKBRAKERENDERMAP.get(pos) != null) {
            IBlockState state = ParticleHandler.BLOCKBRAKERENDERMAP.get(pos);
            try {
                state = state.func_185899_b((IBlockAccess)world, pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int i = 4;
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        manager.func_78873_a((Particle)((ParticleDigging)new ParticleDigging.Factory().func_178902_a(0, world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, new int[]{Block.func_176210_f((IBlockState)state)})).func_174846_a(pos));
                    }
                }
            }
        }
        return false;
    }

    default public boolean addRunningEffects(IBlockState state, World world, BlockPos blockpos, Entity entity) {
        boolean overriden;
        IBlockState mirrorState = this.getState((IBlockAccess)world, blockpos);
        try {
            overriden = mirrorState.func_177230_c().addRunningEffects(mirrorState, world, blockpos, entity);
        }
        catch (Exception e) {
            overriden = false;
        }
        if (!overriden && mirrorState.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            Random rand = new Random();
            world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, entity.field_70165_t + ((double)rand.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)rand.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)mirrorState)});
        }
        return true;
    }

    default public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        boolean overriden;
        IBlockState mirrorState = this.getState((IBlockAccess)world, blockPosition);
        try {
            overriden = mirrorState.func_177230_c().addLandingEffects(mirrorState, world, blockPosition, iblockstate, entity, numberOfParticles);
        }
        catch (Exception e) {
            overriden = false;
        }
        if (!overriden) {
            world.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)mirrorState)});
        }
        return true;
    }

    default public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos, IBlockState superState) {
        cachedMirrorState.set(this.getState(worldIn, pos));
        if (superState instanceof IExtendedBlockState) {
            return ((IExtendedBlockState)superState).withProperty(RENDER_PROPERTY, null);
        }
        return superState;
    }

    default public int getHarvestLevel(IBlockState state) {
        return -1;
    }

    default public String getHarvestTool(IBlockState state) {
        return cachedMirrorState.get().func_177230_c().getHarvestTool(cachedMirrorState.get());
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        IBlockState renderState;
        if (SecretBlockModel.instance().SRMBLOCK.get() instanceof IExtendedBlockState && (renderState = (IBlockState)((IExtendedBlockState)SecretBlockModel.instance().SRMBLOCK.get()).getValue(RENDER_PROPERTY)) != null) {
            return renderState.func_177230_c().canRenderInLayer(renderState, layer);
        }
        return layer == BlockRenderLayer.SOLID;
    }

    @Deprecated
    default public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }
}

