/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import com.google.common.base.Objects;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class VanillaDoubleChestItemHandler
extends WeakReference<avl>
implements IItemHandlerModifiable {
    public static final VanillaDoubleChestItemHandler NO_ADJACENT_CHESTS_INSTANCE = new VanillaDoubleChestItemHandler(null, null, false);
    private final boolean mainChestIsUpper;
    private final avl mainChest;
    private final int hashCode;

    public VanillaDoubleChestItemHandler(@Nullable avl mainChest, @Nullable avl other, boolean mainChestIsUpper) {
        super(other);
        this.mainChest = mainChest;
        this.mainChestIsUpper = mainChestIsUpper;
        this.hashCode = Objects.hashCode((Object[])new Object[]{mainChestIsUpper ? mainChest : other}) * 31 + Objects.hashCode((Object[])new Object[]{!mainChestIsUpper ? mainChest : other});
    }

    @Nullable
    public static VanillaDoubleChestItemHandler get(avl chest) {
        amu world = chest.D();
        et pos = chest.w();
        if (world == null || pos == null || !world.e(pos)) {
            return null;
        }
        aow blockType = chest.x();
        fa[] horizontals = fa.o;
        for (int i2 = horizontals.length - 1; i2 >= 0; --i2) {
            avj otherTE;
            fa enumfacing = horizontals[i2];
            et blockpos = pos.a(enumfacing);
            aow block = world.o(blockpos).u();
            if (block != blockType || !((otherTE = world.r(blockpos)) instanceof avl)) continue;
            avl otherChest = (avl)otherTE;
            return new VanillaDoubleChestItemHandler(chest, otherChest, enumfacing != fa.e && enumfacing != fa.c);
        }
        return NO_ADJACENT_CHESTS_INSTANCE;
    }

    @Nullable
    public avl getChest(boolean accessingUpper) {
        if (accessingUpper == this.mainChestIsUpper) {
            return this.mainChest;
        }
        return this.getOtherChest();
    }

    @Nullable
    private avl getOtherChest() {
        avl tileEntityChest = (avl)this.get();
        return tileEntityChest != null && !tileEntityChest.y() ? tileEntityChest : null;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    @Nonnull
    public aip getStackInSlot(int slot) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        avl chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.a(targetSlot) : aip.a;
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull aip stack) {
        IItemHandler singleHandler;
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        avl chest = this.getChest(accessingUpperChest);
        if (chest != null && (singleHandler = chest.getSingleChestHandler()) instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)singleHandler).setStackInSlot(targetSlot, stack);
        }
        if ((chest = this.getChest(!accessingUpperChest)) != null) {
            chest.y_();
        }
    }

    @Override
    @Nonnull
    public aip insertItem(int slot, @Nonnull aip stack, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        avl chest = this.getChest(accessingUpperChest);
        if (chest == null) {
            return stack;
        }
        int starting = stack.E();
        aip ret = chest.getSingleChestHandler().insertItem(targetSlot, stack, simulate);
        if (ret.E() != starting && !simulate && (chest = this.getChest(!accessingUpperChest)) != null) {
            chest.y_();
        }
        return ret;
    }

    @Override
    @Nonnull
    public aip extractItem(int slot, int amount, boolean simulate) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        avl chest = this.getChest(accessingUpperChest);
        if (chest == null) {
            return aip.a;
        }
        aip ret = chest.getSingleChestHandler().extractItem(targetSlot, amount, simulate);
        if (!ret.b() && !simulate && (chest = this.getChest(!accessingUpperChest)) != null) {
            chest.y_();
        }
        return ret;
    }

    @Override
    public int getSlotLimit(int slot) {
        boolean accessingUpperChest = slot < 27;
        return this.getChest(accessingUpperChest).z_();
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull aip stack) {
        boolean accessingUpperChest = slot < 27;
        int targetSlot = accessingUpperChest ? slot : slot - 27;
        avl chest = this.getChest(accessingUpperChest);
        if (chest != null) {
            return chest.getSingleChestHandler().isItemValid(targetSlot, stack);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VanillaDoubleChestItemHandler that = (VanillaDoubleChestItemHandler)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        avl otherChest = this.getOtherChest();
        if (this.mainChestIsUpper == that.mainChestIsUpper) {
            return Objects.equal((Object)this.mainChest, (Object)that.mainChest) && Objects.equal((Object)otherChest, (Object)that.getOtherChest());
        }
        return Objects.equal((Object)this.mainChest, (Object)that.getOtherChest()) && Objects.equal((Object)otherChest, (Object)that.mainChest);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean needsRefresh() {
        if (this == NO_ADJACENT_CHESTS_INSTANCE) {
            return false;
        }
        avl tileEntityChest = (avl)this.get();
        return tileEntityChest == null || tileEntityChest.y();
    }
}

