/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.item;

import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IItemUtils;
import crafttweaker.api.potions.IPotion;
import crafttweaker.mc1120.brackets.BracketHandlerItem;
import crafttweaker.mc1120.commands.Commands;
import crafttweaker.mc1120.data.NBTConverter;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import stanhebben.zenscript.annotations.Optional;

public class MCItemUtils
implements IItemUtils {
    private static ArrayList<ItemStack> ITEMLIST;

    public static void createItemList() {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        ArrayList<Item> items = new ArrayList<Item>(BracketHandlerItem.getItemNames().values());
        items.sort(Commands.ITEM_COMPARATOR);
        for (Item item : items) {
            if (item == null) continue;
            NonNullList list = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, list);
            if (!list.isEmpty()) {
                itemList.addAll((Collection<ItemStack>)list);
                continue;
            }
            ItemStack stack = new ItemStack(item, 1, 0);
            itemList.add(stack);
        }
        ITEMLIST = itemList;
    }

    @Override
    public IItemStack createPotion(Object[] ... params) {
        ItemStack item = new ItemStack((Item)Items.field_151068_bn, 1, 0);
        ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
        for (Object[] param : params) {
            if (param.length != 3 || !(param[0] instanceof IPotion)) continue;
            IPotion iPotion = (IPotion)param[0];
            if (!(param[1] instanceof Integer)) continue;
            int amplifier = (Integer)param[1];
            if (!(param[2] instanceof Integer)) continue;
            int duration = (Integer)param[2];
            PotionEffect effect = new PotionEffect((Potion)iPotion.getInternal(), duration, amplifier);
            potionEffects.add(effect);
        }
        PotionUtils.func_185184_a((ItemStack)item, potionEffects);
        return new MCItemStack(item);
    }

    @Override
    public IItemStack[] getItemsByRegexRegistryName(String regex) {
        ArrayList<ItemStack> matchedItems = new ArrayList<ItemStack>();
        HashSet<String> alreadyChecked = new HashSet<String>();
        Pattern p = Pattern.compile(regex);
        for (ItemStack stack : ITEMLIST) {
            String currentRegName = stack.func_77973_b().getRegistryName().toString() + ":" + stack.func_77960_j();
            if (alreadyChecked.contains(currentRegName)) continue;
            alreadyChecked.add(currentRegName);
            Matcher m = p.matcher(currentRegName);
            if (!m.matches()) continue;
            if (stack.func_77942_o()) {
                matchedItems.add(new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j()));
                continue;
            }
            matchedItems.add(stack);
        }
        IItemStack[] iItemStacks = new IItemStack[matchedItems.size()];
        for (int i = 0; i < matchedItems.size(); ++i) {
            iItemStacks[i] = new MCItemStack((ItemStack)matchedItems.get(i));
        }
        return iItemStacks;
    }

    @Override
    public IItemStack[] getItemsByRegexUnlocalizedName(String regex) {
        ArrayList<ItemStack> matchedItems = new ArrayList<ItemStack>();
        Pattern p = Pattern.compile(regex);
        for (ItemStack stack : ITEMLIST) {
            String currentUnlocalizedName = stack.func_77977_a();
            Matcher m = p.matcher(currentUnlocalizedName);
            if (!m.matches()) continue;
            matchedItems.add(stack);
        }
        IItemStack[] iItemStacks = new IItemStack[matchedItems.size()];
        for (int i = 0; i < matchedItems.size(); ++i) {
            iItemStacks[i] = new MCItemStack((ItemStack)matchedItems.get(i));
        }
        return iItemStacks;
    }

    @Override
    public IItemStack createSpawnEgg(IEntityDefinition entity, @Optional IData customNBT) {
        ItemStack item = new ItemStack(Items.field_151063_bx, 1, 0);
        NBTTagCompound baseTag = customNBT != null ? (NBTTagCompound)NBTConverter.from(customNBT) : new NBTTagCompound();
        NBTTagCompound entityTag = baseTag.func_74764_b("EntityTag") ? baseTag.func_74775_l("EntityTag") : new NBTTagCompound();
        entityTag.func_74778_a("id", entity.getId());
        baseTag.func_74782_a("EntityTag", (NBTBase)entityTag);
        item.func_77982_d(baseTag);
        return new MCItemStack(item);
    }
}

