/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.events;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.CrafttweakerImplementationAPI;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.recipes.CraftingInfo;
import crafttweaker.mc1120.brackets.BracketHandlerBiome;
import crafttweaker.mc1120.brackets.BracketHandlerBiomeType;
import crafttweaker.mc1120.brackets.BracketHandlerEnchantments;
import crafttweaker.mc1120.brackets.BracketHandlerEntity;
import crafttweaker.mc1120.brackets.BracketHandlerItem;
import crafttweaker.mc1120.brackets.BracketHandlerLiquid;
import crafttweaker.mc1120.brackets.BracketHandlerPotion;
import crafttweaker.mc1120.damage.MCDamageSource;
import crafttweaker.mc1120.entity.MCEntity;
import crafttweaker.mc1120.events.ScriptRunEvent;
import crafttweaker.mc1120.events.handling.MCBlockBreakEvent;
import crafttweaker.mc1120.events.handling.MCBlockHarvestDropsEvent;
import crafttweaker.mc1120.events.handling.MCCommandEvent;
import crafttweaker.mc1120.events.handling.MCEnderTeleportEvent;
import crafttweaker.mc1120.events.handling.MCEntityLivingAttackedEvent;
import crafttweaker.mc1120.events.handling.MCEntityLivingDeathDropsEvent;
import crafttweaker.mc1120.events.handling.MCEntityLivingDeathEvent;
import crafttweaker.mc1120.events.handling.MCEntityLivingFallEvent;
import crafttweaker.mc1120.events.handling.MCEntityLivingHurtEvent;
import crafttweaker.mc1120.events.handling.MCEntityLivingJumpEvent;
import crafttweaker.mc1120.events.handling.MCEntityLivingUseItemEvent;
import crafttweaker.mc1120.events.handling.MCEntityStruckByLightningEvent;
import crafttweaker.mc1120.events.handling.MCItemExpireEvent;
import crafttweaker.mc1120.events.handling.MCItemTossEvent;
import crafttweaker.mc1120.events.handling.MCPlayerAnvilRepairEvent;
import crafttweaker.mc1120.events.handling.MCPlayerAttackEntityEvent;
import crafttweaker.mc1120.events.handling.MCPlayerBonemealEvent;
import crafttweaker.mc1120.events.handling.MCPlayerBreakSpeedEvent;
import crafttweaker.mc1120.events.handling.MCPlayerBrewedPotionEvent;
import crafttweaker.mc1120.events.handling.MCPlayerChangedDimensionEvent;
import crafttweaker.mc1120.events.handling.MCPlayerCraftedEvent;
import crafttweaker.mc1120.events.handling.MCPlayerDeathDropsEvent;
import crafttweaker.mc1120.events.handling.MCPlayerDestroyItemEvent;
import crafttweaker.mc1120.events.handling.MCPlayerFillBucketEvent;
import crafttweaker.mc1120.events.handling.MCPlayerInteractEntityEvent;
import crafttweaker.mc1120.events.handling.MCPlayerInteractEvent;
import crafttweaker.mc1120.events.handling.MCPlayerLoggedInEvent;
import crafttweaker.mc1120.events.handling.MCPlayerLoggedOutEvent;
import crafttweaker.mc1120.events.handling.MCPlayerOpenContainerEvent;
import crafttweaker.mc1120.events.handling.MCPlayerPickupItemEvent;
import crafttweaker.mc1120.events.handling.MCPlayerPickupXpEvent;
import crafttweaker.mc1120.events.handling.MCPlayerRespawnEvent;
import crafttweaker.mc1120.events.handling.MCPlayerRightClickBlockEvent;
import crafttweaker.mc1120.events.handling.MCPlayerSetSpawnEvent;
import crafttweaker.mc1120.events.handling.MCPlayerSleepInBedEvent;
import crafttweaker.mc1120.events.handling.MCPlayerSmeltedEvent;
import crafttweaker.mc1120.events.handling.MCPlayerTickEvent;
import crafttweaker.mc1120.events.handling.MCPlayerUseHoeEvent;
import crafttweaker.mc1120.furnace.MCFurnaceManager;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.mc1120.oredict.MCOreDictEntry;
import crafttweaker.mc1120.recipes.MCCraftingInventorySquared;
import crafttweaker.mc1120.recipes.MCRecipeBase;
import crafttweaker.mc1120.recipes.MCRecipeManager;
import crafttweaker.runtime.ScriptLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.brewing.PlayerBrewedPotionEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.oredict.OreDictionary;

public class CommonEventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerRecipes(RegistryEvent.Register<IRecipe> ev) {
        CraftTweakerAPI.logInfo("CraftTweaker: Building registry");
        BracketHandlerItem.rebuildItemRegistry();
        BracketHandlerLiquid.rebuildLiquidRegistry();
        BracketHandlerEntity.rebuildEntityRegistry();
        BracketHandlerPotion.rebuildRegistry();
        BracketHandlerBiome.rebuildBiomeRegistry();
        BracketHandlerBiomeType.rebuildBiomeTypeRegistry();
        BracketHandlerEnchantments.updateEnchantmentRegistry();
        CraftTweakerAPI.logInfo("CraftTweaker: Successfully built item registry");
        MinecraftForge.EVENT_BUS.post((Event)new ScriptRunEvent.Pre());
        ScriptLoader loader = CraftTweakerAPI.tweaker.getOrCreateLoader("crafttweaker", "recipeEvent");
        loader.setMainName("crafttweaker");
        CraftTweakerAPI.tweaker.loadScript(false, loader);
        MinecraftForge.EVENT_BUS.post((Event)new ScriptRunEvent.Post());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        if (!MCFurnaceManager.fuelMap.isEmpty() && !event.getItemStack().func_190926_b()) {
            for (Map.Entry<IItemStack, Integer> entry : MCFurnaceManager.fuelMap.entrySet()) {
                if (!entry.getKey().matches(MCItemStack.createNonCopy(event.getItemStack()))) continue;
                event.setBurnTime(entry.getValue().intValue());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerLoggedIn()) {
            CrafttweakerImplementationAPI.events.publishPlayerLoggedIn(new MCPlayerLoggedInEvent(CraftTweakerMC.getIPlayer(ev.player)));
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerRespawn()) {
            CrafttweakerImplementationAPI.events.publishPlayerRespawn(new MCPlayerRespawnEvent(ev));
        }
    }

    @SubscribeEvent
    public void onEntityItemPickup(EntityItemPickupEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerPickupItem()) {
            CrafttweakerImplementationAPI.events.publishPlayerPickupItem(new MCPlayerPickupItemEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerItemCrafted(PlayerEvent.ItemCraftedEvent ev) {
        if (ev.craftMatrix instanceof InventoryCrafting && !MCRecipeManager.transformerRecipes.isEmpty()) {
            MCRecipeManager.transformerRecipes.stream().filter(Objects::nonNull).filter(mcRecipeBase -> mcRecipeBase.func_77569_a((InventoryCrafting)ev.craftMatrix, ev.player.field_70170_p)).forEach(recipe -> recipe.applyTransformers((InventoryCrafting)ev.craftMatrix, CraftTweakerMC.getIPlayer(ev.player)));
        }
        IPlayer iPlayer = CraftTweakerMC.getIPlayer(ev.player);
        if (ev.craftMatrix instanceof InventoryCrafting) {
            Stream<IRecipe> recipeStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(CraftingManager.field_193380_a.iterator(), 0), false);
            Stream<MCRecipeBase> tweakedRecipeStream = recipeStream.filter(MCRecipeBase.class::isInstance).map(MCRecipeBase.class::cast);
            tweakedRecipeStream.filter(MCRecipeBase::hasRecipeAction).filter(recipe -> recipe.func_77571_b().func_77969_a(ev.crafting)).forEach(recipe -> recipe.getRecipeAction().process(CraftTweakerMC.getIItemStack(ev.crafting), new CraftingInfo(new MCCraftingInventorySquared(ev.craftMatrix, iPlayer), iPlayer.getWorld()), iPlayer));
        }
        if (CrafttweakerImplementationAPI.events.hasPlayerCrafted()) {
            CrafttweakerImplementationAPI.events.publishPlayerCrafted(new MCPlayerCraftedEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerItemSmelted(PlayerEvent.ItemSmeltedEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerSmelted()) {
            CrafttweakerImplementationAPI.events.publishPlayerSmelted(new MCPlayerSmeltedEvent(CraftTweakerMC.getIPlayer(ev.player), CraftTweakerMC.getIItemStack(ev.smelting)));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerLoggedOut()) {
            CrafttweakerImplementationAPI.events.publishPlayerLoggedOut(new MCPlayerLoggedOutEvent(CraftTweakerMC.getIPlayer(ev.player)));
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerInteract()) {
            CrafttweakerImplementationAPI.events.publishPlayerInteract(new MCPlayerInteractEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerInteractEntity()) {
            CrafttweakerImplementationAPI.events.publishPlayerInteractEntity(new MCPlayerInteractEntityEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerChangedDimension()) {
            CrafttweakerImplementationAPI.events.publishPlayerChangedDimension(new MCPlayerChangedDimensionEvent(ev));
        }
    }

    @SubscribeEvent
    public void mobDrop(LivingDropsEvent ev) {
        Entity entity = ev.getEntity();
        IEntityDefinition entityDefinition = CraftTweakerAPI.game.getEntity(EntityList.func_75621_b((Entity)ev.getEntity()));
        if (entityDefinition != null) {
            if (entityDefinition.shouldClearDrops()) {
                ev.getDrops().clear();
            } else if (!entityDefinition.getDropsToRemove().isEmpty()) {
                ArrayList removedDrops = new ArrayList();
                entityDefinition.getDropsToRemove().forEach(drop -> ev.getDrops().forEach(drops -> {
                    if (drop.matches(new MCItemStack(drops.func_92059_d()))) {
                        removedDrops.add(drops);
                    }
                }));
                ev.getDrops().removeAll(removedDrops);
            }
            if (!entityDefinition.getDrops().isEmpty()) {
                Random rand = entity.field_70170_p.field_73012_v;
                entityDefinition.getDrops().forEach(drop -> {
                    if (drop.isPlayerOnly() && !(ev.getSource().func_76346_g() instanceof EntityPlayer)) {
                        return;
                    }
                    if (drop.getChance() > 0.0f && drop.getChance() < 1.0f && rand.nextFloat() > drop.getChance()) {
                        return;
                    }
                    EntityItem item = drop.getMin() == 0 && drop.getMax() == 0 ? new EntityItem(entity.field_70170_p, entity.field_70165_t + 0.5, entity.field_70163_u + 0.5, entity.field_70161_v + 0.5, ((ItemStack)drop.getItemStack().getInternal()).func_77946_l()) : new EntityItem(entity.field_70170_p, entity.field_70165_t + 0.5, entity.field_70163_u + 0.5, entity.field_70161_v + 0.5, ((ItemStack)drop.getItemStack().withAmount(drop.getRange().getRandom(rand)).getInternal()).func_77946_l());
                    if (item.func_92059_d().func_190916_E() != 0) {
                        ev.getDrops().add(item);
                    }
                });
            }
            if (!entityDefinition.getDropFunctions().isEmpty()) {
                MCEntity ent = new MCEntity(ev.getEntity());
                MCDamageSource dmgSource = new MCDamageSource(ev.getSource());
                entityDefinition.getDropFunctions().stream().map(fun -> fun.handle(ent, dmgSource)).filter(Objects::nonNull).filter(item -> item.getAmount() > 0).map(CraftTweakerMC::getItemStack).map(item -> new EntityItem(entity.field_70170_p, entity.field_70165_t + 0.5, entity.field_70163_u + 0.5, entity.field_70161_v + 0.5, item)).forEach(ev.getDrops()::add);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerBonemeal(BonemealEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerBonemeal()) {
            CrafttweakerImplementationAPI.events.publishPlayerBonemeal(new MCPlayerBonemealEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerFillBucket(FillBucketEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerFillBucket()) {
            CrafttweakerImplementationAPI.events.publishPlayerFillBucket(new MCPlayerFillBucketEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerDeathDrops(PlayerDropsEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerDeathDrops()) {
            CrafttweakerImplementationAPI.events.publishPlayerDeathDrops(new MCPlayerDeathDropsEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerSleepInBed()) {
            CrafttweakerImplementationAPI.events.publishPlayerSleepInBed(new MCPlayerSleepInBedEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerOpenContainer(PlayerContainerEvent.Open ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerOpenContainer()) {
            CrafttweakerImplementationAPI.events.publishPlayerOpenContainer(new MCPlayerOpenContainerEvent(ev));
        }
    }

    @SubscribeEvent
    public void onUseHoe(UseHoeEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerUseHoe()) {
            CrafttweakerImplementationAPI.events.publishPlayerUseHoe(new MCPlayerUseHoeEvent(ev));
        }
    }

    @SubscribeEvent
    public void onOreDictEvent(OreDictionary.OreRegisterEvent ev) {
        List<IItemStack> ingredients = MCOreDictEntry.REMOVED_CONTENTS.get(ev.getName());
        if (ingredients != null) {
            for (IItemStack ingredient : ingredients) {
                if (!ingredient.matches(CraftTweakerMC.getIItemStack(ev.getOre()))) continue;
                OreDictionary.getOres((String)ev.getName()).remove((Object)ev.getOre());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerPickupXp(PlayerPickupXpEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerPickupXp()) {
            CrafttweakerImplementationAPI.events.publishPlayerPickupXp(new MCPlayerPickupXpEvent(ev));
        }
    }

    @SubscribeEvent
    public void onLivingEntityUseItemStartEvent(LivingEntityUseItemEvent.Start ev) {
        if (CrafttweakerImplementationAPI.events.hasEntityLivingUseItemStart()) {
            CrafttweakerImplementationAPI.events.publishEntityLivingUseItemStart(new MCEntityLivingUseItemEvent.Start(ev));
        }
    }

    @SubscribeEvent
    public void onLivingEntityUseItemStopEvent(LivingEntityUseItemEvent.Stop ev) {
        if (CrafttweakerImplementationAPI.events.hasEntityLivingUseItemStop()) {
            CrafttweakerImplementationAPI.events.publishEntityLivingUseItemStop(new MCEntityLivingUseItemEvent.Stop(ev));
        }
    }

    @SubscribeEvent
    public void onLivingEntityUseItemTickEvent(LivingEntityUseItemEvent.Tick ev) {
        if (CrafttweakerImplementationAPI.events.hasEntityLivingUseItemTick()) {
            CrafttweakerImplementationAPI.events.publishEntityLivingUseItemTick(new MCEntityLivingUseItemEvent.Tick(ev));
        }
    }

    @SubscribeEvent
    public void onLivingEntityUseItemFinishEvent(LivingEntityUseItemEvent.Finish ev) {
        if (CrafttweakerImplementationAPI.events.hasEntityLivingUseItemFinish()) {
            CrafttweakerImplementationAPI.events.publishEntityLivingUseItemFinish(new MCEntityLivingUseItemEvent.Finish(ev));
        }
    }

    @SubscribeEvent
    public void onLivingEntityUseItemEvent(LivingEntityUseItemEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasEntityLivingUseItem()) {
            CrafttweakerImplementationAPI.events.publishEntityLivingUseItem(new MCEntityLivingUseItemEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerAttackEntityEvent(AttackEntityEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerAttackEntity()) {
            CrafttweakerImplementationAPI.events.publishPlayerAttackEntity(new MCPlayerAttackEntityEvent(ev));
        }
    }

    @SubscribeEvent
    public void onEntityStruckByLightningEvent(EntityStruckByLightningEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasEntityStruckByLightning()) {
            CrafttweakerImplementationAPI.events.publishEntityStruckByLightning(new MCEntityStruckByLightningEvent(ev));
        }
    }

    @SubscribeEvent
    public void onEnderTeleportEvent(EnderTeleportEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasEnderTeleport()) {
            CrafttweakerImplementationAPI.events.publishEnderTeleport(new MCEnderTeleportEvent(ev));
        }
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingAttackEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasEntityLivingAttacked()) {
            CrafttweakerImplementationAPI.events.publishEntityLivingAttacked(new MCEntityLivingAttackedEvent(ev));
        }
    }

    @SubscribeEvent
    public void onEntityLivingDeathEvent(LivingDeathEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasEntityLivingDeath()) {
            CrafttweakerImplementationAPI.events.publishEntityLivingDeath(new MCEntityLivingDeathEvent(ev));
        }
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasEntityLivingFall()) {
            CrafttweakerImplementationAPI.events.publishEntityLivingFall(new MCEntityLivingFallEvent(ev));
        }
    }

    @SubscribeEvent
    public void onEntityLivingHurtEvent(LivingHurtEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasEntityLivingHurt()) {
            CrafttweakerImplementationAPI.events.publishEntityLivingHurt(new MCEntityLivingHurtEvent(ev));
        }
    }

    @SubscribeEvent
    public void onEntityLivingJumpEvent(LivingEvent.LivingJumpEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasEntityLivingJump()) {
            CrafttweakerImplementationAPI.events.publishEntityLivingJump(new MCEntityLivingJumpEvent(ev));
        }
    }

    @SubscribeEvent
    public void onEntityLivingDeathDropsEvent(LivingDropsEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasEntityLivingDeathDrops()) {
            CrafttweakerImplementationAPI.events.publishEntityLivingDeathDrops(new MCEntityLivingDeathDropsEvent(ev));
        }
    }

    @SubscribeEvent
    public void onItemExpireEvent(ItemExpireEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasItemExpire()) {
            CrafttweakerImplementationAPI.events.publishItemExpire(new MCItemExpireEvent(ev));
        }
    }

    @SubscribeEvent
    public void onItemTossEvent(ItemTossEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasItemToss()) {
            CrafttweakerImplementationAPI.events.publishItemToss(new MCItemTossEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerAnvilRepairEvent(AnvilRepairEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerAnvilRepair()) {
            CrafttweakerImplementationAPI.events.publishPlayerAnvilRepair(new MCPlayerAnvilRepairEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerSetSpawnEvent(PlayerSetSpawnEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerSetSpawn()) {
            CrafttweakerImplementationAPI.events.publishPlayerSetSpawn(new MCPlayerSetSpawnEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerDestroyItemEvent(PlayerDestroyItemEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerDestroyItem()) {
            CrafttweakerImplementationAPI.events.publishPlayerDestroyItem(new MCPlayerDestroyItemEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerBrewedPotionEvent(PlayerBrewedPotionEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerBrewedPotion()) {
            CrafttweakerImplementationAPI.events.publishPlayerBrewedPotion(new MCPlayerBrewedPotionEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerTick()) {
            CrafttweakerImplementationAPI.events.publishPlayerTick(new MCPlayerTickEvent(CraftTweakerMC.getIPlayer(ev.player)));
        }
    }

    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasBlockBreak()) {
            CrafttweakerImplementationAPI.events.publishBlockBreak(new MCBlockBreakEvent(ev));
        }
    }

    @SubscribeEvent
    public void onBlockHarvestDropsEvent(BlockEvent.HarvestDropsEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasBlockHarvestDrops()) {
            CrafttweakerImplementationAPI.events.publishBlockHarvestDrops(new MCBlockHarvestDropsEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerBreakSpeedEvent(PlayerEvent.BreakSpeed ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerBreakSpeed()) {
            CrafttweakerImplementationAPI.events.publishPlayerBreakSpeed(new MCPlayerBreakSpeedEvent(ev));
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickBlockEvent(PlayerInteractEvent.RightClickBlock ev) {
        if (CrafttweakerImplementationAPI.events.hasPlayerRightClickBlock()) {
            CrafttweakerImplementationAPI.events.publishPlayerRightClickBlock(new MCPlayerRightClickBlockEvent(ev));
        }
    }

    @SubscribeEvent
    public void onCommandEvent(CommandEvent ev) {
        if (CrafttweakerImplementationAPI.events.hasCommand()) {
            CrafttweakerImplementationAPI.events.publishCommand(new MCCommandEvent(ev));
        }
    }
}

