/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.base.Strings;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHelper {
    public static void register(IForgeRegistry<Block> registry, Block block, String id, String unlocalized) {
        if (registry != null && block != null && !Strings.isNullOrEmpty((String)id) && !Strings.isNullOrEmpty((String)unlocalized)) {
            registry.register((IForgeRegistryEntry)((Block)block.setRegistryName(id)).func_149663_c(unlocalized));
        }
    }

    public static void register(IForgeRegistry<Item> registry, ItemBlock item) {
        Block block;
        if (registry != null && item != null && (block = item.func_179223_d()) != null && block.getRegistryName() != null) {
            RegistryHelper.register(registry, (Item)item, block.getRegistryName().toString(), block.func_149739_a());
        }
    }

    public static void register(IForgeRegistry<Item> registry, Item item, String id, String unlocalized) {
        if (registry != null && item != null && !Strings.isNullOrEmpty((String)id) && !Strings.isNullOrEmpty((String)unlocalized)) {
            registry.register((IForgeRegistryEntry)((Item)item.setRegistryName(id)).func_77655_b(unlocalized));
        }
    }

    public static void register(Class<? extends TileEntity> tile, String id) {
        GameRegistry.registerTileEntity(tile, (String)id);
    }

    public static Fluid registerFluid(Fluid fluid) {
        return FluidRegistry.registerFluid((Fluid)fluid) ? fluid : FluidRegistry.getFluid((String)fluid.getName());
    }

    public static SoundEvent registerSound(String id) {
        ResourceLocation name = new ResourceLocation(id);
        SoundEvent sound = new SoundEvent(name);
        sound.setRegistryName(name);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)sound);
        return sound;
    }

    public static void registerPotion(Potion potion, String id) {
        if (potion != null && !Strings.isNullOrEmpty((String)id)) {
            potion.setRegistryName(new ResourceLocation(id));
            ForgeRegistries.POTIONS.register((IForgeRegistryEntry)potion);
        }
    }
}

