/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.serverstuffs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.creeperhost.minetogether.serverstuffs.CreeperHostServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.SERVER)
public class MineTogetherPropertyManager {
    private final Properties serverProperties = new Properties();
    private final File serverPropertiesFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MineTogetherPropertyManager(File propertiesFile) {
        this.serverPropertiesFile = propertiesFile;
        if (propertiesFile.exists()) {
            FileInputStream fileinputstream = null;
            try {
                fileinputstream = new FileInputStream(propertiesFile);
                this.serverProperties.load(fileinputstream);
            }
            catch (Exception exception) {
                CreeperHostServer.logger.warn("Failed to load {}", (Object)propertiesFile, (Object)exception);
                this.generateNewProperties();
            }
            finally {
                if (fileinputstream != null) {
                    try {
                        fileinputstream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            CreeperHostServer.logger.warn("{} does not exist", (Object)propertiesFile);
            this.generateNewProperties();
        }
    }

    public void generateNewProperties() {
        this.saveProperties();
    }

    public void saveProperties() {
        FileOutputStream fileoutputstream = null;
        try {
            fileoutputstream = new FileOutputStream(this.serverPropertiesFile);
            this.serverProperties.store(fileoutputstream, "MineTogether properties");
        }
        catch (Exception exception) {
            CreeperHostServer.logger.warn("Failed to save {}", (Object)this.serverPropertiesFile, (Object)exception);
            this.generateNewProperties();
        }
        finally {
            if (fileoutputstream != null) {
                try {
                    fileoutputstream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getStringProperty(String key, String defaultValue) {
        if (!this.serverProperties.containsKey(key)) {
            this.serverProperties.setProperty(key, defaultValue);
            this.saveProperties();
            this.saveProperties();
        }
        return this.serverProperties.getProperty(key, defaultValue);
    }
}

