/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.TriFunction;

public abstract class AbstractNameValueProcessor<NameValue> {
    private final Client.WithManagement client;
    private final Map<String, Creator<NameValue>> registeredNames = new ConcurrentHashMap<String, Creator<NameValue>>();

    protected AbstractNameValueProcessor(Client.WithManagement client) {
        this.client = client;
    }

    public Client.WithManagement getClient() {
        return this.client;
    }

    protected final Map<String, Creator<NameValue>> getRegistrations() {
        return this.registeredNames;
    }

    @Nonnull
    protected final Optional<TriFunction<Client, String, String, ? extends NameValue>> getCreatorByName(@Nonnull String name) {
        return this.optional(this.registeredNames.get(Sanity.nullCheck(name, "Name cannot be null")));
    }

    @Nonnull
    protected final Optional<TriFunction<Client, String, String, ? extends NameValue>> registerCreator(@Nonnull String name, @Nonnull Creator<NameValue> creator) {
        return this.optional(this.registeredNames.put(Sanity.nullCheck(name, "Name cannot be null"), creator));
    }

    @Nonnull
    protected final Optional<TriFunction<Client, String, String, ? extends NameValue>> unregisterCreator(@Nonnull String name) {
        return this.optional(this.registeredNames.remove(Sanity.nullCheck(name, "Name cannot be null")));
    }

    @Nonnull
    private Optional<TriFunction<Client, String, String, ? extends NameValue>> optional(@Nullable Creator<NameValue> creator) {
        return creator == null ? Optional.empty() : Optional.of(creator.getFunction());
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).toString();
    }

    public static class Creator<NameValue> {
        private final TriFunction<Client, String, String, ? extends NameValue> function;

        public Creator(@Nonnull TriFunction<Client, String, String, ? extends NameValue> function) {
            this.function = Sanity.nullCheck(function, "Function cannot be null");
        }

        @Nonnull
        public TriFunction<Client, String, String, ? extends NameValue> getFunction() {
            return this.function;
        }
    }
}

