/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.tileentity;

import ipsis.woot.block.BlockMobFactoryCell;
import ipsis.woot.farmblocks.FactoryGlue;
import ipsis.woot.farmblocks.IFactoryGlue;
import ipsis.woot.farmblocks.IFactoryGlueProvider;
import ipsis.woot.farmblocks.SimpleMasterLocator;
import ipsis.woot.power.storage.IPowerStation;
import ipsis.woot.power.storage.SinglePowerStation;
import ipsis.woot.util.WorldHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileEntityMobFactoryCell
extends TileEntity
implements IFactoryGlueProvider {
    private IFactoryGlue iFactoryGlue = new FactoryGlue(IFactoryGlue.FactoryBlockType.CELL, new SimpleMasterLocator(), this, this);
    private IPowerStation powerStation = new SinglePowerStation();
    boolean isClientFormed;

    public void setTier(BlockMobFactoryCell.EnumCellTier tier) {
        this.powerStation.setTier(tier);
    }

    public void onBlockAdded() {
        this.iFactoryGlue.onHello(this.func_145831_w(), this.func_174877_v());
    }

    public IPowerStation getPowerStation() {
        return this.powerStation;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.iFactoryGlue.onGoodbye();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.iFactoryGlue.onGoodbye();
    }

    public boolean isClientFormed() {
        return this.isClientFormed;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.powerStation.readFromNBT(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.powerStation.writeToNBT(compound);
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("formed", this.iFactoryGlue.hasMaster());
        return nbtTagCompound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.isClientFormed = tag.func_74767_n("formed");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
        WorldHelper.updateClient(this.func_145831_w(), this.func_174877_v());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.iFactoryGlue.hasMaster();
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this.iFactoryGlue.hasMaster()) {
            return (T)this.powerStation.getEnergyStorage();
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    @Nonnull
    public IFactoryGlue getIFactoryGlue() {
        return this.iFactoryGlue;
    }
}

