/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.loot.repository;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ipsis.Woot;
import ipsis.woot.command.ITextStatus;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.loot.repository.ILootRepositoryLearn;
import ipsis.woot.loot.repository.ILootRepositoryLoad;
import ipsis.woot.loot.repository.ILootRepositoryLookup;
import ipsis.woot.loot.repository.ILootRepositoryWriter;
import ipsis.woot.loot.repository.LootDrop;
import ipsis.woot.oss.ItemHelper;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.EnumEnchantKey;
import ipsis.woot.util.JsonHelper;
import ipsis.woot.util.SerializationHelper;
import ipsis.woot.util.WootMobName;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;

public class LootRepository
implements ILootRepositoryLoad,
ILootRepositoryLearn,
ILootRepositoryLookup,
ILootRepositoryWriter,
ITextStatus {
    public static final int VERSION = 1;
    private Map<WootMobName, Integer[]> samples = new HashMap<WootMobName, Integer[]>();
    private List<LootDrop> drops = new ArrayList<LootDrop>();

    private boolean equalDrops(ItemStack a, ItemStack b) {
        if (!ItemHelper.itemsEqualWithoutMetadata(a, b, true)) {
            return false;
        }
        return !a.func_77981_g() || ItemHelper.getItemDamage(a) == ItemHelper.getItemDamage(b);
    }

    private LootDrop getLootDrop(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        for (LootDrop curr : this.drops) {
            if (!this.equalDrops(curr.getItemStack(), itemStack)) continue;
            return curr;
        }
        return null;
    }

    @Nullable
    private LootDrop.LootMob getLootMob(LootDrop lootDrop, WootMobName wootMobName) {
        if (!wootMobName.isValid()) {
            return null;
        }
        for (LootDrop.LootMob lootMob : lootDrop.getMobs()) {
            if (!lootMob.getWootMobName().equals(wootMobName)) continue;
            return lootMob;
        }
        return null;
    }

    private Integer[] getMobSamples(WootMobName wootMobName) {
        return this.samples.get(wootMobName);
    }

    public int getSampleCount(WootMobName wootMobName, EnumEnchantKey key) {
        Integer[] s = this.samples.get(wootMobName);
        if (s != null) {
            return s[key.ordinal()];
        }
        return 0;
    }

    private void incMobSample(WootMobName wootMobName, EnumEnchantKey key) {
        Integer[] mobSamples = this.getMobSamples(wootMobName);
        if (mobSamples == null) {
            mobSamples = new Integer[]{0, 0, 0, 0};
            this.samples.put(wootMobName, mobSamples);
        }
        Integer[] integerArray = mobSamples;
        int n = key.ordinal();
        Integer n2 = integerArray[n];
        Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
    }

    private List<ItemStack> convertDrops(List<EntityItem> drops) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (EntityItem entityItem : drops) {
            ItemStack itemStack = entityItem.func_92059_d();
            boolean updated = false;
            for (ItemStack i2 : items) {
                if (!this.equalDrops(i2, itemStack)) continue;
                i2.func_190920_e(i2.func_190916_E() + 1);
                updated = true;
            }
            if (updated) continue;
            items.add(itemStack);
        }
        return items;
    }

    @Override
    public void loadMobSample(WootMobName wootMobName, int l0, int l1, int l2, int l3) {
        if (this.samples.containsKey(wootMobName)) {
            LogHelper.error("loadMobSample: duplicate mob sample found " + wootMobName);
        } else {
            this.samples.put(wootMobName, new Integer[]{l0, l1, l2, l3});
        }
    }

    @Override
    public void loadItem(ItemStack itemStack) {
        LootDrop lootDrop = this.getLootDrop(itemStack);
        if (lootDrop != null) {
            LogHelper.error("loadItem: duplicate item found " + itemStack);
            return;
        }
        this.drops.add(new LootDrop(itemStack));
    }

    @Override
    public void loadMobDrop(WootMobName wootMobName, EnumEnchantKey key, ItemStack itemStack, int stackSize, int drops) {
        LootDrop lootDrop = this.getLootDrop(itemStack);
        if (lootDrop == null) {
            LogHelper.error("loadMobDrop: no matching itemstack found");
            return;
        }
        LootDrop.LootMob lootMob = this.getLootMob(lootDrop, wootMobName);
        if (lootMob == null) {
            lootMob = new LootDrop.LootMob(wootMobName);
            lootDrop.getMobs().add(lootMob);
        }
        HashMap<Integer, Integer> map = lootMob.getLooting(key);
        map.put(stackSize, drops);
    }

    private static boolean hasCustomDropsOnly(WootMobName wootMobName) {
        return wootMobName.isEnderDragon() || wootMobName.isChaosGuardian() || wootMobName.isThaumcraftWisp();
    }

    @Override
    public boolean isEmpty(WootMobName wootMobName, EnumEnchantKey key) {
        if (LootRepository.hasCustomDropsOnly(wootMobName)) {
            return false;
        }
        int sampleCount = this.getSampleCount(wootMobName, key);
        return sampleCount == 0;
    }

    @Override
    public boolean isFull(WootMobName wootMobName, EnumEnchantKey key) {
        if (LootRepository.hasCustomDropsOnly(wootMobName)) {
            return true;
        }
        int sampleCount = this.getSampleCount(wootMobName, key);
        return sampleCount >= Woot.wootConfiguration.getInteger(EnumConfigKey.SAMPLE_SIZE);
    }

    @Override
    public void learn(WootMobName wootMobName, EnumEnchantKey key, @Nonnull List<EntityItem> drops, boolean updateSampleCount) {
        if (LootRepository.hasCustomDropsOnly(wootMobName)) {
            return;
        }
        if (updateSampleCount) {
            this.incMobSample(wootMobName, key);
        }
        List<ItemStack> flattenedDrops = this.convertDrops(drops);
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.LEARN, "learn", wootMobName + " with items " + flattenedDrops.size());
        for (ItemStack itemStack : flattenedDrops) {
            LootDrop.LootMob lootMob;
            if (itemStack.func_190926_b()) {
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.LEARN, "learn", "dropping empty stack");
                continue;
            }
            if (!Woot.policyRepository.canLearnDrop(itemStack)) {
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.LEARN, "learn", "policy removed " + itemStack);
                continue;
            }
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.LEARN, "learn", "learning " + itemStack);
            LootDrop lootDrop = this.getLootDrop(itemStack);
            if (lootDrop == null) {
                lootDrop = new LootDrop(itemStack);
                this.drops.add(lootDrop);
            }
            if ((lootMob = this.getLootMob(lootDrop, wootMobName)) == null) {
                lootMob = new LootDrop.LootMob(wootMobName);
                lootDrop.getMobs().add(lootMob);
            }
            HashMap<Integer, Integer> map = lootMob.getLooting(key);
            int count = 0;
            Integer c = map.get(itemStack.func_190916_E());
            if (c != null) {
                count = c;
            }
            map.put(itemStack.func_190916_E(), ++count);
        }
    }

    @Override
    public List<ILootRepositoryLookup.LootItemStack> getDrops(WootMobName wootMobName, EnumEnchantKey key) {
        if (LootRepository.hasCustomDropsOnly(wootMobName)) {
            return new ArrayList<ILootRepositoryLookup.LootItemStack>();
        }
        ArrayList<ILootRepositoryLookup.LootItemStack> lootDrops = new ArrayList<ILootRepositoryLookup.LootItemStack>();
        int sampleCount = this.getSampleCount(wootMobName, key);
        if (sampleCount > 0) {
            for (LootDrop curr : this.drops) {
                HashMap<Integer, Integer> looting;
                LootDrop.LootMob lootMob = this.getLootMob(curr, wootMobName);
                if (lootMob == null || (looting = lootMob.getLooting(key)).isEmpty()) continue;
                ILootRepositoryLookup.LootItemStack lootItemStack = new ILootRepositoryLookup.LootItemStack(curr.getItemStack().func_77946_l());
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_ITEMS, "getDrops", curr.getItemStack().func_82833_r());
                int dropCount = 0;
                for (Integer s : looting.keySet()) {
                    Integer d = looting.get(s);
                    if (d <= 0) continue;
                    dropCount += d.intValue();
                }
                int dropChance = Math.round((float)dropCount / (float)sampleCount * 100.0f);
                lootItemStack.dropChance = dropChance = MathHelper.func_76125_a((int)dropChance, (int)1, (int)100);
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_ITEMS, "getDrops", "dropCount: " + dropCount + "/" + sampleCount + " chance:" + dropChance);
                if (dropCount == 0) continue;
                for (Integer s : looting.keySet()) {
                    Integer stackDropCount = looting.get(s);
                    if (stackDropCount <= 0) continue;
                    Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_ITEMS, "getDrops", "stack:" + s + " drops:" + stackDropCount);
                    int chance = Math.round((float)stackDropCount.intValue() / (float)dropCount * 100.0f);
                    chance = MathHelper.func_76125_a((int)chance, (int)1, (int)100);
                    lootItemStack.sizes.put(s, chance);
                    Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_ITEMS, "getDrops", "stack:" + s + " drops:" + stackDropCount + " chance:" + chance);
                }
                if (lootItemStack.sizes.isEmpty()) continue;
                lootDrops.add(lootItemStack);
            }
        }
        return lootDrops;
    }

    @Override
    public List<String> getAllMobs() {
        ArrayList<String> mobs = new ArrayList<String>();
        for (WootMobName wootMobName : this.samples.keySet()) {
            mobs.add(wootMobName.getName());
        }
        return mobs;
    }

    @Override
    public List<String> getStatus() {
        ArrayList<String> status = new ArrayList<String>();
        for (WootMobName wootMobName : this.samples.keySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(wootMobName).append("-");
            sb.append(this.getSampleCount(wootMobName, EnumEnchantKey.NO_ENCHANT)).append("/");
            sb.append(this.getSampleCount(wootMobName, EnumEnchantKey.LOOTING_I)).append("/");
            sb.append(this.getSampleCount(wootMobName, EnumEnchantKey.LOOTING_II)).append("/");
            sb.append(this.getSampleCount(wootMobName, EnumEnchantKey.LOOTING_III));
            status.add(sb.toString());
        }
        return status;
    }

    @Override
    public List<String> getStatus(WorldServer worldServer) {
        return new ArrayList<String>();
    }

    @Override
    public void writeToJsonFile(File file) {
        JsonObject obj = new JsonObject();
        obj.addProperty("version", (Number)1);
        JsonArray mobsArray = new JsonArray();
        for (WootMobName wootMobName : this.samples.keySet()) {
            JsonObject obj2 = new JsonObject();
            obj2.addProperty("mobName", wootMobName.toString());
            JsonArray sampleArray = new JsonArray();
            for (Integer i : this.samples.get(wootMobName)) {
                sampleArray.add((Number)i);
            }
            obj2.add("samples", (JsonElement)sampleArray);
            mobsArray.add((JsonElement)obj2);
        }
        obj.add("mobs", (JsonElement)mobsArray);
        JsonArray dropsArray = new JsonArray();
        for (LootDrop lootDrop : this.drops) {
            if (lootDrop.getMobs().isEmpty()) continue;
            JsonObject jsonObject = new JsonObject();
            JsonObject itemStackObject = JsonHelper.toJsonObject(lootDrop.getItemStack());
            jsonObject.add("drop", (JsonElement)itemStackObject);
            mobsArray = new JsonArray();
            for (LootDrop.LootMob lootMob : lootDrop.getMobs()) {
                JsonObject mobObject = new JsonObject();
                mobObject.addProperty("mobName", lootMob.getWootMobName().toString());
                JsonArray sizesArray = new JsonArray();
                for (EnumEnchantKey key : EnumEnchantKey.values()) {
                    HashMap<Integer, Integer> map = lootMob.getLooting(key);
                    if (map.isEmpty()) continue;
                    for (Integer c : map.keySet()) {
                        JsonObject sizeObject = new JsonObject();
                        sizeObject.addProperty("count", (Number)c);
                        sizeObject.addProperty("looting", (Number)key.ordinal());
                        sizeObject.addProperty("samples", (Number)map.get(c));
                        sizesArray.add((JsonElement)sizeObject);
                    }
                }
                mobObject.add("sizes", (JsonElement)sizesArray);
                mobsArray.add((JsonElement)mobObject);
            }
            jsonObject.add("mobs", (JsonElement)mobsArray);
            dropsArray.add((JsonElement)jsonObject);
        }
        obj.add("drops", (JsonElement)dropsArray);
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String t = gson.toJson((JsonElement)obj);
        SerializationHelper.writeJsonFile(file, t);
    }

    public void flushAll() {
        this.samples.clear();
        this.drops.clear();
    }

    public void flushMob(WootMobName wootMobName) {
        this.samples.remove(wootMobName);
        for (LootDrop lootDrop : this.drops) {
            if (lootDrop.getMobs().isEmpty()) continue;
            ListIterator<LootDrop.LootMob> iter = lootDrop.getMobs().listIterator();
            while (iter.hasNext()) {
                LootDrop.LootMob lootMob = (LootDrop.LootMob)iter.next();
                if (!lootMob.getWootMobName().equals(wootMobName)) continue;
                iter.remove();
            }
        }
    }
}

