/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.client.renderer;

import ipsis.Woot;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.event.HandlerTextureStitchEvent;
import ipsis.woot.tileentity.ControllerLayoutBlockInfo;
import ipsis.woot.tileentity.HeartLayoutBlockInfo;
import ipsis.woot.tileentity.ILayoutBlockInfo;
import ipsis.woot.tileentity.StructureLayoutBlockInfo;
import ipsis.woot.tileentity.TileEntityLayout;
import ipsis.woot.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;

public class TESRLayout
extends TileEntitySpecialRenderer<TileEntityLayout> {
    private static float SIZE = 0.3f;

    public boolean isGlobalRenderer(TileEntityLayout te) {
        return true;
    }

    public void render(TileEntityLayout te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.getLayoutBlockInfoList().isEmpty()) {
            te.refreshLayout();
        }
        if (Woot.wootConfiguration.getBoolean(EnumConfigKey.SIMPLE_LAYOUT)) {
            this.coloredLayout(te, x, y, z, partialTicks, destroyStage, alpha);
        } else {
            this.texturedLayout(te, x, y, z, partialTicks, destroyStage, alpha);
        }
    }

    private void texturedLayout(TileEntityLayout te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.95f);
        boolean showAll = te.getCurrLevel() == -1;
        int validY = showAll ? 0 : te.func_174877_v().func_177956_o() + 1 + te.getCurrLevel();
        for (ILayoutBlockInfo pos : te.getLayoutBlockInfoList()) {
            if (this.func_178459_a().func_180495_p(pos.getPos()).func_185914_p() || !showAll && pos.getPos().func_177956_o() != validY) continue;
            if (pos instanceof StructureLayoutBlockInfo) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)(te.func_174877_v().func_177958_n() - pos.getPos().func_177958_n()) * -1.0f), (float)((float)(te.func_174877_v().func_177956_o() - pos.getPos().func_177956_o()) * -1.0f), (float)((float)(te.func_174877_v().func_177952_p() - pos.getPos().func_177952_p()) * -1.0f));
                TextureAtlasSprite texture = null;
                switch (((StructureLayoutBlockInfo)pos).module) {
                    case BLOCK_1: {
                        texture = HandlerTextureStitchEvent.block1;
                        break;
                    }
                    case BLOCK_2: {
                        texture = HandlerTextureStitchEvent.block2;
                        break;
                    }
                    case BLOCK_3: {
                        texture = HandlerTextureStitchEvent.block3;
                        break;
                    }
                    case BLOCK_4: {
                        texture = HandlerTextureStitchEvent.block4;
                        break;
                    }
                    case BLOCK_5: {
                        texture = HandlerTextureStitchEvent.block5;
                        break;
                    }
                    case BLOCK_UPGRADE: {
                        texture = HandlerTextureStitchEvent.blockupgrade;
                        break;
                    }
                    case CAP_I: {
                        texture = HandlerTextureStitchEvent.tiericap;
                        break;
                    }
                    case CAP_II: {
                        texture = HandlerTextureStitchEvent.tieriicap;
                        break;
                    }
                    case CAP_III: {
                        texture = HandlerTextureStitchEvent.tieriiicap;
                        break;
                    }
                    case CAP_IV: {
                        texture = HandlerTextureStitchEvent.tierivcap;
                    }
                }
                RenderUtils.drawTexturedCube(texture, SIZE);
                GlStateManager.func_179121_F();
                continue;
            }
            if (pos instanceof HeartLayoutBlockInfo) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)(te.func_174877_v().func_177958_n() - pos.getPos().func_177958_n()) * -1.0f), (float)((float)(te.func_174877_v().func_177956_o() - pos.getPos().func_177956_o()) * -1.0f), (float)((float)(te.func_174877_v().func_177952_p() - pos.getPos().func_177952_p()) * -1.0f));
                RenderUtils.drawTexturedCube(HandlerTextureStitchEvent.factory, 0.4f);
                GlStateManager.func_179121_F();
                continue;
            }
            if (!(pos instanceof ControllerLayoutBlockInfo)) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)(te.func_174877_v().func_177958_n() - pos.getPos().func_177958_n()) * -1.0f), (float)((float)(te.func_174877_v().func_177956_o() - pos.getPos().func_177956_o()) * -1.0f), (float)((float)(te.func_174877_v().func_177952_p() - pos.getPos().func_177952_p()) * -1.0f));
            RenderUtils.drawTexturedCube(HandlerTextureStitchEvent.controller, 0.4f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }

    private void coloredLayout(TileEntityLayout te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179123_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        float RENDER_ALPHA = 0.7f;
        for (ILayoutBlockInfo pos : te.getLayoutBlockInfoList()) {
            if (pos instanceof StructureLayoutBlockInfo) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)(te.func_174877_v().func_177958_n() - pos.getPos().func_177958_n()) * -1.0f), (float)((float)(te.func_174877_v().func_177956_o() - pos.getPos().func_177956_o()) * -1.0f), (float)((float)(te.func_174877_v().func_177952_p() - pos.getPos().func_177952_p()) * -1.0f));
                GlStateManager.func_179131_c((float)((StructureLayoutBlockInfo)pos).module.getColor().getRed(), (float)((StructureLayoutBlockInfo)pos).module.getColor().getGreen(), (float)((StructureLayoutBlockInfo)pos).module.getColor().getBlue(), (float)RENDER_ALPHA);
                RenderUtils.drawShadedCube(SIZE);
                GlStateManager.func_179121_F();
                continue;
            }
            if (pos instanceof HeartLayoutBlockInfo) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)(te.func_174877_v().func_177958_n() - pos.getPos().func_177958_n()) * -1.0f), (float)((float)(te.func_174877_v().func_177956_o() - pos.getPos().func_177956_o()) * -1.0f), (float)((float)(te.func_174877_v().func_177952_p() - pos.getPos().func_177952_p()) * -1.0f));
                GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)1.0f, (float)RENDER_ALPHA);
                RenderUtils.drawShadedCube(SIZE);
                GlStateManager.func_179121_F();
                continue;
            }
            if (!(pos instanceof ControllerLayoutBlockInfo)) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)(te.func_174877_v().func_177958_n() - pos.getPos().func_177958_n()) * -1.0f), (float)((float)(te.func_174877_v().func_177956_o() - pos.getPos().func_177956_o()) * -1.0f), (float)((float)(te.func_174877_v().func_177952_p() - pos.getPos().func_177952_p()) * -1.0f));
            GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)RENDER_ALPHA);
            RenderUtils.drawShadedCube(SIZE);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
    }
}

