/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.quark.base.handler.DimensionConfig;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.world.FairyRingGenerator;

public class FairyRings
extends Feature {
    private static final Pattern BLOCKSTATE_PARSER = Pattern.compile("^(\\D+?):(\\d+)$");
    public static int forestChance;
    public static int plainsChance;
    public static DimensionConfig dimensions;
    public static List<IBlockState> ores;
    boolean initted = false;
    String[] oresArr;

    @Override
    public void setupConfig() {
        forestChance = this.loadPropInt("Forest Chance", "", 160);
        plainsChance = this.loadPropInt("Plains Chance", "", 400);
        dimensions = new DimensionConfig(this.configCategory, "0");
        this.oresArr = this.loadPropStringList("Spawnable Ores", "", new String[]{Blocks.field_150412_bA.getRegistryName().toString(), Blocks.field_150482_ag.getRegistryName().toString()});
        if (this.initted) {
            this.loadOres();
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new FairyRingGenerator(), (int)100);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        this.loadOres();
    }

    private void loadOres() {
        ores = new ArrayList<IBlockState>(this.oresArr.length);
        for (String s : this.oresArr) {
            Block b;
            int meta = 0;
            Matcher m = BLOCKSTATE_PARSER.matcher(s);
            if (m.matches()) {
                s = m.group(1);
                meta = Integer.parseInt(m.group(2));
            }
            if ((b = Block.func_149684_b((String)s)) == null) {
                new IllegalArgumentException("Block " + s + " does not exist!").printStackTrace();
                continue;
            }
            ores.add(b.func_176203_a(meta));
        }
        this.initted = true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

