/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.util;

import malte0811.industrialwires.util.ConversionUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.energy.IEnergyStorage;

public class JouleEnergyStorage
implements IEnergyStorage {
    private double energyStored;
    private final double maxStored;
    private final double maxWattIn;
    private final double maxWattOut;

    public JouleEnergyStorage(double energyStored, double maxStored, double maxWattIn, double maxWattOut) {
        this.energyStored = energyStored;
        this.maxStored = maxStored;
        this.maxWattIn = maxWattIn;
        this.maxWattOut = maxWattOut;
    }

    public JouleEnergyStorage(double maxStored, double maxWattIn, double maxWattOut) {
        this(0.0, maxStored, maxWattIn, maxWattOut);
    }

    public JouleEnergyStorage(double maxStored, double maxWattIO) {
        this(maxStored, maxWattIO, maxWattIO);
    }

    public double getEnergyStoredJ() {
        return this.energyStored;
    }

    public void setEnergyStoredJ(double energyStored) {
        this.energyStored = energyStored;
    }

    public double getMaxInPerTick() {
        return this.maxWattIn / 20.0;
    }

    public double getMaxOutPerTick() {
        return this.maxWattOut / 20.0;
    }

    public double insert(double amount, double conversionFactor, boolean simulate) {
        return this.insert(amount, conversionFactor, simulate, Double.POSITIVE_INFINITY);
    }

    public double insert(double amount, double conversionFactor, boolean simulate, double maximum) {
        double joules = amount * conversionFactor;
        joules = Math.min(joules, this.getMaxInPerTick());
        joules = Math.min(joules, this.maxStored - this.energyStored);
        joules = Math.min(joules, maximum);
        if (!simulate) {
            this.energyStored += joules;
        }
        return joules / conversionFactor;
    }

    public double extract(double amount, double conversionFactor, boolean simulate) {
        double joules = amount * conversionFactor;
        joules = Math.min(joules, this.getMaxOutPerTick());
        joules = Math.min(joules, this.energyStored);
        if (!simulate) {
            this.energyStored -= joules;
        }
        return joules / conversionFactor;
    }

    public double getRequested(double conversion) {
        return conversion * Math.min(this.getMaxInPerTick(), this.maxStored - this.energyStored);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return MathHelper.func_76143_f((double)this.insert(maxReceive, ConversionUtil.joulesPerIf(), simulate));
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return MathHelper.func_76128_c((double)this.extract(maxExtract, ConversionUtil.joulesPerIf(), simulate));
    }

    public int getEnergyStored() {
        return (int)(ConversionUtil.ifPerJoule() * this.energyStored);
    }

    public int getMaxEnergyStored() {
        return (int)(ConversionUtil.ifPerJoule() * this.maxStored);
    }

    public boolean canExtract() {
        return this.maxWattOut > 0.0;
    }

    public boolean canReceive() {
        return this.maxWattIn > 0.0;
    }

    public void writeToNbt(NBTTagCompound nbtOuter, String key) {
        NBTTagCompound nbt = key == null ? nbtOuter : new NBTTagCompound();
        nbt.func_74780_a("energy", this.energyStored);
        nbt.func_74774_a("version", (byte)1);
        if (key != null) {
            nbtOuter.func_74782_a(key, (NBTBase)nbt);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        byte b = nbt.func_74771_c("version");
        switch (b) {
            case 0: {
                this.setEnergyStoredJ(nbt.func_74769_h("stored"));
                break;
            }
            case 1: {
                this.setEnergyStoredJ(nbt.func_74769_h("energy"));
            }
        }
    }
}

