/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.util;

import net.minecraft.util.math.Vec3d;

public final class Beziers {
    private Beziers() {
    }

    public static Vec3d getPoint(double t, Vec3d[] controls) {
        if (t == 0.0) {
            return controls[0];
        }
        if (t == 1.0) {
            return controls[controls.length - 1];
        }
        Vec3d ret = new Vec3d(0.0, 0.0, 0.0);
        int n = controls.length - 1;
        for (int i = 0; i <= n; ++i) {
            double coeff = (double)Beziers.binomialCoeff(n, i) * Math.pow(t, i) * Math.pow(1.0 - t, n - i);
            ret = ret.func_72441_c(coeff * controls[i].field_72450_a, coeff * controls[i].field_72448_b, coeff * controls[i].field_72449_c);
        }
        return ret;
    }

    public static int binomialCoeff(int n, int k) {
        return Beziers.factorial(n - k + 1, n) / Beziers.factorial(2, k);
    }

    public static int factorial(int start, int end) {
        int ret = 1;
        for (int i = start; i <= end; ++i) {
            ret *= i;
        }
        return ret;
    }
}

