/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.crafting;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.items.ItemIC2Coil;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeCoilLength
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public final ItemStack coil;
    public final List<Pair<Ingredient, Integer>> cables;
    private final int maxLength;

    public RecipeCoilLength(ItemStack coil, List<Pair<Ingredient, Integer>> cables) {
        this.coil = coil;
        this.cables = cables;
        this.maxLength = ItemIC2Coil.getMaxWireLength(this.coil);
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nullable World worldIn) {
        int l = this.getLength(inv);
        return l > 0;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        ItemStack ret = new ItemStack((Item)IndustrialWires.coil, 1, this.coil.func_77952_i());
        ItemIC2Coil.setLength(ret, Math.min(this.maxLength, this.getLength(inv)));
        return ret;
    }

    public boolean func_194133_a(int width, int height) {
        return width > 0 && height > 0;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.coil;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inv) {
        NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        int length = Math.min(this.getLength(inv), this.maxLength);
        for (int i = 0; i < ret.size() && length > 0; ++i) {
            ItemStack curr = inv.func_70301_a(i);
            if (OreDictionary.itemMatches((ItemStack)curr, (ItemStack)this.coil, (boolean)false)) {
                if ((length -= ItemIC2Coil.getLength(curr)) >= 0) continue;
                ItemStack currStack = this.coil.func_77946_l();
                ret.set(i, (Object)currStack);
                ItemIC2Coil.setLength(currStack, -length);
                continue;
            }
            length -= this.getCableLength(curr);
        }
        return ret;
    }

    private int getLength(InventoryCrafting inv) {
        int totalLength = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack curr = inv.func_70301_a(i);
            if (OreDictionary.itemMatches((ItemStack)curr, (ItemStack)this.coil, (boolean)false)) {
                totalLength += ItemIC2Coil.getLength(curr);
                continue;
            }
            int slotLength = this.getCableLength(curr);
            if (slotLength > 0) {
                totalLength += slotLength;
                continue;
            }
            if (curr.func_190926_b()) continue;
            return -1;
        }
        return totalLength;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        Random r = new Random();
        NonNullList ret = NonNullList.func_191197_a((int)9, (Object)Ingredient.field_193370_a);
        for (int i = 0; i < ret.size(); ++i) {
            int length = 1;
            for (Pair<Ingredient, Integer> cable : this.cables) {
                length += ((Ingredient)cable.getLeft()).func_193365_a().length;
            }
            ItemStack[] types = new ItemStack[length];
            int cablePos = 0;
            if (r.nextBoolean()) {
                types[length - 1] = this.coil;
            } else {
                types[0] = this.coil;
                cablePos = 1;
            }
            for (Pair<Ingredient, Integer> cable : this.cables) {
                ItemStack[] matching = ((Ingredient)cable.getLeft()).func_193365_a();
                System.arraycopy(matching, 0, types, cablePos, matching.length);
                cablePos += matching.length;
            }
            ret.set(i, (Object)new UnmatchedIngredient(types));
        }
        return ret;
    }

    private int getCableLength(ItemStack stack) {
        for (Pair<Ingredient, Integer> ingred : this.cables) {
            if (!((Ingredient)ingred.getLeft()).apply(stack)) continue;
            return (Integer)ingred.getRight();
        }
        return 0;
    }

    private static class UnmatchedIngredient
    extends Ingredient {
        public UnmatchedIngredient(ItemStack[] in) {
            super(in);
        }

        public boolean apply(@Nullable ItemStack input) {
            if (input == null) {
                return false;
            }
            for (ItemStack stack : this.func_193365_a()) {
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)input) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)input)) continue;
                return true;
            }
            return false;
        }

        @Nonnull
        public IntList func_194139_b() {
            return new IntArrayList(0);
        }
    }
}

