/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.client.gui.GuiPanelCreator;
import malte0811.industrialwires.client.panelmodel.RawModelFontRenderer;
import malte0811.industrialwires.controlpanel.IConfigurableComponent;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Label
extends PanelComponent
implements IConfigurableComponent {
    private String text = "Test";
    private int color = 0x808080;

    public Label(String text, int color) {
        this();
        this.text = text;
        this.color = color;
    }

    public Label() {
        super("label");
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt, boolean toItem) {
        nbt.func_74778_a("text", this.text);
        nbt.func_74768_a("color", this.color);
    }

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        this.text = nbt.func_74779_i("text");
        this.color = nbt.func_74762_e("color");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<RawQuad> getQuads() {
        RawModelFontRenderer render = RawModelFontRenderer.get();
        render.setScale(1.0f);
        render.func_78276_b(this.text, 0, 0, 0xFF000000 | this.color);
        return render.build();
    }

    @Override
    @Nonnull
    public Label copyOf() {
        Label ret = new Label(this.text, this.color);
        ret.setX(this.x);
        ret.setY(this.y);
        ret.panelHeight = this.panelHeight;
        return ret;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBlockRelativeAABB() {
        if (this.aabb == null) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                RawModelFontRenderer fr = RawModelFontRenderer.get();
                float width = (float)fr.func_78256_a(this.text) * fr.getScale();
                float height = (float)fr.field_78288_b * fr.getScale();
                this.aabb = new AxisAlignedBB((double)this.getX(), 0.0, (double)this.getY(), (double)(this.getX() + width), 0.0, (double)(this.getY() + height));
            } else {
                this.aabb = new AxisAlignedBB((double)this.getX(), 0.0, (double)this.getY(), (double)this.getX() + 0.001, 0.0, (double)this.getY() + 0.001);
            }
        }
        return this.aabb;
    }

    @Override
    public void interactWith(Vec3d hitRelative, EntityPlayerMP player) {
    }

    @Override
    public void update() {
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public float getHeight() {
        return 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInGUI(GuiPanelCreator gui) {
        int left = (int)((float)gui.getX0() + this.getX() * (float)gui.panelSize);
        int top = (int)((float)gui.getY0() + this.getY() * (float)gui.panelSize);
        GlStateManager.func_179094_E();
        float scale = (float)(gui.field_146297_k.field_71466_p.field_78288_b * gui.panelSize) / 1296.0f;
        GlStateManager.func_179109_b((float)left, (float)top, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        gui.field_146297_k.field_71466_p.func_78276_b(this.text, 0, 0, 0xFF000000 | this.color);
        GlStateManager.func_179121_F();
    }

    @Override
    public void applyConfigOption(IConfigurableComponent.ConfigType type, int id, NBTBase value) {
        switch (type) {
            case STRING: {
                this.text = ((NBTTagString)value).func_150285_a_();
                break;
            }
            case FLOAT: {
                this.color = PanelUtils.setColor(this.color, id, value);
            }
        }
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigName(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case FLOAT: {
                return I18n.func_135052_a((String)("industrialwires.desc." + (id == 0 ? "red" : (id == 1 ? "green" : "blue"))), (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigDescription(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case STRING: {
                return I18n.func_135052_a((String)"industrialwires.desc.label_text", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public IConfigurableComponent.StringConfig[] getStringOptions() {
        return new IConfigurableComponent.StringConfig[]{new IConfigurableComponent.StringConfig("text", 0, 0, this.text)};
    }

    @Override
    public IConfigurableComponent.FloatConfig[] getFloatOptions() {
        float[] color = PanelUtils.getFloatColor(true, this.color);
        return new IConfigurableComponent.FloatConfig[]{new IConfigurableComponent.FloatConfig("red", 0, 30, Float.valueOf(color[0]), 60), new IConfigurableComponent.FloatConfig("green", 0, 50, Float.valueOf(color[1]), 60), new IConfigurableComponent.FloatConfig("blue", 0, 70, Float.valueOf(color[2]), 60)};
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Label label = (Label)o;
        if (this.color != label.color) {
            return false;
        }
        return this.text.equals(label.text);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.text.hashCode();
        result = 31 * result + this.color;
        return result;
    }
}

