/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.client.multiblock_io_model;

import blusunrize.immersiveengineering.api.IEApi;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import malte0811.industrialwires.client.multiblock_io_model.BakedMBIOModel;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MBIOModelLoader
implements ICustomModelLoader {
    private static final Set<BakedMBIOModel> activeModels = new HashSet<BakedMBIOModel>();

    public boolean accepts(@Nonnull ResourceLocation modelLocation) {
        return "industrialwires".equals(modelLocation.func_110624_b()) && "models/block/mbio".equals(modelLocation.func_110623_a());
    }

    @Nonnull
    public IModel loadModel(@Nonnull ResourceLocation modelLocation) throws Exception {
        return new MBIOModel();
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        activeModels.clear();
        BakedMBIOModel.IO_TEX = null;
    }

    static {
        IEApi.renderCacheClearers.add(() -> {
            for (BakedMBIOModel m : activeModels) {
                m.clearCache();
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private static class MBIOModel
    implements IModel {
        private static final Collection<ResourceLocation> TEXTURES = ImmutableList.of((Object)BakedMBIOModel.IO_LOC);
        private ResourceLocation baseModel = new ResourceLocation("industrialwires", "missing");
        private ImmutableMap<String, String> custom = ImmutableMap.of();

        private MBIOModel() {
        }

        @Nonnull
        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.of((Object)this.baseModel);
        }

        @Nonnull
        public Collection<ResourceLocation> getTextures() {
            return TEXTURES;
        }

        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public IBakedModel bake(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            try {
                IModel baseBaked = ModelLoaderRegistry.getModel((ResourceLocation)this.baseModel);
                baseBaked = baseBaked.process(this.custom);
                IBakedModel baked = baseBaked.bake(state, format, bakedTextureGetter);
                BakedMBIOModel ret = new BakedMBIOModel(baked, state);
                activeModels.add(ret);
                return ret;
            }
            catch (Exception e) {
                e.printStackTrace();
                return ModelLoaderRegistry.getMissingModel().bake(state, format, bakedTextureGetter);
            }
        }

        @Nonnull
        public IModel process(ImmutableMap<String, String> customData) {
            MBIOModel ret = new MBIOModel();
            String bm = (String)customData.get((Object)"base_model");
            ret.baseModel = new ResourceLocation(bm.substring(1, bm.length() - 1));
            ret.custom = customData;
            return ret;
        }
    }
}

