/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.controlpanel;

import java.util.Arrays;
import java.util.function.Consumer;
import malte0811.industrialwires.blocks.INetGUI;
import malte0811.industrialwires.blocks.controlpanel.TileEntityGeneralCP;
import malte0811.industrialwires.controlpanel.ControlPanelNetwork;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public abstract class TileEntityRSPanel
extends TileEntityGeneralCP
implements INetGUI,
ITickable {
    protected byte[] out = new byte[16];
    private boolean dirty = true;
    private byte[] currInput = new byte[16];
    private final ControlPanelNetwork.RSChannel[] channels = new ControlPanelNetwork.RSChannel[16];
    private int controller = 0;

    public TileEntityRSPanel() {
        for (int i = 0; i < 16; ++i) {
            this.currInput[i] = -1;
        }
        this.updateChannelsArray();
    }

    private void updateChannelsArray() {
        for (byte i = 0; i < 16; i = (byte)(i + 1)) {
            this.channels[i] = new ControlPanelNetwork.RSChannel(this.controller, i);
        }
    }

    public void func_73660_a() {
        if (this.dirty) {
            this.updateOutput();
            this.dirty = false;
        }
    }

    @Override
    public void writeNBT(NBTTagCompound nbt, boolean updatePacket) {
        nbt.func_74773_a("out", this.out);
        nbt.func_74768_a("rsId", this.controller);
    }

    @Override
    public void readNBT(NBTTagCompound nbt, boolean updatePacket) {
        this.out = nbt.func_74770_j("out");
        this.controller = nbt.func_74762_e("rsId");
        this.updateChannelsArray();
    }

    protected void markRSDirty() {
        this.dirty = true;
    }

    protected void inputUpdate(byte[] newIn) {
        if (!Arrays.equals(this.currInput, newIn)) {
            ControlPanelNetwork.RSChannelState[] newStates = new ControlPanelNetwork.RSChannelState[16];
            for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
                newStates[i] = newIn[i] > this.out[i] ? new ControlPanelNetwork.RSChannelState(this.channels[i], newIn[i]) : new ControlPanelNetwork.RSChannelState(this.channels[i], 0);
            }
            this.panelNetwork.setOutputs(this, newStates);
            this.currInput = Arrays.copyOf(newIn, 16);
        }
    }

    @Override
    public void setNetworkAndInit(ControlPanelNetwork newNet) {
        super.setNetworkAndInit(newNet);
        this.inputUpdate(this.currInput);
        Consumer<ControlPanelNetwork.RSChannelState> listener = state -> {
            if (this.out[state.getColor()] != state.getStrength()) {
                this.out[state.getColor()] = state.getStrength();
                this.dirty = true;
            }
        };
        this.panelNetwork.addListener(this, listener, this.channels);
    }

    @Override
    public void onChange(NBTTagCompound nbt, EntityPlayer p) {
        if (nbt.func_74764_b("rsId")) {
            this.controller = nbt.func_74762_e("rsId");
            this.func_70296_d();
            this.panelNetwork.removeIOFor(this);
            this.setNetworkAndInit(this.panelNetwork);
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public int getRsId() {
        return this.controller;
    }

    protected abstract void updateOutput();
}

