/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.ContainerEnderCap;
import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.EnderSlot;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.gui.IoConfigRenderer;
import crazypants.enderio.base.gui.RedstoneModeButton;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityMachineEntity;
import crazypants.enderio.base.machine.gui.GuiButtonIoConfig;
import crazypants.enderio.base.machine.gui.GuiOverlayIoConfig;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.machine.modes.IoMode;
import info.loenwind.scheduler.Celeb;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;

public class GuiCapMachineBase<T extends AbstractCapabilityMachineEntity>
extends GuiContainerBaseEIO {
    @Nonnull
    public static final Vector4f PUSH_COLOR = new Vector4f(0.8f, 0.4f, 0.1f, 0.5f);
    @Nonnull
    public static final Vector4f PULL_COLOR = new Vector4f(0.1f, 0.4f, 0.8f, 0.5f);
    public static final int BUTTON_SIZE = 16;
    private static final int CONFIG_ID = 8962349;
    private static final int RECIPE_ID = 8962350;
    @Nonnull
    private final T tileEntity;
    @Nonnull
    protected RedstoneModeButton<T> redstoneButton;
    @Nonnull
    private final GuiOverlayIoConfig<T> configOverlay;
    @Nonnull
    protected final GuiButtonIoConfig<T> configB;
    @Nonnull
    protected IconButton recipeButton;
    protected List<GuiToolTip> progressTooltips;
    protected int lastProgressTooltipValue = -1;
    @Nonnull
    private final ContainerEnderCap<EnderInventory, T> capContainer;
    static long[] LAYERSEED = null;

    protected GuiCapMachineBase(@Nonnull T machine, @Nonnull ContainerEnderCap<EnderInventory, T> par1Container, String ... guiTexture) {
        super((Container)par1Container, guiTexture);
        this.tileEntity = machine;
        this.capContainer = par1Container;
        this.field_146999_f = this.getXSize();
        this.field_147000_g = this.getYSize();
        int x = this.getButtonXPos() - 5 - 16;
        int y = 5;
        this.redstoneButton = new RedstoneModeButton<T>((IGuiScreen)this, -1, x, y, this.tileEntity);
        this.configOverlay = new GuiOverlayIoConfig((IIoConfigurable)machine);
        this.addOverlay(this.configOverlay);
        this.configB = new GuiButtonIoConfig<T>((IGuiScreen)this, 8962349, x, y += 19, machine, this.configOverlay);
        y += 19;
        if (((Boolean)PersonalConfig.recipeButtonInMachineGuis.get()).booleanValue()) {
            this.recipeButton = new IconButton((IGuiScreen)this, 8962350, x, y, (IWidgetIcon)IconEIO.RECIPE_BOOK);
            this.recipeButton.setIsVisible(false);
        } else {
            this.recipeButton = new IconButton((IGuiScreen)this, 8962350, x, y, (IWidgetIcon)IconEIO.RECIPE);
            this.recipeButton.setIsVisible(false);
            this.recipeButton.setIconMargin(1, 1);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.redstoneButton.onGuiInit();
        this.configB.onGuiInit();
        this.recipeButton.onGuiInit();
    }

    protected boolean showRecipeButton() {
        return EnderIO.proxy.isAnEiInstalled();
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (GuiButton guiButton : this.field_146292_n) {
            guiButton.func_191745_a(this.field_146297_k, 0, 0, 0.0f);
        }
        if (this.showRecipeButton()) {
            this.recipeButton.setIsVisible(true);
        }
        super.func_146976_a(par1, par2, par3);
        this.renderSlotHighlights();
    }

    public void renderSlotHighlights() {
        IoConfigRenderer.SelectedFace<T> sel = this.configOverlay.getSelection();
        if (sel != null) {
            IoMode mode = ((AbstractCapabilityMachineEntity)sel.config).getIoMode(sel.face);
            this.renderSlotHighlights(mode);
        }
    }

    public void renderSlotHighlights(@Nonnull IoMode mode) {
        Map slotLocations = this.getInventory().getSlotLocations();
        for (Slot slot : slotLocations.keySet()) {
            if (!(slot instanceof EnderSlot)) continue;
            EnderInventory.Type type = ((EnderSlot)slot).getType();
            if (mode == IoMode.PULL) {
                if (type != EnderInventory.Type.INPUT && type != EnderInventory.Type.INOUT) continue;
                this.renderSlotHighlight(slot, PULL_COLOR);
                continue;
            }
            if (mode == IoMode.PUSH) {
                if (type != EnderInventory.Type.OUTPUT && type != EnderInventory.Type.INOUT) continue;
                this.renderSlotHighlight(slot, PUSH_COLOR);
                continue;
            }
            if (mode != IoMode.PUSH_PULL) continue;
            if (type == EnderInventory.Type.INPUT) {
                this.renderSlotHighlight(slot, PULL_COLOR);
                continue;
            }
            if (type == EnderInventory.Type.OUTPUT) {
                this.renderSlotHighlight(slot, PUSH_COLOR);
                continue;
            }
            if (type != EnderInventory.Type.INOUT) continue;
            this.renderSplitHighlight(slot);
        }
    }

    protected void renderSlotHighlight(@Nonnull Slot invSlot, @Nonnull Vector4f col) {
        this.renderSlotHighlight(col, invSlot.field_75223_e, invSlot.field_75221_f, 16, 16);
    }

    protected void renderSlotHighlight(@Nonnull Vector4f col, int x, int y, int widthIn, int heightIn) {
        GlStateManager.func_179147_l();
        RenderUtil.renderQuad2D((double)(this.getGuiLeft() + x), (double)(this.getGuiTop() + y), (double)0.0, (double)widthIn, (double)heightIn, (Vector4f)col);
        GlStateManager.func_179084_k();
    }

    protected void renderSplitHighlight(@Nonnull Slot invSlot) {
        this.renderSplitHighlight(invSlot.field_75223_e, invSlot.field_75221_f, 16, 16);
    }

    protected void renderSplitHighlight(int x, int y, int widthIn, int heightIn) {
        GlStateManager.func_179147_l();
        RenderUtil.renderQuad2D((double)(this.getGuiLeft() + x), (double)(this.getGuiTop() + y), (double)0.0, (double)widthIn, (double)(heightIn / 2), (Vector4f)PULL_COLOR);
        RenderUtil.renderQuad2D((double)(this.getGuiLeft() + x), (double)(this.getGuiTop() + y + heightIn / 2), (double)0.0, (double)widthIn, (double)(heightIn / 2), (Vector4f)PUSH_COLOR);
        GlStateManager.func_179084_k();
    }

    protected boolean isConfigOverlayEnabled() {
        return this.configOverlay.isVisible();
    }

    @Nonnull
    protected T getTileEntity() {
        return this.tileEntity;
    }

    protected void addProgressTooltip(int x, int y, int w, int h) {
        if (this.progressTooltips == null) {
            this.progressTooltips = new ArrayList<GuiToolTip>();
        }
        GuiToolTip tt = new GuiToolTip(new Rectangle(x, y, w, h), (String[])null);
        this.progressTooltips.add(tt);
        this.addToolTip(tt);
    }

    protected final void updateProgressTooltips(int scaledProgress, float progress) {
        if (this.lastProgressTooltipValue == scaledProgress || this.progressTooltips == null) {
            return;
        }
        this.lastProgressTooltipValue = scaledProgress;
        if (scaledProgress < 0) {
            for (GuiToolTip tt : this.progressTooltips) {
                tt.setIsVisible(false);
            }
            return;
        }
        String msg = this.formatProgressTooltip(scaledProgress, progress);
        String[] tooltip = msg.split("\\|");
        for (GuiToolTip tt : this.progressTooltips) {
            tt.setToolTipText(tooltip);
            tt.setIsVisible(true);
        }
    }

    protected String formatProgressTooltip(int scaledProgress, float progress) {
        return Lang.GUI_GENERIC_PROGRESS.get(scaledProgress);
    }

    protected int scaleProgressForTooltip(float progress) {
        return (int)(progress * 100.0f);
    }

    protected boolean shouldRenderProgress() {
        if (this.tileEntity instanceof IProgressTile) {
            float progress = ((IProgressTile)this.tileEntity).getProgress();
            if (progress >= 0.0f && progress < 1.0f) {
                this.updateProgressTooltips(this.scaleProgressForTooltip(progress), progress);
                return true;
            }
            this.updateProgressTooltips(-1, -1.0f);
            return false;
        }
        return false;
    }

    protected int getProgressScaled(int scale) {
        if (this.tileEntity instanceof IProgressTile) {
            return Util.getProgressScaled((int)scale, (IProgressTile)((IProgressTile)this.tileEntity));
        }
        return 0;
    }

    protected int getButtonXPos() {
        return this.getXSize();
    }

    public void func_146270_b(int tint) {
        if (Celeb.SPACE.isOn() && NullHelper.untrust((Object)this.field_146297_k.field_71441_e) != null && ((Boolean)PersonalConfig.celebrateSpaceDay.get()).booleanValue()) {
            GuiCapMachineBase.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-553648128);
            long tickCount = EnderIO.proxy.getTickCount();
            Random rand = new Random();
            if (LAYERSEED == null) {
                LAYERSEED = new long[10];
                for (int i = 0; i < LAYERSEED.length; ++i) {
                    GuiCapMachineBase.LAYERSEED[i] = rand.nextLong();
                }
            }
            for (int layer = 1; layer < 10; ++layer) {
                for (int star = 0; star < this.field_146294_l - 1; ++star) {
                    long seed = LAYERSEED[layer] + (long)star + tickCount / (long)layer;
                    rand.setSeed(seed);
                    int y = rand.nextInt(this.field_146295_m * 10 * layer / 3);
                    int r = rand.nextInt(64);
                    int g = rand.nextInt(64);
                    int b = rand.nextInt(32);
                    int color = 255 - r << 16 | 255 - g << 8 | 255 - b;
                    if (y >= this.field_146295_m) continue;
                    GuiCapMachineBase.func_73734_a((int)star, (int)y, (int)(star + 1), (int)(y + 1), (int)(0xA0000000 | color));
                    GuiCapMachineBase.func_73734_a((int)(star + 1), (int)y, (int)(star + 2), (int)(y + 1), (int)(0x20000000 | color));
                }
            }
            return;
        }
        super.func_146270_b(tint);
        if (((Boolean)PersonalConfig.GUIBrandingEnabled.get()).booleanValue()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((Float)PersonalConfig.GUIBrandingAlpha.get()).floatValue());
            RenderUtil.bindTexture((String)((String)PersonalConfig.GUIBrandingTexture.get()));
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.01f);
            int size = Math.min(this.field_146294_l, this.field_146295_m) / (Integer)PersonalConfig.GUIBrandingTiles.get();
            GuiCapMachineBase.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_146294_l, (int)this.field_146295_m, (float)size, (float)size);
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
        }
    }

    @Nonnull
    public ContainerEnderCap<EnderInventory, T> getInventory() {
        return this.capContainer;
    }
}

