/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.infinity;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.block.painted.BlockItemPaintedBlock;
import crazypants.enderio.base.render.IDefaultRenderers;
import crazypants.enderio.base.render.ranged.InfinityParticle;
import crazypants.enderio.util.CapturedMob;
import crazypants.enderio.util.NbtValue;
import info.loenwind.scheduler.Celeb;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInfinity
extends BlockEio<TileEntityEio>
implements IDefaultRenderers,
IResourceTooltipProvider {
    @Nonnull
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    @Nonnull
    public static final PropertyBool HARMLESS = PropertyBool.func_177716_a((String)"harmless");
    @Nonnull
    private final Random rand = new Random();
    @Nonnull
    private final Random stableRand = new Random();

    public static BlockInfinity create(@Nonnull IModObject modObject) {
        BlockInfinity result = new BlockInfinity(modObject, false);
        return result;
    }

    protected BlockInfinity(@Nonnull IModObject modObject, boolean silent) {
        super(modObject, Material.field_175972_I);
        this.func_149647_a(EnderIOTab.tabEnderIOMaterials);
        this.func_149672_a(new SoundType(-1.0f, 1.0f, SoundEvents.field_187546_ae, SoundEvents.field_187554_ai, SoundEvents.field_187552_ah, SoundEvents.field_187550_ag, SoundEvents.field_187548_af));
        this.initDefaultState();
        this.setShape((BlockEnder.IShape)new BlockEnder.IShape<TileEntityEio>(){

            @Nonnull
            public BlockFaceShape getBlockFaceShape(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
                return BlockFaceShape.values()[BlockInfinity.this.rand.nextInt(BlockFaceShape.values().length)];
            }
        });
    }

    protected void initDefaultState() {
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, HARMLESS});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta & 7)).func_177226_a((IProperty)HARMLESS, (Comparable)Boolean.valueOf(meta > 7));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) + ((Boolean)state.func_177229_b((IProperty)HARMLESS) != false ? 8 : 0);
    }

    @Override
    public Item createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemPaintedBlock((Block)this));
    }

    public int func_180656_a(@Nonnull IBlockState state, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        this.stableRand.setSeed(EnderIO.proxy.getServerTickCount() ^ pos.func_177986_g());
        return this.stableRand.nextInt(16);
    }

    public boolean func_149744_f(@Nonnull IBlockState state) {
        this.stableRand.setSeed(EnderIO.proxy.getServerTickCount() ^ (long)state.hashCode());
        return this.stableRand.nextBoolean();
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@Nonnull IBlockState blockStateIn, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_176209_a(@Nonnull IBlockState state, boolean hitIfLiquid) {
        return false;
    }

    public void func_180653_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
    }

    public boolean func_176200_f(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return true;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public void onBlockPlaced(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase player, @Nonnull ItemStack stack) {
        if (!world.field_72995_K) {
            world.func_180497_b(pos, (Block)this, this.rand.nextInt(40) + 1, 0);
        }
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rnd) {
        if (!world.field_72995_K) {
            if (world.func_175710_j(pos)) {
                world.func_175698_g(pos);
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true));
                return;
            }
            IBlockState newState = rnd.nextFloat() < 0.165f ? state.func_177231_a((IProperty)AGE) : state;
            Boolean isHarmless = (Boolean)state.func_177229_b((IProperty)HARMLESS);
            if ((Integer)newState.func_177229_b((IProperty)AGE) == 7) {
                world.func_175698_g(pos);
                if (!isHarmless.booleanValue()) {
                    if (rnd.nextFloat() < 0.165f) {
                        this.spawnResult(world, pos, rnd);
                    }
                    if (rnd.nextFloat() < 0.33f) {
                        this.spawnResult(world, pos, rnd);
                    }
                    this.spawnResult(world, pos, rnd);
                    if (rnd.nextFloat() < 0.05f) {
                        BlockInfinity.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
                    }
                }
                return;
            }
            if (rnd.nextFloat() < 0.33f) {
                NNList airs = new NNList();
                NNList.NNIterator itr = NNList.FACING.fastIterator();
                while (itr.hasNext()) {
                    BlockPos neighbor = pos.func_177972_a((EnumFacing)itr.next());
                    if (world.func_175623_d(neighbor)) {
                        airs.add((Object)neighbor);
                        continue;
                    }
                    IBlockState neighborState = world.func_180495_p(neighbor);
                    if (neighborState.func_177230_c() != this || !((Boolean)neighborState.func_177229_b((IProperty)HARMLESS)).booleanValue()) continue;
                    airs.add((Object)neighbor);
                }
                if (airs.size() >= 2) {
                    BlockPos targetPos1;
                    if (!isHarmless.booleanValue() && airs.size() >= 3 && rnd.nextFloat() < 0.025f) {
                        targetPos1 = (BlockPos)airs.remove(this.rand.nextInt(airs.size()));
                        BlockPos targetPos2 = (BlockPos)airs.remove(this.rand.nextInt(airs.size()));
                        world.func_175656_a(targetPos1, newState);
                        world.func_180497_b(targetPos1, (Block)this, this.rand.nextInt(40), 0);
                        world.func_175656_a(targetPos2, newState);
                        world.func_180497_b(targetPos2, (Block)this, this.rand.nextInt(40), 0);
                        world.func_175698_g(pos);
                        return;
                    }
                    if (!isHarmless.booleanValue() && rnd.nextFloat() < 0.025f) {
                        targetPos1 = (BlockPos)airs.remove(this.rand.nextInt(airs.size()));
                        world.func_175656_a(targetPos1, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
                        world.func_180497_b(targetPos1, (Block)this, this.rand.nextInt(40), 0);
                        world.func_175656_a(pos, newState);
                        world.func_180497_b(pos, (Block)this, this.rand.nextInt(40), 0);
                        return;
                    }
                    if (rnd.nextFloat() < 0.5f) {
                        targetPos1 = (BlockPos)airs.remove(this.rand.nextInt(airs.size()));
                        world.func_175656_a(targetPos1, newState);
                        world.func_180497_b(targetPos1, (Block)this, this.rand.nextInt(40), 0);
                        world.func_175698_g(pos);
                        return;
                    }
                    if (!isHarmless.booleanValue()) {
                        targetPos1 = (BlockPos)airs.remove(this.rand.nextInt(airs.size()));
                        world.func_175656_a(targetPos1, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)HARMLESS, (Comparable)Boolean.valueOf(true)));
                        world.func_180497_b(targetPos1, (Block)this, this.rand.nextInt(40), 0);
                    }
                } else if (!isHarmless.booleanValue()) {
                    world.func_175698_g(pos);
                    world.func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.1f, true);
                    return;
                }
            }
            if (state != newState) {
                world.func_175656_a(pos, newState);
            }
            world.func_180497_b(pos, (Block)this, this.rand.nextInt(40), 0);
        }
    }

    protected void spawnResult(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rnd) {
        if (Celeb.C24.isOn() && rnd.nextFloat() < 0.13f) {
            this.spawn(world, pos, "snowman");
        }
        if (rnd.nextFloat() < 0.1f) {
            this.spawn(world, pos, "endermite");
        }
        switch (rnd.nextInt(10)) {
            case 0: 
            case 1: {
                if (rnd.nextFloat() < 0.2f) {
                    this.spawn(world, pos, "silverfish");
                }
            }
            case 2: {
                if (rnd.nextFloat() < 0.1f) {
                    this.spawn(world, pos, "silverfish");
                    this.spawn(world, pos, "silverfish");
                }
                return;
            }
            case 3: {
                if (rnd.nextFloat() < 0.2f) {
                    this.spawn(world, pos, "slime");
                }
                return;
            }
            case 4: {
                if (rnd.nextFloat() < 0.33f) {
                    this.spawn(world, pos, "enderman");
                } else if (rnd.nextFloat() < 0.01f) {
                    this.spawn(world, pos, "enderman");
                    this.spawn(world, pos, "enderman");
                    this.spawn(world, pos, "enderman");
                    this.spawn(world, pos, "enderman");
                    this.spawn(world, pos, "enderman");
                }
                return;
            }
            case 5: {
                this.spawn(world, pos, "enderman");
            }
            case 6: {
                if (rnd.nextFloat() < 0.15f) {
                    this.spawn(world, pos, "bat");
                }
            }
            case 7: {
                if (rnd.nextFloat() < 0.15f) {
                    this.spawn(world, pos, "bat");
                }
                return;
            }
            case 8: {
                if (rnd.nextFloat() < 0.025f) {
                    EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), null);
                    world.func_72838_d((Entity)entitytntprimed);
                    world.func_184148_a((EntityPlayer)null, entitytntprimed.field_70165_t, entitytntprimed.field_70163_u, entitytntprimed.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return;
            }
        }
        if (rnd.nextFloat() < 0.25f) {
            this.spawn(world, pos, "endermite");
        }
    }

    protected void spawn(final @Nonnull World world, final @Nonnull BlockPos pos0, @Nonnull String enitytype) {
        final CapturedMob capturedMob = CapturedMob.create(new ResourceLocation("minecraft", enitytype));
        if (capturedMob != null) {
            NNList.SHELL.apply((NNList.ShortCallback)new NNList.ShortCallback<BlockPos>(){

                public boolean apply(@Nonnull BlockPos e) {
                    BlockPos pos = pos0.func_177971_a((Vec3i)e);
                    return this.spawn(pos.func_177984_a()) || this.spawn(pos) || this.spawn(pos.func_177977_b()) || this.spawn(pos.func_177984_a().func_177984_a()) || this.spawn(pos.func_177984_a().func_177977_b().func_177977_b());
                }

                private boolean spawn(@Nullable BlockPos pos) {
                    Entity entity = capturedMob.doSpawn(world, pos, EnumFacing.DOWN, false);
                    if (entity != null) {
                        NbtValue.INFINITY.setBoolean(entity.getEntityData(), true);
                    }
                    return entity != null;
                }
            });
        }
    }

    public void func_180634_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Entity entityIn) {
        entityIn.func_70097_a(DamageSource.field_76380_i, 1.0f);
        if (!worldIn.field_72995_K) {
            if (this.rand.nextFloat() < 0.5f) {
                entityIn.func_70034_d(this.rand.nextFloat());
            }
            if (this.rand.nextFloat() < 0.5f) {
                entityIn.func_70024_g((double)(this.rand.nextFloat() * 2.0f - 1.0f), (double)this.rand.nextFloat(), (double)(this.rand.nextFloat() * 2.0f - 1.0f));
            }
            if (this.rand.nextFloat() < 0.1f) {
                entityIn.func_70066_B();
            }
            if (this.rand.nextFloat() < 0.1f) {
                entityIn.func_70015_d(1);
            }
            if (this.rand.nextFloat() < 0.1f && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70691_i(1.0f);
            }
            if (this.rand.nextFloat() < 0.05f && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 20, 0, true, true));
            }
            if (this.rand.nextFloat() < 0.05f && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76424_c, 20, 0, true, true));
            }
            if (this.rand.nextFloat() < 0.05f && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 0, true, true));
            }
            if (this.rand.nextFloat() < 0.05f && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 20, 0, true, true));
            }
            if (this.rand.nextFloat() < 0.05f && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76438_s, 20, 0, true, true));
            }
            if (this.rand.nextFloat() < 0.05f && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_188423_x, 20, 0, true, true));
            }
            if (this.rand.nextFloat() < 0.33f && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_188424_y, 20, 0, true, true));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rnd) {
        int count = world.func_175710_j(pos) ? 1 : 3;
        for (int i = 0; i < count; ++i) {
            float offsetX = 0.25f + 0.5f * rnd.nextFloat();
            float offsetY = 0.25f + 0.5f * rnd.nextFloat();
            float offsetZ = 0.25f + 0.5f * rnd.nextFloat();
            float maxSize = Math.min(Math.min(Math.min(1.0f - offsetX, offsetX), Math.min(1.0f - offsetY, offsetY)), Math.min(1.0f - offsetZ, offsetZ)) * (0.5f + 0.5f * rnd.nextFloat()) * 2.0f;
            float color = i == 0 && (Boolean)bs.func_177229_b((IProperty)HARMLESS) == false && count > 1 ? 0.0f : rnd.nextFloat();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new InfinityParticle(world, pos, new Vector4f(color, color, color, 0.4f), new Vector4f(offsetX, offsetY, offsetZ, maxSize)));
        }
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return this.func_149739_a();
    }
}

