/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Biomes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import teamroots.embers.particle.ParticleUtil;

public class Misc {
    public static final double LOG_E = Math.log10(Math.exp(1.0));
    public static Random random = new Random();

    public static boolean isValidLever(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockLever) {
            EnumFacing face = ((BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c();
            return face == side;
        }
        if (block instanceof BlockButton) {
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)BlockButton.field_176387_N);
            return face == side;
        }
        if (block instanceof BlockRedstoneTorch) {
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)BlockRedstoneTorch.field_176596_a);
            return face == side;
        }
        return false;
    }

    public static boolean isValidPipeConnector(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_193401_d(world, pos, side.func_176734_d()) == BlockFaceShape.CENTER_BIG;
    }

    public static EnumFacing getOppositeFace(EnumFacing face) {
        return face.func_176734_d();
    }

    public static EnumFacing getOppositeHorizontalFace(EnumFacing face) {
        return face.func_176740_k().func_176722_c() ? face.func_176734_d() : face;
    }

    public static EnumFacing getOppositeVerticalFace(EnumFacing face) {
        return face.func_176740_k().func_176720_b() ? face.func_176734_d() : face;
    }

    public static ItemStack getRepairItem(ItemStack stack) {
        try {
            if (stack.func_77973_b() instanceof ItemTool) {
                ItemStack mat = ((ItemTool)stack.func_77973_b()).field_77862_b.getRepairItemStack().func_77946_l();
                if (mat.func_77952_i() == Short.MAX_VALUE) {
                    mat.func_77964_b(0);
                }
                return mat;
            }
            if (stack.func_77973_b() instanceof ItemSword) {
                ItemStack mat = ((ItemSword)stack.func_77973_b()).field_150933_b.getRepairItemStack().func_77946_l();
                if (mat.func_77952_i() == Short.MAX_VALUE) {
                    mat.func_77964_b(0);
                }
                return mat;
            }
            if (stack.func_77973_b() instanceof ItemHoe) {
                ItemStack mat = ((ItemHoe)stack.func_77973_b()).field_77843_a.getRepairItemStack().func_77946_l();
                if (mat.func_77952_i() == Short.MAX_VALUE) {
                    mat.func_77964_b(0);
                }
                return mat;
            }
            if (stack.func_77973_b() instanceof ItemArmor) {
                ItemStack mat = ((ItemArmor)stack.func_77973_b()).func_82812_d().getRepairItemStack().func_77946_l();
                if (mat.func_77952_i() == Short.MAX_VALUE) {
                    mat.func_77964_b(0);
                }
                return mat;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ItemStack.field_190927_a;
    }

    public static List<TileEntity> getAdjacentTiles(World world, BlockPos pos) {
        ArrayList<TileEntity> tiles = new ArrayList<TileEntity>();
        tiles.add(world.func_175625_s(pos.func_177984_a()));
        tiles.add(world.func_175625_s(pos.func_177977_b()));
        tiles.add(world.func_175625_s(pos.func_177976_e()));
        tiles.add(world.func_175625_s(pos.func_177974_f()));
        tiles.add(world.func_175625_s(pos.func_177978_c()));
        tiles.add(world.func_175625_s(pos.func_177968_d()));
        return tiles;
    }

    public static EntityItem rayTraceItem(World world, double posX, double posY, double posZ, double dirX, double dirY, double dirZ) {
        double x = posX;
        double y = posY;
        double z = posZ;
        for (int i = 0; i < 120; ++i) {
            List items;
            if ((items = world.func_72872_a(EntityItem.class, new AxisAlignedBB((x += dirX / 20.0) - 0.2, (y += dirY / 20.0) - 0.2, (z += dirZ / 20.0) - 0.2, x + 0.2, y + 0.2, z + 0.2))).size() <= 0) continue;
            return (EntityItem)items.get(0);
        }
        return null;
    }

    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static boolean matchOreDict(ItemStack stack1, ItemStack stack2) {
        int[] keys1 = OreDictionary.getOreIDs((ItemStack)stack1);
        int[] keys2 = OreDictionary.getOreIDs((ItemStack)stack2);
        for (int i = 0; i < keys1.length; ++i) {
            for (int j = 0; j < keys2.length; ++j) {
                if (keys1[i] != keys2[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean betweenAngles(float angleTest, float angleLow, float angleHigh) {
        boolean between;
        boolean bl = between = angleTest >= angleLow && angleTest <= angleHigh;
        if (angleHigh < angleLow) {
            between = angleTest >= angleLow && angleTest < 360.0f || angleTest > 0.0f && angleTest <= angleHigh;
        }
        return between;
    }

    public static float yawDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        float f = (float)(180.0 * Math.atan2(posX2 - posX, posZ2 - posZ) / 3.1415927410125732);
        return f;
    }

    public static float pitchDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        return (float)Math.toDegrees(Math.atan2(posY2 - posY, Math.sqrt((posX2 - posX) * (posX2 - posX) + (posZ2 - posZ) * (posZ2 - posZ))));
    }

    public static int getResourceCount(ItemStack stack) {
        int baseCount = 0;
        if (stack.func_77973_b() instanceof ItemArmor) {
            ItemArmor armor = (ItemArmor)stack.func_77973_b();
            if (armor.field_77881_a == EntityEquipmentSlot.HEAD) {
                baseCount = 5;
            }
            if (armor.field_77881_a == EntityEquipmentSlot.CHEST) {
                baseCount = 8;
            }
            if (armor.field_77881_a == EntityEquipmentSlot.LEGS) {
                baseCount = 7;
            }
            if (armor.field_77881_a == EntityEquipmentSlot.FEET) {
                baseCount = 4;
            }
        }
        if (stack.func_77973_b() instanceof ItemSword) {
            baseCount = 2;
        }
        if (stack.func_77973_b() instanceof ItemHoe) {
            baseCount = 2;
        }
        if (stack.func_77973_b() instanceof ItemBow) {
            baseCount = 3;
        }
        if (stack.func_77973_b() instanceof ItemTool) {
            baseCount = stack.func_77973_b() instanceof ItemPickaxe || stack.func_77973_b().getHarvestLevel(stack, "pickaxe", null, null) > -1 ? 3 : (stack.func_77973_b() instanceof ItemAxe || stack.func_77973_b().getHarvestLevel(stack, "axe", null, null) > -1 ? 3 : (stack.func_77973_b() instanceof ItemHoe ? 2 : (stack.func_77973_b() instanceof ItemSpade ? 1 : 1)));
        }
        if (baseCount > 0) {
            return (int)((float)baseCount * (1.0f - (float)stack.func_77952_i() / (float)stack.func_77958_k()));
        }
        return -1;
    }

    public static boolean isHills(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS);
    }

    public static boolean isExtremeHills(Biome biome) {
        return biome.func_185359_l().compareTo(Biomes.field_76770_e.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_76783_v.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_150580_W.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_185443_S.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_185434_af.func_185359_l()) == 0;
    }

    public static void spawnInventoryInWorld(World world, double x, double y, double z, IItemHandler inventory) {
        if (inventory != null && !world.field_72995_K) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i).func_190926_b()) continue;
                world.func_72838_d((Entity)new EntityItem(world, x, y, z, inventory.getStackInSlot(i)));
            }
        }
    }

    public static ItemStack getStackFromState(IBlockState state) {
        if (state == null) {
            return ItemStack.field_190927_a;
        }
        Block block = state.func_177230_c();
        int meta = block.func_180651_a(state);
        return new ItemStack(block, 1, meta);
    }

    public static void syncTE(TileEntity tile) {
        int j;
        int i;
        PlayerChunkMap chunkMap;
        PlayerChunkMapEntry entry;
        SPacketUpdateTileEntity packet;
        World world = tile.func_145831_w();
        if (world instanceof WorldServer && (packet = tile.func_189518_D_()) != null && (entry = (chunkMap = ((WorldServer)world).func_184164_w()).func_187301_b(i = tile.func_174877_v().func_177958_n() >> 4, j = tile.func_174877_v().func_177952_p() >> 4)) != null) {
            entry.func_187267_a((Packet)packet);
        }
    }

    @Nullable
    public static RayTraceResult findEntityOnPath(World world, @Nullable Entity projectile, Entity shooter, AxisAlignedBB projectileAABB, Vec3d start, Vec3d end, Predicate<Entity> matcher) {
        RayTraceResult pickedEntity = null;
        double motionX = end.field_72450_a - start.field_72450_a;
        double motionY = end.field_72448_b - start.field_72448_b;
        double motionZ = end.field_72449_c - start.field_72449_c;
        List list = world.func_175674_a(projectile, projectileAABB.func_72321_a(motionX, motionY, motionZ).func_186662_g(1.0), matcher);
        double pickedDistance = 0.0;
        for (Entity entity : list) {
            double distance;
            AxisAlignedBB aabb;
            RayTraceResult raytraceresult;
            if (entity == shooter || (raytraceresult = (aabb = entity.func_174813_aQ().func_186662_g(0.3)).func_72327_a(start, end)) == null || !((distance = start.func_72436_e(raytraceresult.field_72307_f)) < pickedDistance) && pickedDistance != 0.0) continue;
            raytraceresult.field_72313_a = RayTraceResult.Type.ENTITY;
            raytraceresult.field_72308_g = entity;
            pickedEntity = raytraceresult;
            pickedDistance = distance;
        }
        return pickedEntity;
    }

    @Nullable
    public static List<RayTraceResult> findEntitiesOnPath(World world, @Nullable Entity projectile, Entity shooter, AxisAlignedBB projectileAABB, Vec3d start, Vec3d end, Predicate<Entity> matcher) {
        ArrayList<RayTraceResult> entities = new ArrayList<RayTraceResult>();
        double motionX = end.field_72450_a - start.field_72450_a;
        double motionY = end.field_72448_b - start.field_72448_b;
        double motionZ = end.field_72449_c - start.field_72449_c;
        List list = world.func_175674_a(projectile, projectileAABB.func_72321_a(motionX, motionY, motionZ).func_186662_g(1.0), matcher);
        for (Entity entity : list) {
            AxisAlignedBB aabb;
            RayTraceResult raytraceresult;
            if (entity == shooter || (raytraceresult = (aabb = entity.func_174813_aQ().func_186662_g(0.3)).func_72327_a(start, end)) == null) continue;
            raytraceresult.field_72313_a = RayTraceResult.Type.ENTITY;
            raytraceresult.field_72308_g = entity;
            entities.add(raytraceresult);
        }
        entities.sort((o1, o2) -> Double.compare(start.func_72436_e(o1.field_72307_f), start.func_72436_e(o2.field_72307_f)));
        return entities;
    }

    public static double getDiminishedPower(double power, double softcap, double slope) {
        if (power > softcap) {
            return softcap * slope + Math.log10(power - softcap + LOG_E / slope) - Math.log10(LOG_E / slope);
        }
        return power * slope;
    }

    public static void spawnClogParticles(World world, BlockPos pos, int spouts, float radius) {
        Random localRandom = new Random(pos.hashCode());
        for (int i = 0; i < spouts; ++i) {
            double angleA = localRandom.nextDouble() * Math.PI * 2.0;
            double angleB = localRandom.nextDouble() * Math.PI * 2.0;
            float xOffset = (float)(Math.cos(angleA) * Math.cos(angleB));
            float yOffset = (float)(Math.sin(angleA) * Math.cos(angleB));
            float zOffset = (float)Math.sin(angleB);
            float speed = 0.01875f;
            float vx = xOffset * speed + random.nextFloat() * speed * 0.3f;
            float vy = yOffset * speed + random.nextFloat() * speed * 0.3f;
            float vz = zOffset * speed + random.nextFloat() * speed * 0.3f;
            ParticleUtil.spawnParticleVapor(world, (float)pos.func_177958_n() + 0.5f + xOffset * radius, (float)pos.func_177956_o() + 0.5f + yOffset * radius, (float)pos.func_177952_p() + 0.5f + zOffset * radius, vx, vy, vz, 64.0f, 64.0f, 64.0f, 1.0f, 0.2f, 3.0f, 40);
        }
    }

    public static IItemHandler makeBlockedItemHandler(final IItemHandler handler, final BooleanSupplier canInput, final BooleanSupplier canOutput) {
        return new IItemHandler(){

            public int getSlots() {
                return handler.getSlots();
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!canInput.getAsBoolean()) {
                    return stack;
                }
                return handler.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (!canOutput.getAsBoolean()) {
                    return ItemStack.field_190927_a;
                }
                return handler.extractItem(slot, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }
        };
    }

    public static IItemHandler makeRestrictedItemHandler(final IItemHandler handler, final boolean input, final boolean output) {
        return new IItemHandler(){

            public int getSlots() {
                return handler.getSlots();
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!input) {
                    return stack;
                }
                return handler.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (!output) {
                    return ItemStack.field_190927_a;
                }
                return handler.extractItem(slot, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(slot);
            }
        };
    }

    public static IFluidHandler makeRestrictedFluidHandler(final IFluidHandler handler, final boolean input, final boolean output) {
        return new IFluidHandler(){

            public IFluidTankProperties[] getTankProperties() {
                return handler.getTankProperties();
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (!input) {
                    return 0;
                }
                return handler.fill(resource, doFill);
            }

            @Nullable
            public FluidStack drain(FluidStack resource, boolean doDrain) {
                if (!output) {
                    return null;
                }
                return handler.drain(resource, doDrain);
            }

            @Nullable
            public FluidStack drain(int maxDrain, boolean doDrain) {
                if (!output) {
                    return null;
                }
                return handler.drain(maxDrain, doDrain);
            }
        };
    }

    public static RayTraceResult raytraceMultiAABB(List<AxisAlignedBB> aabbs, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        list.addAll(aabbs.stream().map(axisalignedbb -> Misc.rayTrace2(pos, start, end, axisalignedbb)).collect(Collectors.toList()));
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    private static RayTraceResult rayTrace2(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB boundingBox) {
        Vec3d vec3d1;
        Vec3d vec3d = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        RayTraceResult raytraceresult = boundingBox.func_72327_a(vec3d, vec3d1 = end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
        return raytraceresult == null ? null : new RayTraceResult(raytraceresult.field_72307_f.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), raytraceresult.field_178784_b, pos);
    }

    public static EnumFacing readNullableFacing(int index) {
        return index > 0 ? EnumFacing.func_82600_a((int)index) : null;
    }

    public static int writeNullableFacing(EnumFacing facing) {
        return facing != null ? facing.func_176745_a() : -1;
    }

    public static boolean isGaseousFluid(FluidStack resource) {
        return resource != null && !resource.getFluid().getName().startsWith("aetherworks.") && resource.getFluid().getDensity() <= 0;
    }
}

