/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.tile.IMechanicallyPowered;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.block.BlockFluidGauge;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityMixerTop;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityMixerBottom
extends TileEntity
implements ITileEntityBase,
ITickable,
IMechanicallyPowered,
ISoundController,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static final double EMBER_COST = 2.0;
    public FluidTank north = new FluidTank(8000);
    public FluidTank south = new FluidTank(8000);
    public FluidTank east = new FluidTank(8000);
    public FluidTank west = new FluidTank(8000);
    public FluidTank[] tanks;
    Random random = new Random();
    int progress = -1;
    boolean isWorking;
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public TileEntityMixerBottom() {
        this.tanks = new FluidTank[]{this.north, this.south, this.east, this.west};
    }

    public FluidTank[] getTanks() {
        return this.tanks;
    }

    public ArrayList<FluidStack> getFluids() {
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        if (this.north.getFluid() != null) {
            fluids.add(this.north.getFluid());
        }
        if (this.south.getFluid() != null) {
            fluids.add(this.south.getFluid());
        }
        if (this.east.getFluid() != null) {
            fluids.add(this.east.getFluid());
        }
        if (this.west.getFluid() != null) {
            fluids.add(this.west.getFluid());
        }
        return fluids;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound northTank = new NBTTagCompound();
        this.north.writeToNBT(northTank);
        tag.func_74782_a("northTank", (NBTBase)northTank);
        NBTTagCompound southTank = new NBTTagCompound();
        this.south.writeToNBT(southTank);
        tag.func_74782_a("southTank", (NBTBase)southTank);
        NBTTagCompound eastTank = new NBTTagCompound();
        this.east.writeToNBT(eastTank);
        tag.func_74782_a("eastTank", (NBTBase)eastTank);
        NBTTagCompound westTank = new NBTTagCompound();
        this.west.writeToNBT(westTank);
        tag.func_74782_a("westTank", (NBTBase)westTank);
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.north.readFromNBT(tag.func_74775_l("northTank"));
        this.south.readFromNBT(tag.func_74775_l("southTank"));
        this.east.readFromNBT(tag.func_74775_l("eastTank"));
        this.west.readFromNBT(tag.func_74775_l("westTank"));
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != EnumFacing.UP && facing != EnumFacing.DOWN && facing != null) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            switch (facing) {
                case DOWN: {
                    break;
                }
                case EAST: {
                    return (T)this.east;
                }
                case NORTH: {
                    return (T)this.north;
                }
                case SOUTH: {
                    return (T)this.south;
                }
                case UP: {
                    break;
                }
                case WEST: {
                    return (T)this.west;
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.handleSound();
        }
        World world = this.func_145831_w();
        BlockPos pos = this.func_174877_v();
        TileEntityMixerTop top = (TileEntityMixerTop)world.func_175625_s(pos.func_177984_a());
        this.isWorking = false;
        if (top != null) {
            boolean cancel;
            ArrayList<FluidStack> fluids;
            FluidMixingRecipe recipe;
            List<IUpgradeProvider> upgrades = UpgradeUtil.getUpgrades(world, pos.func_177984_a(), EnumFacing.field_82609_l);
            UpgradeUtil.verifyUpgrades(this, upgrades);
            if (UpgradeUtil.doTick(this, upgrades)) {
                return;
            }
            double emberCost = UpgradeUtil.getTotalEmberConsumption(this, 2.0, upgrades);
            if (top.capability.getEmber() >= emberCost && (recipe = RecipeRegistry.getMixingRecipe(fluids = this.getFluids())) != null && !(cancel = UpgradeUtil.doWork(this, upgrades))) {
                IFluidHandler tank = (IFluidHandler)top.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                FluidStack output = recipe.getResult(fluids);
                int amount = tank.fill(output = UpgradeUtil.transformOutput((TileEntity)this, output, upgrades), false);
                if (amount != 0) {
                    this.isWorking = true;
                    tank.fill(output, true);
                    this.consumeFluids(recipe);
                    UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), upgrades);
                    top.capability.removeAmount(emberCost, true);
                    this.func_70296_d();
                    top.func_70296_d();
                }
            }
        }
    }

    public void consumeFluids(FluidMixingRecipe recipe) {
        for (int j = 0; j < recipe.inputs.size(); ++j) {
            FluidStack recipeFluid = recipe.inputs.get(j).copy();
            for (FluidTank tank : this.tanks) {
                FluidStack tankFluid = tank.getFluid();
                if (recipeFluid == null || tankFluid == null || recipeFluid.getFluid() != tankFluid.getFluid()) continue;
                FluidStack stack = tank.drain(recipeFluid.amount, true);
                recipeFluid.amount = recipeFluid.amount - (stack != null ? stack.amount : 0);
            }
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.MIXER_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 1.0f, (float)this.field_174879_c.func_177952_p() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.isWorking;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        if ("fluid".equals(dialType)) {
            information.clear();
            information.add(TextFormatting.BOLD.toString() + I18n.func_135052_a((String)"embers.tooltip.side.north", (Object[])new Object[0]) + TextFormatting.RESET.toString() + " " + BlockFluidGauge.formatFluidStack(this.north.getFluid(), this.north.getCapacity()));
            information.add(TextFormatting.BOLD.toString() + I18n.func_135052_a((String)"embers.tooltip.side.east", (Object[])new Object[0]) + TextFormatting.RESET.toString() + " " + BlockFluidGauge.formatFluidStack(this.east.getFluid(), this.east.getCapacity()));
            information.add(TextFormatting.BOLD.toString() + I18n.func_135052_a((String)"embers.tooltip.side.south", (Object[])new Object[0]) + TextFormatting.RESET.toString() + " " + BlockFluidGauge.formatFluidStack(this.south.getFluid(), this.south.getCapacity()));
            information.add(TextFormatting.BOLD.toString() + I18n.func_135052_a((String)"embers.tooltip.side.west", (Object[])new Object[0]) + TextFormatting.RESET.toString() + " " + BlockFluidGauge.formatFluidStack(this.west.getFluid(), this.south.getCapacity()));
        }
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", I18n.func_135052_a((String)"embers.tooltip.goggles.fluid.metal", (Object[])new Object[0])));
    }

    @Override
    public double getMinimumPower() {
        return 20.0;
    }

    @Override
    public double getMechanicalSpeed(double power) {
        return Misc.getDiminishedPower(power, 80.0, 0.01875);
    }

    @Override
    public double getNominalSpeed() {
        return 1.0;
    }

    @Override
    public double getStandardPowerRatio() {
        return 0.5;
    }
}

