/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.event.DialInformationEvent;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.tile.IMechanicallyPowered;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.recipe.BoreOutput;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.EmberGenUtil;
import teamroots.embers.util.Misc;
import teamroots.embers.util.WeightedItemStack;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityEmberBore
extends TileEntity
implements ITileEntityBase,
ITickable,
IMultiblockMachine,
ISoundController,
IMechanicallyPowered,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static final int MAX_LEVEL = 7;
    public static final int BORE_TIME = 200;
    public static final int SLOT_FUEL = 8;
    public static final double FUEL_CONSUMPTION = 3.0;
    public static final int SOUND_ON = 1;
    public static final int SOUND_ON_DRILL = 2;
    public static final int[] SOUND_IDS = new int[]{1, 2};
    Random random = new Random();
    public long ticksExisted = 0L;
    public float angle = 0.0f;
    public double ticksFueled = 0.0;
    public float lastAngle;
    boolean isRunning;
    HashSet<Integer> soundsPlaying = new HashSet();
    private List<IUpgradeProvider> upgrades = new ArrayList<IUpgradeProvider>();
    private double speedMod;
    public ItemStackHandler inventory = new EmberBoreInventory(9);

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, -2, -1), this.field_174879_c.func_177982_a(2, 1, 2));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74780_a("fueled", this.ticksFueled);
        tag.func_74757_a("isRunning", this.isRunning);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound inventoryTag = tag.func_74775_l("inventory");
        inventoryTag.func_82580_o("Size");
        this.inventory.deserializeNBT(inventoryTag);
        this.ticksFueled = tag.func_74769_h("fueled");
        this.isRunning = tag.func_74767_n("isRunning");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175698_g(pos.func_177982_a(1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, -1));
        world.func_175698_g(pos.func_177982_a(1, 0, -1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 1));
        world.func_175698_g(pos.func_177982_a(1, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, -1));
        world.func_175690_a(pos, null);
    }

    public EmberBoreInventory getInventory() {
        return (EmberBoreInventory)this.inventory;
    }

    public boolean canMine() {
        return this.func_174877_v().func_177956_o() <= 7;
    }

    public boolean canInsert(ArrayList<ItemStack> returns) {
        Iterator<ItemStack> iterator = returns.iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            ItemStack returned = stack = iterator.next();
            for (int slot = 0; slot < this.getInventory().getSlots() - 1; ++slot) {
                returned = this.getInventory().insertItemInternal(slot, returned, true);
            }
            if (returned.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void insert(ArrayList<ItemStack> returns) {
        Iterator<ItemStack> iterator = returns.iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            ItemStack returned = stack = iterator.next();
            for (int slot = 0; slot < this.getInventory().getSlots() - 1; ++slot) {
                returned = this.getInventory().insertItemInternal(slot, returned, false);
            }
        }
    }

    public void func_73660_a() {
        this.upgrades = UpgradeUtil.getUpgradesForMultiblock(this.field_145850_b, this.field_174879_c, new EnumFacing[]{EnumFacing.UP});
        UpgradeUtil.verifyUpgrades(this, this.upgrades);
        if (UpgradeUtil.doTick(this, this.upgrades)) {
            return;
        }
        if (this.func_145831_w().field_72995_K) {
            this.handleSound();
        }
        this.speedMod = UpgradeUtil.getTotalSpeedModifier(this, this.upgrades);
        this.lastAngle = this.angle;
        if (this.isRunning) {
            this.angle = (float)((double)this.angle + 12.0 * this.speedMod);
        }
        boolean previousRunning = this.isRunning;
        if (!this.func_145831_w().field_72995_K) {
            this.isRunning = false;
            ++this.ticksExisted;
            double fuelConsumption = UpgradeUtil.getOtherParameter((TileEntity)this, "fuel_consumption", 3.0, this.upgrades);
            boolean cancel = false;
            if (this.ticksFueled >= fuelConsumption) {
                this.isRunning = true;
                this.ticksFueled -= fuelConsumption;
                cancel = UpgradeUtil.doWork(this, this.upgrades);
            }
            if (!cancel) {
                BoreOutput output;
                int boreTime;
                if (this.ticksFueled < fuelConsumption) {
                    ItemStack fuelCopy;
                    int burnTime;
                    ItemStack fuel = this.inventory.getStackInSlot(8);
                    if (!fuel.func_190926_b() && (burnTime = TileEntityFurnace.func_145952_a((ItemStack)(fuelCopy = fuel.func_77946_l()))) > 0) {
                        this.ticksFueled = burnTime;
                        fuel.func_190918_g(1);
                        if (fuel.func_190926_b()) {
                            this.inventory.setStackInSlot(8, fuelCopy.func_77973_b().getContainerItem(fuelCopy));
                        }
                        this.func_70296_d();
                    }
                } else if (this.canMine() && this.ticksExisted % (long)(boreTime = (int)Math.ceil(200.0 * (1.0 / this.speedMod))) == 0L && this.random.nextFloat() < EmberGenUtil.getEmberDensity(this.field_145850_b.func_72905_C(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177952_p()) && (output = RecipeRegistry.getBoreOutput(this.field_145850_b, this.func_174877_v())) != null) {
                    ArrayList<ItemStack> returns = new ArrayList<ItemStack>();
                    if (!output.stacks.isEmpty()) {
                        WeightedItemStack picked = (WeightedItemStack)WeightedRandom.func_76271_a((Random)this.random, output.stacks);
                        returns.add(picked.getStack().func_77946_l());
                    }
                    UpgradeUtil.transformOutput((TileEntity)this, returns, this.upgrades);
                    if (this.canInsert(returns)) {
                        this.insert(returns);
                    }
                }
            } else {
                this.isRunning = false;
            }
            if (this.isRunning != previousRunning) {
                this.func_70296_d();
            }
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void playSound(int id) {
        float soundX = (float)this.field_174879_c.func_177958_n() + 0.5f;
        float soundY = (float)this.field_174879_c.func_177956_o() - 0.5f;
        float soundZ = (float)this.field_174879_c.func_177952_p() + 0.5f;
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.BORE_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
                break;
            }
            case 2: {
                Embers.proxy.playMachineSound(this, 2, SoundManager.BORE_LOOP_MINE, SoundCategory.BLOCKS, true, 1.0f, 1.0f, soundX, soundY, soundZ);
            }
        }
        this.field_145850_b.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundManager.BORE_START, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.field_145850_b.func_184134_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() - 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SoundManager.BORE_STOP, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return this.isRunning;
    }

    @Override
    public float getCurrentVolume(int id, float volume) {
        boolean isMining = this.canMine();
        switch (id) {
            case 1: {
                return !isMining ? 1.0f : 0.0f;
            }
            case 2: {
                return isMining ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public float getCurrentPitch(int id, float pitch) {
        return (float)this.speedMod;
    }

    @Override
    public double getMechanicalSpeed(double power) {
        return power > 0.0 ? Math.log10(power / 15.0) * 3.0 : 0.0;
    }

    @Override
    public double getMinimumPower() {
        return 15.0;
    }

    @Override
    public double getNominalSpeed() {
        return 1.0;
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        UpgradeUtil.throwEvent(this, new DialInformationEvent(this, information, dialType), this.upgrades);
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return true;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", I18n.func_135052_a((String)"embers.tooltip.goggles.item.fuel", (Object[])new Object[0])));
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.OUTPUT, "embers.tooltip.goggles.item", I18n.func_135052_a((String)"embers.tooltip.goggles.item.ember", (Object[])new Object[0])));
        }
    }

    public class EmberBoreInventory
    extends ItemStackHandler {
        public EmberBoreInventory() {
        }

        public EmberBoreInventory(int size) {
            super(size);
        }

        public EmberBoreInventory(NonNullList<ItemStack> stacks) {
            super(stacks);
        }

        protected void onContentsChanged(int slot) {
            TileEntityEmberBore.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            int burntime = TileEntityFurnace.func_145952_a((ItemStack)stack);
            if (slot == 8 && burntime != 0) {
                return super.insertItem(slot, stack, simulate);
            }
            if (burntime != 0) {
                return super.insertItem(8, stack, simulate);
            }
            return stack;
        }

        public ItemStack insertItemInternal(int slot, ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack currentFuel = super.extractItem(slot, amount, true);
            int burntime = TileEntityFurnace.func_145952_a((ItemStack)currentFuel);
            if (slot == 8 && burntime != 0) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

