/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.research;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.gui.GuiCodex;
import teamroots.embers.util.Vec2i;

public class ResearchBase {
    public String name = "";
    public double u = 0.75;
    public double v = 0.0;
    public ItemStack icon = ItemStack.field_190927_a;
    public int x = 0;
    public int y = 0;
    public List<ResearchBase> ancestors = new ArrayList<ResearchBase>();
    public ResourceLocation iconBackground = new ResourceLocation("embers:textures/gui/codex_category.png");
    public ResourceLocation background = new ResourceLocation("embers:textures/gui/codex_normal.png");
    public ResearchBase firstPage;
    public int pageNumber;
    List<ResearchBase> pages = new ArrayList<ResearchBase>();
    public float selectedAmount = 0.0f;
    public float selectionTarget = 0.0f;

    public ResearchBase(String location, ItemStack icon, double x, double y) {
        this.name = location;
        this.icon = icon;
        this.x = 48 + (int)(x * 24.0);
        this.y = 48 + (int)(y * 24.0);
    }

    public ResearchBase(String location, ItemStack icon, Vec2i pos) {
        this(location, icon, pos.x, pos.y);
    }

    public ResearchBase addAncestor(ResearchBase base) {
        this.ancestors.add(base);
        return this;
    }

    public ResearchBase setIconBackground(ResourceLocation resourceLocation, double u, double v) {
        this.iconBackground = resourceLocation;
        this.u = u;
        this.v = v;
        return this;
    }

    public ResearchBase setBackground(ResourceLocation resourceLocation) {
        this.background = resourceLocation;
        return this;
    }

    public ResearchBase addPage(ResearchBase page) {
        if (this.firstPage != null) {
            return this.firstPage.addPage(page);
        }
        this.pages.add(page);
        page.pageNumber = this.getPageCount();
        page.firstPage = this.getFirstPage();
        return this;
    }

    public boolean isHidden() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)("embers.research.page." + this.name), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getTitle() {
        if (this.hasMultiplePages()) {
            return I18n.func_135052_a((String)"embers.research.multipage", (Object[])new Object[]{I18n.func_135052_a((String)("embers.research.page." + this.getFirstPage().name + ".title"), (Object[])new Object[0]), this.pageNumber + 1, this.getPageCount() + 1});
        }
        return I18n.func_135052_a((String)("embers.research.page." + this.name + ".title"), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public String getText() {
        return I18n.func_135052_a((String)("embers.research.page." + this.name + ".desc"), (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getLines(FontRenderer fontRenderer, String s, int width) {
        return Lists.newArrayList((Iterable)fontRenderer.func_78271_c(s, width));
    }

    public ResourceLocation getBackground() {
        return this.background;
    }

    public ResourceLocation getIconBackground() {
        return this.iconBackground;
    }

    public double getIconBackgroundU() {
        return this.u;
    }

    public double getIconBackgroundV() {
        return this.v;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public boolean hasMultiplePages() {
        return this.getPageCount() > 0;
    }

    public ResearchBase getPage(int i) {
        if ((i = MathHelper.func_76125_a((int)i, (int)0, (int)this.getPageCount())) <= 0) {
            return this.getFirstPage();
        }
        return this.getPages().get(i - 1);
    }

    public ResearchBase getFirstPage() {
        if (this.firstPage != null) {
            return this.firstPage;
        }
        return this;
    }

    public ResearchBase getNextPage() {
        return this.getPage(this.pageNumber + 1);
    }

    public ResearchBase getPreviousPage() {
        return this.getPage(this.pageNumber - 1);
    }

    public int getPageCount() {
        return this.getPages().size();
    }

    public List<ResearchBase> getPages() {
        if (this.firstPage != null) {
            return this.firstPage.pages;
        }
        return this.pages;
    }

    public boolean onOpen(GuiCodex gui) {
        return true;
    }

    public boolean onClose(GuiCodex gui) {
        return true;
    }

    public void renderPageContent(GuiCodex gui, int basePosX, int basePosY, FontRenderer fontRenderer) {
        List<String> strings = this.getLines(fontRenderer, this.getText(), 152);
        for (int i = 0; i < Math.min(strings.size(), 17); ++i) {
            GuiCodex.drawTextGlowing(fontRenderer, strings.get(i), basePosX + 20, basePosY + 43 + i * (fontRenderer.field_78288_b + 3));
        }
    }
}

