/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import java.util.Objects;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.api.item.IInflictorGem;
import teamroots.embers.api.item.IInflictorGemHolder;
import teamroots.embers.api.item.IInfoGoggles;
import teamroots.embers.item.ItemArmorBase;
import teamroots.embers.model.ModelAshenCloak;

public class ItemAshenCloak
extends ItemArmorBase
implements IInflictorGemHolder,
IInfoGoggles {
    public ItemAshenCloak(ItemArmor.ArmorMaterial material, int reduction, EntityEquipmentSlot slot) {
        super(material, reduction, slot, "ashen_cloak", true);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "embers:textures/models/armor/robe.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase living, ItemStack stack, EntityEquipmentSlot slot, ModelBiped _default) {
        return new ModelAshenCloak(slot);
    }

    @Override
    public int getGemSlots(ItemStack holder) {
        return 7;
    }

    @Override
    public boolean canAttachGem(ItemStack holder, ItemStack gem) {
        return gem.func_77973_b() instanceof IInflictorGem;
    }

    @Override
    public void attachGem(ItemStack holder, ItemStack gem, int slot) {
        if (!holder.func_77942_o()) {
            holder.func_77982_d(new NBTTagCompound());
        }
        holder.func_77978_p().func_74782_a("gem" + slot, (NBTBase)gem.func_77955_b(new NBTTagCompound()));
    }

    @Override
    public ItemStack detachGem(ItemStack holder, int slot) {
        if (holder.func_77942_o() && holder.func_77978_p().func_74764_b("gem" + slot)) {
            ItemStack gem = new ItemStack(holder.func_77978_p().func_74775_l("gem" + slot));
            holder.func_77978_p().func_82580_o("gem" + slot);
            return gem;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void clearGems(ItemStack holder) {
        NBTTagCompound tagCompound = holder.func_77978_p();
        if (tagCompound == null) {
            return;
        }
        for (int i = 1; i <= this.getGemSlots(holder); ++i) {
            if (!tagCompound.func_74764_b("gem" + i)) continue;
            tagCompound.func_82580_o("gem" + i);
        }
    }

    @Override
    public ItemStack[] getAttachedGems(ItemStack holder) {
        ItemStack[] stacks = new ItemStack[this.getGemSlots(holder)];
        for (int i = 1; i <= stacks.length; ++i) {
            stacks[i - 1] = holder.func_77942_o() ? new ItemStack(holder.func_77978_p().func_74775_l("gem" + i)) : ItemStack.field_190927_a;
        }
        return stacks;
    }

    @Override
    public float getTotalDamageResistance(EntityLivingBase entity, DamageSource source, ItemStack holder) {
        float reduction = 0.0f;
        if (entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemAshenCloak && entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemAshenCloak && entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemAshenCloak && entity.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemAshenCloak) {
            for (ItemStack stack : this.getAttachedGems(holder)) {
                Item item = stack.func_77973_b();
                if (!(item instanceof IInflictorGem) || !Objects.equals(((IInflictorGem)item).getAttunedSource(stack), source.func_76355_l())) continue;
                reduction += ((IInflictorGem)item).getDamageResistance(stack, reduction);
            }
        }
        return reduction;
    }

    @Override
    public boolean shouldDisplayInfo(EntityPlayer player, ItemStack stack, EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.HEAD;
    }
}

