/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.api.projectile.IProjectileEffect;
import teamroots.embers.api.projectile.IProjectilePreset;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberSizedBurstFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.util.Misc;

public class EntityEmberProjectile
extends Entity {
    private static final Predicate<Entity> VALID_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity.func_70067_L();
        }
    }});
    public static final DataParameter<Float> value = EntityDataManager.func_187226_a(EntityEmberProjectile.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> dead = EntityDataManager.func_187226_a(EntityEmberProjectile.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> lifetime = EntityDataManager.func_187226_a(EntityEmberProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> color = EntityDataManager.func_187226_a(EntityEmberProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    public Entity shootingEntity;
    public IProjectileEffect effect;
    private IProjectilePreset preset;
    double gravity;
    int homingTime;
    double homingRange;
    int homingIndex;
    int homingModulo;
    Entity homingTarget;
    Predicate<Entity> homingPredicate;

    public EntityEmberProjectile(World worldIn) {
        super(worldIn);
        this.func_82142_c(true);
        this.func_184212_Q().func_187214_a(value, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(dead, (Object)false);
        this.func_184212_Q().func_187214_a(lifetime, (Object)160);
        this.func_184212_Q().func_187214_a(color, (Object)new Color(255, 64, 16).getRGB());
    }

    public void initCustom(double x, double y, double z, double vx, double vy, double vz, double value, Entity shootingEntity) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.field_70159_w = vx;
        this.field_70181_x = vy;
        this.field_70179_y = vz;
        this.func_70105_a((float)value / 10.0f, (float)value / 10.0f);
        this.func_184212_Q().func_187227_b(EntityEmberProjectile.value, (Object)Float.valueOf((float)value));
        this.func_184212_Q().func_187217_b(EntityEmberProjectile.value);
        this.func_70105_a((float)value / 10.0f, (float)value / 10.0f);
        this.shootingEntity = shootingEntity;
    }

    public void setGravity(double gravity) {
        this.gravity = gravity;
    }

    public void setColor(int red, int green, int blue, int alpha) {
        this.func_184212_Q().func_187227_b(color, (Object)new Color(red * alpha / 255, green * alpha / 255, blue * alpha / 255).getRGB());
        this.func_184212_Q().func_187217_b(color);
    }

    public void setHoming(int time, double range, int index, int modulo, Predicate<Entity> predicate) {
        this.homingTime = time;
        this.homingRange = range;
        this.homingIndex = index;
        this.homingModulo = modulo;
        this.homingPredicate = predicate;
    }

    public void setPreset(IProjectilePreset preset) {
        this.preset = preset;
    }

    public void setEffect(IProjectileEffect effect) {
        this.effect = effect;
    }

    public void setLifetime(int lifetime) {
        this.func_184212_Q().func_187227_b(EntityEmberProjectile.lifetime, (Object)lifetime);
    }

    public Entity getShooter() {
        return this.shootingEntity;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.func_184212_Q().func_187227_b(value, (Object)Float.valueOf(compound.func_74760_g("value")));
        this.func_184212_Q().func_187217_b(value);
        this.func_184212_Q().func_187227_b(color, (Object)compound.func_74762_e("color"));
        this.func_184212_Q().func_187217_b(color);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("value", ((Float)this.func_184212_Q().func_187225_a(value)).floatValue());
        compound.func_74768_a("color", ((Integer)this.func_184212_Q().func_187225_a(color)).intValue());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int lifetime = (Integer)this.func_184212_Q().func_187225_a(EntityEmberProjectile.lifetime);
        this.func_184212_Q().func_187227_b(EntityEmberProjectile.lifetime, (Object)(lifetime - 1));
        this.func_184212_Q().func_187217_b(EntityEmberProjectile.lifetime);
        World world = this.func_130014_f_();
        if (lifetime <= 0) {
            world.func_72900_e((Entity)this);
            this.func_70106_y();
        }
        if (!((Boolean)this.func_184212_Q().func_187225_a(dead)).booleanValue()) {
            RayTraceResult hitEntity;
            Vec3d newPosVector;
            Vec3d currPosVec;
            RayTraceResult raytraceresult;
            this.func_184212_Q().func_187227_b(value, (Object)Float.valueOf(((Float)this.func_184212_Q().func_187225_a(value)).floatValue() - 0.025f));
            if (((Float)this.func_184212_Q().func_187225_a(value)).floatValue() <= 0.0f) {
                world.func_72900_e((Entity)this);
            }
            if ((raytraceresult = this.field_70170_p.func_147447_a(currPosVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), newPosVector = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y), false, true, false)) != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS) {
                newPosVector = raytraceresult.field_72307_f;
            }
            if ((hitEntity = Misc.findEntityOnPath(world, this, this.shootingEntity, this.func_174813_aQ(), currPosVec, newPosVector, VALID_TARGETS)) != null) {
                newPosVector = hitEntity.field_72307_f;
                raytraceresult = hitEntity;
            }
            this.field_70165_t = newPosVector.field_72450_a;
            this.field_70163_u = newPosVector.field_72448_b;
            this.field_70161_v = newPosVector.field_72449_c;
            this.field_70181_x += this.gravity;
            if (!world.field_72995_K && raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onHit(raytraceresult);
            }
            this.handleHoming(lifetime, world);
            if (world.field_72995_K) {
                Color particleColor = new Color((Integer)this.func_184212_Q().func_187225_a(color), true);
                double deltaX = this.field_70165_t - this.field_70169_q;
                double deltaY = this.field_70163_u - this.field_70167_r;
                double deltaZ = this.field_70161_v - this.field_70166_s;
                double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 10.0);
                for (double i = 0.0; i < dist; i += 1.0) {
                    double coeff = i / dist;
                    ParticleUtil.spawnParticleGlow(world, (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * coeff), (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * coeff), (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * coeff), 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f), particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), ((Float)this.func_184212_Q().func_187225_a(value)).floatValue() / 1.75f, 24);
                }
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
    }

    private void handleHoming(int lifetime, World world) {
        if (this.homingTime > 0) {
            if (!this.isTargetInvalid(this.homingTarget)) {
                double targetX = this.homingTarget.field_70165_t;
                double targetY = this.homingTarget.field_70163_u + (double)(this.homingTarget.field_70131_O / 2.0f);
                double targetZ = this.homingTarget.field_70161_v;
                Vec3d targetVector = new Vec3d(targetX - this.field_70165_t, targetY - this.field_70163_u, targetZ - this.field_70161_v);
                double length = targetVector.func_72433_c();
                targetVector = targetVector.func_186678_a(0.3 / length);
                double weight = 0.0;
                if (length <= this.homingRange) {
                    weight = 0.9 * ((this.homingRange - length) / this.homingRange);
                }
                this.field_70159_w = (0.9 - weight) * this.field_70159_w + (0.1 + weight) * targetVector.field_72450_a;
                this.field_70181_x = (0.9 - weight) * this.field_70181_x + (0.1 + weight) * targetVector.field_72448_b;
                this.field_70179_y = (0.9 - weight) * this.field_70179_y + (0.1 + weight) * targetVector.field_72449_c;
                --this.homingTime;
            } else if (lifetime % 5 == 0) {
                AxisAlignedBB homingAABB = new AxisAlignedBB(this.field_70165_t - this.homingRange, this.field_70163_u - this.homingRange, this.field_70161_v - this.homingRange, this.field_70165_t + this.homingRange, this.field_70163_u + this.homingRange, this.field_70161_v + this.homingRange);
                List entities = world.func_175674_a((Entity)this, homingAABB, this.homingPredicate);
                Entity badTarget = null;
                for (Entity entity : entities) {
                    long leastSignificantBits = entity.func_110124_au().getLeastSignificantBits() & 0xFFFFL;
                    if (leastSignificantBits % (long)this.homingModulo == (long)(this.homingIndex % this.homingModulo)) {
                        this.homingTarget = entity;
                    }
                    badTarget = entity;
                }
                if (this.homingTarget == null) {
                    this.homingTarget = badTarget;
                }
            }
        }
    }

    private boolean isTargetInvalid(Entity entity) {
        return entity == null || entity.field_70128_L;
    }

    private void onHit(RayTraceResult raytraceresult) {
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberSizedBurstFX(this.field_70165_t, this.field_70163_u, this.field_70161_v, ((Float)this.func_184212_Q().func_187225_a(value)).floatValue() / 1.75f, (Integer)this.func_184212_Q().func_187225_a(color)));
        this.func_184212_Q().func_187227_b(lifetime, (Object)20);
        this.func_184212_Q().func_187217_b(lifetime);
        this.func_184212_Q().func_187227_b(dead, (Object)true);
        this.func_184212_Q().func_187217_b(dead);
        double aoeRadius = (double)((Float)this.func_184212_Q().func_187225_a(value)).floatValue() * 0.125;
        if (this.effect != null) {
            this.effect.onHit(this.field_70170_p, raytraceresult, this.preset);
        }
    }
}

