/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.misc.IMetalCoefficient;
import teamroots.embers.compat.crafttweaker.CTUtil;
import teamroots.embers.util.Misc;

@ZenRegister
@ZenClass(value="mods.embers.EmberGeneration")
public class EmberGeneration {
    public static final String NAME = "EmberGeneration";
    public static final String CLASS = "mods.embers.EmberGeneration";

    @ZenMethod
    public static void addEmberFuel(IIngredient item, double ember) {
        CraftTweakerAPI.apply((IAction)new AddEmberFuel(item, ember));
    }

    @ZenMethod
    public static void addCatalysisFuel(IIngredient item, double coefficient) {
        CraftTweakerAPI.apply((IAction)new AddCatalysisFuel(item, coefficient));
    }

    @ZenMethod
    public static void addCombustionFuel(IIngredient item, double coefficient) {
        CraftTweakerAPI.apply((IAction)new AddCombustionFuel(item, coefficient));
    }

    @ZenMethod
    public static void addMetalCoefficient(IIngredient block, double coefficient) {
        CraftTweakerAPI.apply((IAction)new AddMetalCoefficient(block.toString(), state -> block.matches(CraftTweakerMC.getIItemStack((ItemStack)Misc.getStackFromState(state))), coefficient));
    }

    public static class AddMetalCoefficient
    implements IAction {
        String matchDesc;
        Predicate<IBlockState> match;
        double coefficient;

        public AddMetalCoefficient(String matchDesc, Predicate<IBlockState> match, double coefficient) {
            this.matchDesc = matchDesc;
            this.match = match;
            this.coefficient = coefficient;
        }

        public void apply() {
            EmbersAPI.registerMetalCoefficient(new IMetalCoefficient(){

                @Override
                public boolean matches(IBlockState state) {
                    return match.test(state);
                }

                @Override
                public double getCoefficient(IBlockState state) {
                    return coefficient;
                }
            });
        }

        public String describe() {
            return "Adding metal coefficient " + this.coefficient + " for " + this.matchDesc;
        }
    }

    public static class AddCombustionFuel
    implements IAction {
        double coefficient;
        IIngredient item;

        public AddCombustionFuel(IIngredient item, double coefficient) {
            this.item = item;
            this.coefficient = coefficient;
        }

        public void apply() {
            EmbersAPI.registerCombustionFuel(CTUtil.toIngredient(this.item), this.coefficient);
        }

        public String describe() {
            return "Adding combustion fuel " + this.item.toString() + " with coefficient " + this.coefficient;
        }
    }

    public static class AddCatalysisFuel
    implements IAction {
        double coefficient;
        IIngredient item;

        public AddCatalysisFuel(IIngredient item, double coefficient) {
            this.item = item;
            this.coefficient = coefficient;
        }

        public void apply() {
            EmbersAPI.registerCatalysisFuel(CTUtil.toIngredient(this.item), this.coefficient);
        }

        public String describe() {
            return "Adding catalysis fuel " + this.item.toString() + " with coefficient " + this.coefficient;
        }
    }

    public static class AddEmberFuel
    implements IAction {
        double ember;
        IIngredient item;

        public AddEmberFuel(IIngredient item, double ember) {
            this.ember = ember;
            this.item = item;
        }

        public void apply() {
            EmbersAPI.registerEmberFuel(CTUtil.toIngredient(this.item), this.ember);
        }

        public String describe() {
            return "Adding ember fuel " + this.item.toString() + " with value " + this.ember;
        }
    }
}

