/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.apiimpl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.UpgradeEvent;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.IUpgradeUtil;
import teamroots.embers.tileentity.TileEntityMechCore;

public class UpgradeUtilImpl
implements IUpgradeUtil {
    @Override
    public List<IUpgradeProvider> getUpgrades(World world, BlockPos pos, EnumFacing[] facings) {
        LinkedList<IUpgradeProvider> upgrades = new LinkedList<IUpgradeProvider>();
        for (EnumFacing facing : facings) {
            TileEntity te = world.func_175625_s(pos.func_177972_a(facing));
            if (te == null || !te.hasCapability(EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY, facing.func_176734_d())) continue;
            upgrades.add((IUpgradeProvider)te.getCapability(EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY, facing.func_176734_d()));
        }
        return upgrades;
    }

    @Override
    public List<IUpgradeProvider> getUpgradesForMultiblock(World world, BlockPos pos, EnumFacing[] facings) {
        LinkedList<IUpgradeProvider> upgrades = new LinkedList<IUpgradeProvider>();
        for (EnumFacing facing : facings) {
            TileEntity te = world.func_175625_s(pos.func_177972_a(facing));
            if (!(te instanceof TileEntityMechCore)) continue;
            upgrades.addAll(this.getUpgrades(world, pos.func_177972_a(facing), EnumFacing.field_82609_l));
        }
        return upgrades;
    }

    @Override
    public void verifyUpgrades(TileEntity tile, List<IUpgradeProvider> list) {
        HashMap upgradeCounts = new HashMap();
        list.forEach(x -> {
            String id = x.getUpgradeId();
            upgradeCounts.put(x.getUpgradeId(), upgradeCounts.getOrDefault(id, 0) + 1);
        });
        list.removeIf(x -> (Integer)upgradeCounts.get(x.getUpgradeId()) > x.getLimit(tile));
        list.sort((x, y) -> Integer.compare(x.getPriority(), y.getPriority()));
    }

    @Override
    public int getWorkTime(TileEntity tile, int time, List<IUpgradeProvider> list) {
        double speedmod = this.getTotalSpeedModifier(tile, list);
        if (speedmod == 0.0) {
            return Integer.MAX_VALUE;
        }
        return (int)((double)time * (1.0 / speedmod));
    }

    @Override
    public double getTotalSpeedModifier(TileEntity tile, List<IUpgradeProvider> list) {
        double total = 1.0;
        for (IUpgradeProvider upgrade : list) {
            total = upgrade.getSpeed(tile, total);
        }
        return total;
    }

    @Override
    public boolean doTick(TileEntity tile, List<IUpgradeProvider> list) {
        for (IUpgradeProvider upgrade : list) {
            if (!upgrade.doTick(tile, list)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doWork(TileEntity tile, List<IUpgradeProvider> list) {
        for (IUpgradeProvider upgrade : list) {
            if (!upgrade.doWork(tile, list)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getTotalEmberConsumption(TileEntity tile, double ember, List<IUpgradeProvider> list) {
        for (IUpgradeProvider upgrade : list) {
            ember = upgrade.transformEmberConsumption(tile, ember);
        }
        return ember;
    }

    @Override
    public double getTotalEmberProduction(TileEntity tile, double ember, List<IUpgradeProvider> list) {
        for (IUpgradeProvider upgrade : list) {
            ember = upgrade.transformEmberProduction(tile, ember);
        }
        return ember;
    }

    @Override
    public void transformOutput(TileEntity tile, List<ItemStack> outputs, List<IUpgradeProvider> list) {
        for (IUpgradeProvider upgrade : list) {
            upgrade.transformOutput(tile, outputs);
        }
    }

    @Override
    public FluidStack transformOutput(TileEntity tile, FluidStack output, List<IUpgradeProvider> list) {
        for (IUpgradeProvider upgrade : list) {
            output = upgrade.transformOutput(tile, output);
        }
        return output;
    }

    @Override
    public boolean getOtherParameter(TileEntity tile, String type, boolean initial, List<IUpgradeProvider> list) {
        for (IUpgradeProvider upgrade : list) {
            initial = upgrade.getOtherParameter(tile, type, initial);
        }
        return initial;
    }

    @Override
    public double getOtherParameter(TileEntity tile, String type, double initial, List<IUpgradeProvider> list) {
        for (IUpgradeProvider upgrade : list) {
            initial = upgrade.getOtherParameter(tile, type, initial);
        }
        return initial;
    }

    @Override
    public int getOtherParameter(TileEntity tile, String type, int initial, List<IUpgradeProvider> list) {
        for (IUpgradeProvider upgrade : list) {
            initial = upgrade.getOtherParameter(tile, type, initial);
        }
        return initial;
    }

    @Override
    public String getOtherParameter(TileEntity tile, String type, String initial, List<IUpgradeProvider> list) {
        for (IUpgradeProvider upgrade : list) {
            initial = upgrade.getOtherParameter(tile, type, initial);
        }
        return initial;
    }

    @Override
    public <T> T getOtherParameter(TileEntity tile, String type, T initial, List<IUpgradeProvider> list) {
        for (IUpgradeProvider upgrade : list) {
            initial = upgrade.getOtherParameter(tile, type, initial);
        }
        return initial;
    }

    @Override
    public void throwEvent(TileEntity tile, UpgradeEvent event, List<IUpgradeProvider> list) {
        for (IUpgradeProvider upgrade : list) {
            upgrade.throwEvent(tile, event);
        }
    }
}

