/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.api.upgrades;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import teamroots.embers.api.event.UpgradeEvent;

public interface IUpgradeProvider {
    public String getUpgradeId();

    default public int getPriority() {
        return 0;
    }

    default public int getLimit(TileEntity tile) {
        return Integer.MAX_VALUE;
    }

    default public double getSpeed(TileEntity tile, double speed) {
        return speed;
    }

    default public boolean doTick(TileEntity tile, List<IUpgradeProvider> upgrades) {
        return false;
    }

    default public boolean doWork(TileEntity tile, List<IUpgradeProvider> upgrades) {
        return false;
    }

    default public double transformEmberConsumption(TileEntity tile, double ember) {
        return ember;
    }

    default public double transformEmberProduction(TileEntity tile, double ember) {
        return ember;
    }

    default public void transformOutput(TileEntity tile, List<ItemStack> outputs) {
    }

    default public FluidStack transformOutput(TileEntity tile, FluidStack output) {
        return output;
    }

    default public boolean getOtherParameter(TileEntity tile, String type, boolean value) {
        return value;
    }

    default public double getOtherParameter(TileEntity tile, String type, double value) {
        return value;
    }

    default public int getOtherParameter(TileEntity tile, String type, int value) {
        return value;
    }

    default public String getOtherParameter(TileEntity tile, String type, String value) {
        return value;
    }

    default public <T> T getOtherParameter(TileEntity tile, String type, T value) {
        return value;
    }

    default public void throwEvent(TileEntity tile, UpgradeEvent event) {
    }
}

