/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import teamroots.embers.tileentity.TileEntityStampBase;
import teamroots.embers.tileentity.TileEntityTank;

public class ConfigManager {
    public static Configuration config;
    public static int copperVeinSize;
    public static int copperMinY;
    public static int copperMaxY;
    public static int copperVeinsPerChunk;
    public static int leadVeinSize;
    public static int leadMinY;
    public static int leadMaxY;
    public static int leadVeinsPerChunk;
    public static int silverVeinSize;
    public static int silverMinY;
    public static int silverMaxY;
    public static int silverVeinsPerChunk;
    public static int quartzVeinSize;
    public static int quartzMinY;
    public static int quartzMaxY;
    public static int quartzVeinsPerChunk;
    public static int ancientGolemSpawnWeight;
    public static HashSet<Integer> orespawnGraylist;
    public static boolean orespawnIsWhiteList;
    public static int smallRuinChance;
    public static HashSet<Integer> smallRuinGraylist;
    public static boolean smallRuinIsWhiteList;
    @Deprecated
    public static List<Integer> orespawnBlacklist;
    @Deprecated
    public static List<Integer> smallRuinBlacklist;
    public static boolean enableNickel;
    public static boolean enableTin;
    public static boolean enableAluminum;
    public static boolean enableBronze;
    public static boolean enableElectrum;
    public static int nickelVeinSize;
    public static int nickelMinY;
    public static int nickelMaxY;
    public static int nickelVeinsPerChunk;
    public static int tinVeinSize;
    public static int tinMinY;
    public static int tinMaxY;
    public static int tinVeinsPerChunk;
    public static int aluminumVeinSize;
    public static int aluminumMinY;
    public static int aluminumMaxY;
    public static int aluminumVeinsPerChunk;
    public static boolean enableBaublesIntegration;
    public static boolean enableMysticalMechanicsIntegration;
    public static boolean pvpEverybodyIsEnemy;
    public static int melterOreAmount;
    public static int stampPlateAmount;
    public static int stampAspectusAmount;
    public static int stampGearAmount;
    public static int reservoirCapacity;
    static Pattern damageRatePattern;
    public static String[] defaultScaleDamagePasses;
    public static String[] defaultScaleDamageRates;
    public static Map<String, Double> scaleDamagePasses;
    public static Map<String, Double> scaleDamageRates;

    public static boolean isBaublesIntegrationEnabled() {
        return enableBaublesIntegration && Loader.isModLoaded((String)"baubles");
    }

    public static boolean isMysticalMechanicsIntegrationEnabled() {
        return enableMysticalMechanicsIntegration && Loader.isModLoaded((String)"mysticalmechanics");
    }

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigManager.load();
        }
    }

    public static void load() {
        Matcher matcher;
        config.addCustomCategoryComment("ores", "Settings related to ore generation.");
        for (String s : config.getStringList("oreBlacklist", "ores", new String[]{"-1", "1"}, "A list of all dimension IDs in which Embers orespawn is prohibited. Embers ores will spawn in any dimension not on this list, but only in vanilla stone.")) {
            orespawnGraylist.add(Integer.valueOf(s));
        }
        orespawnIsWhiteList = config.getBoolean("oreBlacklistIsWhitelist", "ores", false, "Whether the orespawn blacklist is a whitelist.");
        copperVeinSize = config.getInt("copperVeinSize", "ores", 12, 0, 255, "Maximum size of a copper ore vein (in blocks)");
        copperMinY = config.getInt("copperMinY", "ores", 0, 0, 254, "Minimum height over which copper ore will spawn.");
        copperMaxY = config.getInt("copperMaxY", "ores", 64, 1, 255, "Maximum height under which copper ore will spawn.");
        copperVeinsPerChunk = config.getInt("copperVeinsPerChunk", "ores", 6, 0, 255, "Number of attempts to spawn copper ore the world generator will make for each chunk.");
        leadVeinSize = config.getInt("leadVeinSize", "ores", 8, 0, 255, "Maximum size of a lead ore vein (in blocks)");
        leadMinY = config.getInt("leadMinY", "ores", 0, 0, 254, "Minimum height over which lead ore will spawn.");
        leadMaxY = config.getInt("leadMaxY", "ores", 28, 1, 255, "Maximum height under which lead ore will spawn.");
        leadVeinsPerChunk = config.getInt("leadVeinsPerChunk", "ores", 4, 0, 255, "Number of attempts to spawn lead ore the world generator will make for each chunk.");
        silverVeinSize = config.getInt("silverVeinSize", "ores", 6, 0, 255, "Maximum size of a silver ore vein (in blocks)");
        silverMinY = config.getInt("silverMinY", "ores", 0, 0, 254, "Minimum height over which silver ore will spawn.");
        silverMaxY = config.getInt("silverMaxY", "ores", 28, 1, 255, "Maximum height under which silver ore will spawn.");
        silverVeinsPerChunk = config.getInt("silverVeinsPerChunk", "ores", 4, 0, 255, "Number of attempts to spawn silver ore the world generator will make for each chunk.");
        quartzVeinSize = config.getInt("quartzVeinSize", "ores", 8, 0, 255, "Maximum size of a quartz ore vein (in blocks)");
        quartzMinY = config.getInt("quartzMinY", "ores", 0, 0, 254, "Minimum height over which quartz ore will spawn.");
        quartzMaxY = config.getInt("quartzMaxY", "ores", 18, 1, 255, "Maximum height under which quartz ore will spawn.");
        quartzVeinsPerChunk = config.getInt("quartzVeinsPerChunk", "ores", 4, 0, 255, "Number of attempts to spawn quartz ore the world generator will make for each chunk.");
        config.addCustomCategoryComment("mobs", "Settings related to ore generation.");
        ancientGolemSpawnWeight = config.getInt("ancientGolemSpawnWeight", "mobs", 25, 0, Short.MAX_VALUE, "Spawning weight of the Ancient Golem mob. Higher values make golems spawn more frequently.");
        config.addCustomCategoryComment("structures", "Settings related to structure generation.");
        smallRuinChance = config.getInt("smallRuinChance", "structures", 5, 0, Short.MAX_VALUE, "Spawning frequency of the small ruin structure. A value of 0 will prevent spawning altogether.");
        for (String s : config.getStringList("smallRuinBlacklist", "structures", new String[]{"0"}, "A list of all dimension IDs in which Embers small ruin generation is prohibited.")) {
            smallRuinGraylist.add(Integer.valueOf(s));
        }
        smallRuinIsWhiteList = config.getBoolean("smallRuinBlacklistIsWhitelist", "structures", true, "Whether the small ruin generation blacklist is a whitelist.");
        config.addCustomCategoryComment("compat", "Settings related to compatibility with other mods.");
        enableNickel = config.getBoolean("enableNickel", "compat", true, "If true, Embers will register items, blocks, and recipes providing support for other mods' nickel.");
        enableTin = config.getBoolean("enableTin", "compat", true, "If true, Embers will register items, blocks, and recipes providing support for other mods' tin.");
        enableAluminum = config.getBoolean("enableAluminum", "compat", true, "If true, Embers will register items, blocks, and recipes providing support for other mods' aluminum.");
        enableBronze = config.getBoolean("enableBronze", "compat", true, "If true, Embers will register items, blocks, and recipes providing support for other mods' bronze.");
        enableElectrum = config.getBoolean("enableElectrum", "compat", true, "If true, Embers will register items, blocks, and recipes providing support for other mods' electrum.");
        aluminumVeinSize = config.getInt("aluminumVeinSize", "compat", 6, 0, 255, "Maximum size of a aluminum ore vein (in blocks)");
        aluminumMinY = config.getInt("aluminumMinY", "compat", 0, 0, 254, "Minimum height over which aluminum ore will spawn.");
        aluminumMaxY = config.getInt("aluminumMaxY", "compat", 58, 1, 255, "Maximum height under which aluminum ore will spawn.");
        aluminumVeinsPerChunk = config.getInt("aluminumVeinsPerChunk", "compat", 4, 0, 255, "Number of attempts to spawn aluminum ore the world generator will make for each chunk.");
        nickelVeinSize = config.getInt("nickelVeinSize", "compat", 6, 0, 255, "Maximum size of a nickel ore vein (in blocks)");
        nickelMinY = config.getInt("nickelMinY", "compat", 0, 0, 254, "Minimum height over which nickel ore will spawn.");
        nickelMaxY = config.getInt("nickelMaxY", "compat", 24, 1, 255, "Maximum height under which nickel ore will spawn.");
        nickelVeinsPerChunk = config.getInt("nickelVeinsPerChunk", "compat", 4, 0, 255, "Number of attempts to spawn nickel ore the world generator will make for each chunk.");
        tinVeinSize = config.getInt("tinVeinSize", "compat", 6, 0, 255, "Maximum size of a tin ore vein (in blocks)");
        tinMinY = config.getInt("tinMinY", "compat", 0, 0, 254, "Minimum height over which tin ore will spawn.");
        tinMaxY = config.getInt("tinMaxY", "compat", 48, 1, 255, "Maximum height under which tin ore will spawn.");
        tinVeinsPerChunk = config.getInt("tinVeinsPerChunk", "compat", 6, 0, 255, "Number of attempts to spawn tin ore the world generator will make for each chunk.");
        enableBaublesIntegration = config.getBoolean("enableBaubles", "compat", true, "If true, Embers will register items, blocks and recipes providing Baubles integration.");
        enableMysticalMechanicsIntegration = config.getBoolean("enableMysticalMechanics", "compat", true, "If true, Embers will register items, blocks and recipes providing Mystical Mechanics integration.");
        pvpEverybodyIsEnemy = config.getBoolean("everybodyIsAnEnemy", "misc", false, "If true, Embers homing projectiles will go for neutral players.");
        melterOreAmount = config.getInt("melterOreAmount", "parameters", 144, 0, Integer.MAX_VALUE, "How many mb of fluid are obtained per ore output in the melter. This is multiplied by the amount of output a melter would produce, so by default 144mb * 2 ingots.");
        stampPlateAmount = config.getInt("stampPlateAmount", "parameters", 1, 1, Integer.MAX_VALUE, "How many ingots are required to make one plate in the stamper.");
        stampAspectusAmount = config.getInt("stampAspectusAmount", "parameters", 1, 1, Integer.MAX_VALUE, "How many ingots are required to make one aspectus in the stamper.");
        stampGearAmount = config.getInt("stampGearAmount", "parameters", 2, 1, Integer.MAX_VALUE, "How many ingots are required to make one gear in the stamper.");
        TileEntityStampBase.capacity = config.getInt("stampBaseCapacity", "parameters", 1500, 1, Integer.MAX_VALUE, "How much fluid (in mb) fits into the Stamp Base.");
        TileEntityTank.capacity = config.getInt("tankCapacity", "parameters", 16000, 1, Integer.MAX_VALUE, "How much fluid (in mb) fits into the Fluid Vessel.");
        reservoirCapacity = config.getInt("reservoirCapacity", "parameters", 40000, 1, Integer.MAX_VALUE, "How much fluid (in mb) fits into each Caminite Ring on a Reservoir.");
        scaleDamagePasses.clear();
        for (String pair : config.getStringList("scaleDamagePasses", "parameters", defaultScaleDamagePasses, "Syntax is 'damagetype:rate'. Determines which damage types are partially unaffected by the shifting scales augment.")) {
            matcher = damageRatePattern.matcher(pair);
            if (!matcher.matches()) continue;
            scaleDamagePasses.put(matcher.group(1), Double.parseDouble(matcher.group(2)));
        }
        scaleDamageRates.clear();
        for (String pair : config.getStringList("scaleDamageRates", "parameters", defaultScaleDamageRates, "Syntax is 'damagetype:rate'. Specifies a separate damage rate for depleting the scales.")) {
            matcher = damageRatePattern.matcher(pair);
            if (!matcher.matches()) continue;
            scaleDamageRates.put(matcher.group(1), Double.parseDouble(matcher.group(2)));
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean isSmallRuinEnabled(int dimension) {
        return smallRuinGraylist.contains(dimension) == smallRuinIsWhiteList && !smallRuinBlacklist.contains(dimension);
    }

    public static boolean isOreSpawnEnabled(int dimension) {
        return orespawnGraylist.contains(dimension) == orespawnIsWhiteList && !orespawnBlacklist.contains(dimension);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("embers")) {
            ConfigManager.load();
        }
    }

    static {
        orespawnGraylist = new HashSet();
        smallRuinGraylist = new HashSet();
        orespawnBlacklist = new ArrayList<Integer>();
        smallRuinBlacklist = new ArrayList<Integer>();
        damageRatePattern = Pattern.compile("(\\w+):(\\d+(?:\\.\\d+|))");
        defaultScaleDamagePasses = new String[]{"drown:1.0", "starve:1.0"};
        defaultScaleDamageRates = new String[0];
        scaleDamagePasses = new HashMap<String, Double>();
        scaleDamageRates = new HashMap<String, Double>();
    }
}

