/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown;

import com.brandon3055.brandonscore.client.gui.modulargui.markdown.MDElementContainer;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.EntityElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.ImageElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.LinkElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MarkerElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.RecipeElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.RuleElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.StackElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.TableElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.TextElement;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.HAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.lib.TableDefinition;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.MarkdownVisitor;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.property.EntityVisitor;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.property.ImageVisitor;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.property.LinkVisitor;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.property.RecipeVisitor;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.property.RuleVisitor;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.property.StackVisitor;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.reader.visitor.property.TableVisitor;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.visitorimpl.EntityVisitorImpl;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.visitorimpl.ImageVisitorImpl;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.visitorimpl.LinkVisitorImpl;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.visitorimpl.RecipeVisitorImpl;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.visitorimpl.RuleVisitorImpl;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.visitorimpl.StackVisitorImpl;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.visitorimpl.TableVisitorImpl;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.LinkedList;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class MDElementFactory
extends MarkdownVisitor {
    private static Pattern obf = Pattern.compile("(?<=[^\\\\]|^)(~\\?~.*~\\?~)");
    private static Pattern bold = Pattern.compile("(?<=[^\\\\]|^)(\\*\\*.*\\*\\*)");
    private static Pattern italic = Pattern.compile("(?<=[^\\\\]|^)(\\*.*\\*)");
    private static Pattern strike = Pattern.compile("(?<=[^\\\\]|^)(~~.*~~)");
    private static Pattern tablePat = Pattern.compile("(?<=[^\\\\]|^)(\u00a7table\\[[^]]*])");
    private static Pattern underline = Pattern.compile("(?<=[^\\\\]|^)(__.*__)");
    private MDElementContainer container;
    private boolean colourOverridden = false;
    private Supplier<Integer> colourSupplier = () -> 0;
    private boolean shadow = false;
    private int colourOverride = 0;
    private int lineElements = 0;
    private boolean formatLine = false;
    public boolean truncateNewLines = true;

    public MDElementFactory(MDElementContainer container) {
        this.container = container;
        container.lastFactory = this;
    }

    @Override
    public void startVisit() {
    }

    @Override
    public void startLine() {
    }

    @Override
    public StackVisitor visitStack(String stackString) {
        StackElement element = new StackElement(stackString);
        StackVisitorImpl visitor = new StackVisitorImpl(element);
        this.addElement(element);
        return visitor;
    }

    @Override
    public RecipeVisitor visitRecipe(String stackString) {
        RecipeElement element = new RecipeElement(stackString);
        RecipeVisitorImpl visitor = new RecipeVisitorImpl(element);
        this.addElement(element);
        return visitor;
    }

    @Override
    public ImageVisitor visitImage(String imageURL) {
        ImageElement element = new ImageElement(this.container, imageURL);
        ImageVisitorImpl visitor = new ImageVisitorImpl(element);
        this.addElement(element);
        return visitor;
    }

    @Override
    public LinkVisitor visitLink(String linkTarget) {
        LinkElement element = new LinkElement(this.container, linkTarget);
        LinkVisitorImpl visitor = new LinkVisitorImpl(element);
        element.shadow = this.shadow;
        element.defaultColour = this.colourOverridden ? () -> this.colourOverride : this.colourSupplier;
        this.addElement(element);
        return visitor;
    }

    @Override
    public EntityVisitor visitEntity(String regName) {
        EntityElement element = new EntityElement(regName);
        EntityVisitorImpl visitor = new EntityVisitorImpl(element);
        this.addElement(element);
        return visitor;
    }

    @Override
    public RuleVisitor visitRule() {
        RuleElement element = new RuleElement();
        RuleVisitorImpl visitor = new RuleVisitorImpl(element);
        this.addElement(element);
        return visitor;
    }

    @Override
    public TableVisitor visitTable(TableDefinition definition) {
        TableElement element = new TableElement(this.container, definition);
        TableVisitorImpl visitor = new TableVisitorImpl(element);
        this.addElement(element);
        return visitor;
    }

    @Override
    public void visitHeading(String text, int heading, boolean underlineDefinition) {
        text = MDElementFactory.applyTextFormatting(text);
        TextElement element = new TextElement(text, heading);
        element.colour = this.colourOverridden ? () -> this.colourOverride : this.colourSupplier;
        element.shadow = this.shadow;
        this.addElement(element);
    }

    @Override
    public void visitText(String text) {
        text = MDElementFactory.applyTextFormatting(text);
        TextElement element = new TextElement(text, 0);
        element.colour = this.colourOverridden ? () -> this.colourOverride : this.colourSupplier;
        element.shadow = this.shadow;
        this.addElement(element);
    }

    @Override
    public void visitAlignment(HAlign alignment) {
        this.addElement(MarkerElement.forAlignment(alignment));
    }

    @Override
    public void visitShadow(boolean enable) {
        this.shadow = enable;
        this.formatLine = true;
    }

    @Override
    public void visitColour(int argb) {
        this.colourOverride = argb;
        this.colourOverridden = true;
        this.formatLine = true;
    }

    @Override
    public void visitComment(String comment) {
    }

    @Override
    public void visitSkipped(String skipped) {
    }

    @Override
    public void endLine() {
        if (this.lineElements > 0) {
            this.colourOverridden = false;
            this.formatLine = false;
            this.lineElements = 0;
        } else if (this.formatLine) {
            return;
        }
        LinkedList<MDElementBase> eList = this.container.getElements();
        if (!(this.truncateNewLines && eList.size() >= 2 && MarkerElement.isNewLine((MDElementBase)eList.get(eList.size() - 1)) && MarkerElement.isNewLine((MDElementBase)eList.get(eList.size() - 2)))) {
            this.addElement(new MarkerElement(MarkerElement.Type.NEW_LINE));
        }
    }

    @Override
    public void endVisit() {
    }

    private void addElement(MDElementBase element) {
        if (!(element instanceof MarkerElement)) {
            ++this.lineElements;
        }
        if (!element.getError().isEmpty()) {
            this.addErrorElement(element);
        } else {
            this.container.addElement(element);
        }
    }

    private void addErrorElement(MDElementBase erredElement) {
        TextElement error = new TextElement(erredElement.getError(), 0);
        error.colour = () -> 0xFF0000;
        this.addElement(error);
    }

    @Override
    public void visitError(String errorMessage) {
        TextElement error = new TextElement("\n" + errorMessage + "\n", 0);
        error.colour = () -> 0xFF0000;
        this.addElement(error);
    }

    public void setColourSupplier(Supplier<Integer> colourSupplier) {
        this.colourSupplier = colourSupplier;
    }

    public void inherit(MDElementFactory parentFactory) {
        this.colourSupplier = parentFactory.colourSupplier;
    }

    private static String applyTextFormatting(String input) {
        input = input.replaceAll("\t", "");
        int escape = 0;
        while (bold.matcher(input).find() && escape++ < 1000) {
            input = input.replaceFirst("(\\*\\*)", "\u00a7l").replaceFirst("(\\*\\*)", "\u00a7l");
        }
        while (italic.matcher(input).find() && escape++ < 1000) {
            input = input.replaceFirst("(\\*)", "\u00a7o").replaceFirst("(\\*)", "\u00a7o");
        }
        while (underline.matcher(input).find() && escape++ < 1000) {
            input = input.replaceFirst("(__)", "\u00a7n").replaceFirst("(__)", "\u00a7n");
        }
        while (strike.matcher(input).find() && escape++ < 1000) {
            input = input.replaceFirst("(~~)", "\u00a7m").replaceFirst("(~~)", "\u00a7m");
        }
        while (obf.matcher(input).find() && escape++ < 1000) {
            input = input.replaceFirst("(~\\?~)", "\u00a7k").replaceFirst("(~\\?~)", "\u00a7k");
        }
        if (escape >= 1000) {
            LogHelperBC.dev("Escape!");
        }
        return input;
    }
}

