/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.running;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.rftoolscontrol.api.code.IOpcodeRunnable;
import mcjty.rftoolscontrol.api.machines.IProgram;
import mcjty.rftoolscontrol.api.parameters.Parameter;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.blocks.processor.ProcessorTileEntity;
import mcjty.rftoolscontrol.config.GeneralConfiguration;
import mcjty.rftoolscontrol.logic.TypeConverters;
import mcjty.rftoolscontrol.logic.compiled.CompiledCard;
import mcjty.rftoolscontrol.logic.compiled.CompiledEvent;
import mcjty.rftoolscontrol.logic.compiled.CompiledOpcode;
import mcjty.rftoolscontrol.logic.registry.ParameterTypeTools;
import mcjty.rftoolscontrol.logic.running.ExceptionType;
import mcjty.rftoolscontrol.logic.running.ProgException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class RunningProgram
implements IProgram {
    public static boolean DEBUG = false;
    private final int cardIndex;
    private int current = 0;
    private int eventIndex = 0;
    private String ticket = null;
    private String lock = null;
    private int delay = 0;
    private boolean dead = false;
    private Parameter lastValue;
    private List<FlowStack> loopStack = new ArrayList<FlowStack>();
    private List<CompiledOpcode> opcodeCache = null;

    public RunningProgram(int cardIndex) {
        this.cardIndex = cardIndex;
    }

    public void startFromEvent(CompiledEvent event) {
        this.current = event.getIndex();
        this.eventIndex = event.getIndex();
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getEventIndex() {
        return this.eventIndex;
    }

    public void setCraftTicket(@Nullable String craftId) {
        this.ticket = craftId;
    }

    @Override
    @Nullable
    public String getCraftTicket() {
        return this.ticket;
    }

    @Override
    public boolean hasCraftTicket() {
        return this.ticket != null && !this.ticket.isEmpty();
    }

    @Override
    public void setDelay(int delay) {
        this.delay = delay;
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    public String getLock() {
        return this.lock;
    }

    public void setLock(String lock) {
        this.lock = lock;
    }

    @Override
    public void killMe() {
        this.dead = true;
    }

    @Override
    public boolean isDead() {
        return this.dead;
    }

    public int getCardIndex() {
        return this.cardIndex;
    }

    @Override
    public void setLastValue(Parameter value) {
        this.lastValue = value;
    }

    @Override
    public Parameter getLastValue() {
        return this.lastValue;
    }

    public CompiledOpcode getCurrentOpcode(ProcessorTileEntity processor) {
        return this.opcodes(processor).get(this.current);
    }

    public void pushLoopStack(int varIndex) {
        if (this.loopStack.size() >= GeneralConfiguration.maxStackSize) {
            throw new ProgException(ExceptionType.EXCEPT_STACKOVERFLOW);
        }
        this.loopStack.add(new FlowStack(this.current, varIndex));
    }

    public void pushCall(int returnIndex) {
        if (this.loopStack.size() >= GeneralConfiguration.maxStackSize) {
            throw new ProgException(ExceptionType.EXCEPT_STACKOVERFLOW);
        }
        this.loopStack.add(new FlowStack(returnIndex, null));
    }

    public void popLoopStack(ProcessorTileEntity processor) {
        if (this.loopStack.isEmpty()) {
            this.killMe();
        } else {
            FlowStack pair = this.loopStack.get(this.loopStack.size() - 1);
            this.current = pair.getCurrent();
            Integer varIdx = pair.getVar();
            this.loopStack.remove(this.loopStack.size() - 1);
            if (varIdx != null) {
                Parameter parameter = processor.getVariableArray()[varIdx];
                int i = TypeConverters.convertToInt(parameter);
                processor.getVariableArray()[varIdx.intValue()] = Parameter.builder().type(ParameterType.PAR_INTEGER).value(ParameterValue.constant(++i)).build();
            }
        }
    }

    public boolean run(ProcessorTileEntity processor) {
        if (this.delay > 0) {
            --this.delay;
            return false;
        }
        if (this.lock != null) {
            if (processor.testLock(this.lock)) {
                return false;
            }
            this.lock = null;
        }
        try {
            IOpcodeRunnable.OpcodeResult result;
            CompiledOpcode opcode = this.opcodes(processor).get(this.current);
            if (DEBUG) {
                System.out.println(opcode.getOpcode());
            }
            if ((result = opcode.run(processor, this)) == IOpcodeRunnable.OpcodeResult.POSITIVE) {
                this.current = opcode.getPrimaryIndex();
            } else if (result == IOpcodeRunnable.OpcodeResult.NEGATIVE) {
                this.current = opcode.getSecondaryIndex();
            }
        }
        catch (ProgException e) {
            throw e;
        }
        catch (Exception e) {
            LogManager.getLogger().log(Level.ERROR, "Opcode failed with: ", (Throwable)e);
            throw new ProgException(ExceptionType.EXCEPT_INTERNALERROR);
        }
        return true;
    }

    private List<CompiledOpcode> opcodes(ProcessorTileEntity processor) {
        if (this.opcodeCache == null) {
            CompiledCard card = processor.getCompiledCard(this.cardIndex);
            this.opcodeCache = card.getOpcodes();
        }
        return this.opcodeCache;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("card", this.cardIndex);
        tag.func_74768_a("current", this.current);
        tag.func_74768_a("event", this.eventIndex);
        tag.func_74768_a("delay", this.delay);
        tag.func_74757_a("dead", this.dead);
        if (this.ticket != null) {
            tag.func_74778_a("ticket", this.ticket);
        }
        if (this.lock != null) {
            tag.func_74778_a("lock", this.lock);
        }
        if (this.lastValue != null) {
            NBTTagCompound varTag = new NBTTagCompound();
            varTag.func_74768_a("type", this.lastValue.getParameterType().ordinal());
            ParameterTypeTools.writeToNBT(varTag, this.lastValue.getParameterType(), this.lastValue.getParameterValue());
            tag.func_74782_a("lastvar", (NBTBase)varTag);
        }
        if (!this.loopStack.isEmpty()) {
            NBTTagList loopList = new NBTTagList();
            for (FlowStack pair : this.loopStack) {
                NBTTagCompound t = new NBTTagCompound();
                t.func_74768_a("index", pair.getCurrent());
                t.func_74768_a("var", pair.getVar() == null ? -1 : pair.getVar());
                loopList.func_74742_a((NBTBase)t);
            }
            tag.func_74782_a("loopStack", (NBTBase)loopList);
        }
    }

    public static RunningProgram readFromNBT(NBTTagCompound tag) {
        if (!tag.func_74764_b("card")) {
            return null;
        }
        int cardIndex = tag.func_74762_e("card");
        RunningProgram program = new RunningProgram(cardIndex);
        program.setCurrent(tag.func_74762_e("current"));
        program.eventIndex = tag.func_74762_e("event");
        program.setDelay(tag.func_74762_e("delay"));
        program.dead = tag.func_74767_n("dead");
        if (tag.func_74764_b("ticket")) {
            program.ticket = tag.func_74779_i("ticket");
        }
        if (tag.func_74764_b("lock")) {
            program.lock = tag.func_74779_i("lock");
        }
        if (tag.func_74764_b("lastvar")) {
            NBTTagCompound varTag = tag.func_74775_l("lastvar");
            int t = varTag.func_74762_e("type");
            ParameterType type = ParameterType.values()[t];
            program.lastValue = Parameter.builder().type(type).value(ParameterTypeTools.readFromNBT(varTag, type)).build();
        }
        if (tag.func_74764_b("loopStack")) {
            program.loopStack.clear();
            NBTTagList loopList = tag.func_150295_c("loopStack", 10);
            for (int i = 0; i < loopList.func_74745_c(); ++i) {
                NBTTagCompound t = loopList.func_150305_b(i);
                int var = tag.func_74762_e("var");
                program.loopStack.add(new FlowStack(tag.func_74762_e("index"), var == -1 ? null : Integer.valueOf(var)));
            }
        }
        return program;
    }

    private static class FlowStack {
        private final int current;
        private final Integer var;

        public FlowStack(int current, Integer var) {
            this.current = current;
            this.var = var;
        }

        public int getCurrent() {
            return this.current;
        }

        public Integer getVar() {
            return this.var;
        }
    }
}

