/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network.mc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.minemaarten.signals.Signals;
import com.minemaarten.signals.api.access.ISignal;
import com.minemaarten.signals.config.SignalsConfig;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.PacketAddOrUpdateTrain;
import com.minemaarten.signals.network.PacketClearNetwork;
import com.minemaarten.signals.network.PacketUpdateNetwork;
import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.INetworkObject;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.NetworkUpdater;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.RailNetworkClient;
import com.minemaarten.signals.rail.network.RailPathfinder;
import com.minemaarten.signals.rail.network.RailRoute;
import com.minemaarten.signals.rail.network.Train;
import com.minemaarten.signals.rail.network.mc.MCNetworkState;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.MCTrain;
import com.minemaarten.signals.rail.network.mc.NetworkObjectProvider;
import com.minemaarten.signals.rail.network.mc.NetworkStorage;
import com.minemaarten.signals.tileentity.TileEntityBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class RailNetworkManager {
    private static RailNetworkManager CLIENT_INSTANCE;
    private static RailNetworkManager SERVER_INSTANCE;
    private final ExecutorService railNetworkExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("signals-network-thread-%d").build());
    private Future<RailNetwork<MCPos>> networkUpdateTask;
    private RailNetwork<MCPos> network;
    private MCNetworkState state = new MCNetworkState(this);
    private final NetworkUpdater<MCPos> networkUpdater = new NetworkUpdater<MCPos>(new NetworkObjectProvider());
    private static final int MAX_CHANGES_PER_PACKET = 1000;

    public static RailNetworkManager getInstance(boolean clientInstance) {
        return clientInstance ? RailNetworkManager.getClientInstance() : RailNetworkManager.getServerInstance();
    }

    public static RailNetworkManager getClientInstance() {
        if (CLIENT_INSTANCE == null) {
            CLIENT_INSTANCE = new RailNetworkManager(true);
        }
        return CLIENT_INSTANCE;
    }

    public static RailNetworkManager getServerInstance() {
        if (SERVER_INSTANCE == null) {
            SERVER_INSTANCE = new RailNetworkManager(false);
        }
        return SERVER_INSTANCE;
    }

    private RailNetworkManager(boolean client) {
        this.network = client ? RailNetworkClient.empty() : RailNetwork.empty();
    }

    private void validateOnServer() {
        if (this == CLIENT_INSTANCE) {
            throw new IllegalStateException();
        }
    }

    private void validateOnClient() {
        if (this == SERVER_INSTANCE) {
            throw new IllegalStateException();
        }
    }

    public boolean isClientInstance() {
        return this == CLIENT_INSTANCE;
    }

    private Set<MCPos> getStartNodes() {
        HashSet<MCPos> nodes = new HashSet<MCPos>();
        for (WorldServer world : DimensionManager.getWorlds()) {
            for (TileEntity te : world.field_147482_g) {
                if (!(te instanceof TileEntityBase)) continue;
                nodes.add(new MCPos((World)world, te.func_174877_v()));
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    BlockPos pos = te.func_174877_v().func_177972_a(facing);
                    nodes.add(new MCPos((World)world, pos));
                }
            }
        }
        return nodes;
    }

    public void rebuildNetwork() {
        this.validateOnServer();
        NetworkHandler.sendToAll(new PacketClearNetwork());
        this.network = RailNetwork.empty();
        this.getStartNodes().forEach(this.networkUpdater::markDirty);
        this.initTrains();
        this.state.update(this.network);
    }

    private void initTrains() {
        ArrayList<EntityMinecart> carts = new ArrayList<EntityMinecart>();
        for (WorldServer world : DimensionManager.getWorlds()) {
            for (Entity entity : world.field_72996_f) {
                if (!(entity instanceof EntityMinecart)) continue;
                carts.add((EntityMinecart)entity);
            }
        }
        Set<MCTrain> trains = new NetworkObjectProvider().provideTrains(carts);
        this.state.setTrains(trains);
        for (MCTrain train : trains) {
            NetworkHandler.sendToAll(new PacketAddOrUpdateTrain(train));
        }
    }

    public RailNetwork<MCPos> getNetwork() {
        return this.network;
    }

    public RailNetworkClient<MCPos> getClientNetwork() {
        return (RailNetworkClient)this.network;
    }

    public MCNetworkState getState() {
        return this.state;
    }

    public NetworkRail<MCPos> getRail(World world, BlockPos pos) {
        return this.getRail(new MCPos(world, pos));
    }

    public NetworkRail<MCPos> getRail(MCPos pos) {
        return this.network.railObjects.getRail(pos);
    }

    public void loadNetwork(RailNetwork<MCPos> network, MCNetworkState state) {
        this.networkUpdateTask = null;
        state.getTrackingCartsFrom(this.state);
        this.network = network;
        this.state = state;
        NetworkHandler.sendToAll(new PacketClearNetwork());
        for (PacketUpdateNetwork packetUpdateNetwork : this.getSplitNetworkUpdatePackets((Collection<INetworkObject<MCPos>>)network.railObjects.getAllNetworkObjects().values())) {
            NetworkHandler.sendToAll(packetUpdateNetwork);
        }
        for (Train train : state.getTrains()) {
            NetworkHandler.sendToAll(new PacketAddOrUpdateTrain((MCTrain)train));
        }
    }

    public MCTrain getTrainByID(int id) {
        return (MCTrain)this.state.getTrain(id);
    }

    public Stream<MCTrain> getAllTrains() {
        return this.state.getTrainStream().map(t -> (MCTrain)t);
    }

    public void addTrain(MCTrain train) {
        if (this == SERVER_INSTANCE) {
            NetworkHandler.sendToAll(new PacketAddOrUpdateTrain(train));
        }
        this.state.addTrain(train);
    }

    public void removeTrain(int trainID) {
        this.state.removeTrain(trainID);
    }

    public ISignal.EnumLampStatus getLampStatus(World world, BlockPos pos) {
        return this.state.getLampStatus(new MCPos(world, pos));
    }

    public RailRoute.RailRouteResult<MCPos> pathfind(MCPos start, Train<MCPos> train, Pattern destinationRegex, EnumHeading direction) {
        return new RailPathfinder<MCPos>(this.network, this.state).pathfindToDestination(start, train, destinationRegex, direction);
    }

    public void markDirty(MCPos pos) {
        this.validateOnServer();
        this.networkUpdater.markDirty(pos);
    }

    public void onPreServerTick() {
        if (!SignalsConfig.enableRailNetwork) {
            return;
        }
        Collection<INetworkObject<MCPos>> updates = this.networkUpdater.getNetworkUpdates(this.network);
        if (!updates.isEmpty()) {
            this.applyUpdates(updates);
            for (PacketUpdateNetwork packet : this.getSplitNetworkUpdatePackets(updates)) {
                NetworkHandler.sendToAll(packet);
            }
        }
    }

    public void checkForNewNetwork(boolean forceWait) {
        if (this.networkUpdateTask != null && (forceWait || this.networkUpdateTask.isDone())) {
            try {
                this.network = this.networkUpdateTask.get();
                this.networkUpdateTask = null;
                NetworkStorage.getInstance(this.isClientInstance()).setNetwork(this.network);
                if (this == CLIENT_INSTANCE) {
                    this.railNetworkExecutor.submit(() -> {
                        this.network.build();
                        Signals.proxy.onRailNetworkUpdated();
                    });
                }
                this.state.onNetworkChanged(this.network);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void applyUpdates(Collection<INetworkObject<MCPos>> changedObjects) {
        if (this == SERVER_INSTANCE || this.networkUpdateTask == null) {
            this.checkForNewNetwork(true);
            this.networkUpdateTask = this.railNetworkExecutor.submit(() -> this.networkUpdater.applyUpdates(this.getNetwork(), changedObjects).build());
        } else {
            Future<RailNetwork<MCPos>> prevTask = this.networkUpdateTask;
            this.networkUpdateTask = this.railNetworkExecutor.submit(() -> this.networkUpdater.applyUpdates((RailNetwork)prevTask.get(), changedObjects));
        }
    }

    public void clearNetwork() {
        this.validateOnClient();
        this.network = RailNetworkClient.empty();
        this.state.setTrains(Collections.emptyList());
        Signals.proxy.onRailNetworkUpdated();
    }

    public void onPostServerTick() {
        if (!SignalsConfig.enableRailNetwork) {
            return;
        }
        this.validateOnServer();
        this.checkForNewNetwork(true);
        this.state.update(this.network);
        if (this.networkUpdater.didJustTurnBusy()) {
            this.notifyAllPlayers((ITextComponent)new TextComponentTranslation("signals.message.signals_busy", new Object[0]));
        }
        if (this.networkUpdater.didJustTurnIdle()) {
            this.notifyAllPlayers((ITextComponent)new TextComponentTranslation("signals.message.signals_idle", new Object[0]));
        }
    }

    private void notifyAllPlayers(ITextComponent text) {
        for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            player.func_145747_a(text);
        }
    }

    public void onPreClientTick() {
        if (!SignalsConfig.enableRailNetwork) {
            return;
        }
        this.validateOnClient();
        this.checkForNewNetwork(false);
    }

    public void onPlayerJoin(EntityPlayerMP player) {
        NetworkHandler.sendTo(new PacketClearNetwork(), player);
        for (PacketUpdateNetwork packet : this.getSplitNetworkUpdatePackets((Collection<INetworkObject<MCPos>>)this.network.railObjects.getAllNetworkObjects().values())) {
            NetworkHandler.sendTo(packet, player);
        }
        this.state.onPlayerJoin(player);
    }

    public void onChunkUnload(Chunk chunk) {
        this.state.onChunkUnload(chunk);
    }

    public void onMinecartJoinedWorld(EntityMinecart cart) {
        this.state.onMinecartJoinedWorld(cart);
    }

    public void onCartRemoved(EntityMinecart cart) {
        this.state.removeCart(cart);
    }

    private List<PacketUpdateNetwork> getSplitNetworkUpdatePackets(Collection<INetworkObject<MCPos>> allChangedObjects) {
        if (allChangedObjects.size() <= 1000) {
            return Collections.singletonList(new PacketUpdateNetwork(allChangedObjects));
        }
        ArrayList<PacketUpdateNetwork> packets = new ArrayList<PacketUpdateNetwork>();
        Iterator<INetworkObject<MCPos>> iterator = allChangedObjects.iterator();
        ArrayList<INetworkObject<MCPos>> changedObjects = new ArrayList<INetworkObject<MCPos>>(1000);
        while (iterator.hasNext()) {
            changedObjects.add(iterator.next());
            if (changedObjects.size() < 1000) continue;
            packets.add(new PacketUpdateNetwork(changedObjects));
            changedObjects = new ArrayList(1000);
        }
        if (!changedObjects.isEmpty()) {
            packets.add(new PacketUpdateNetwork(changedObjects));
        }
        return packets;
    }
}

