/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network.mc;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.minemaarten.signals.api.IRail;
import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.lib.Log;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.PacketAddOrUpdateTrain;
import com.minemaarten.signals.network.PacketUpdateMessage;
import com.minemaarten.signals.rail.RailManager;
import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.NetworkState;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.RailRoute;
import com.minemaarten.signals.rail.network.Train;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.NetworkStorage;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MCTrain
extends Train<MCPos> {
    private static Map<EnumSet<EnumHeading>, BlockRailBase.EnumRailDirection> DIRS_TO_RAIL_DIR = new HashMap<EnumSet<EnumHeading>, BlockRailBase.EnumRailDirection>(6);
    private final RailNetworkManager railNetworkManager;
    public ImmutableSet<UUID> cartIDs;
    private Set<EntityMinecart> carts;

    protected MCTrain(RailNetworkManager railNetworkManager, int id, ImmutableSet<UUID> cartIDs) {
        super(id);
        this.railNetworkManager = railNetworkManager;
        this.cartIDs = cartIDs;
    }

    public MCTrain(RailNetworkManager railNetworkManager, ImmutableSet<UUID> cartIDs) {
        this.railNetworkManager = railNetworkManager;
        this.cartIDs = cartIDs;
    }

    public MCTrain(RailNetworkManager railNetworkManager, List<EntityMinecart> carts) {
        this(railNetworkManager, (ImmutableSet<UUID>)((ImmutableSet)carts.stream().map(c -> c.func_110124_au()).collect(ImmutableSet.toImmutableSet())));
    }

    public Set<EntityMinecart> getCarts() {
        if (this.carts == null) {
            this.carts = this.cartIDs.stream().map(id -> this.railNetworkManager.getState().getCart((UUID)id)).filter((Predicate<EntityMinecart>)Predicates.notNull()).collect(Collectors.toSet());
        }
        return this.carts;
    }

    public void onCartAdded(EntityMinecart cart) {
        if (this.getCarts().size() < this.cartIDs.size() && this.cartIDs.contains((Object)cart.func_110124_au())) {
            this.getCarts().add(cart);
        }
    }

    public void onCartRemoved(EntityMinecart cart) {
        if (!this.getCarts().isEmpty()) {
            this.getCarts().remove(cart);
        }
    }

    public void addCartIDs(Collection<UUID> ids) {
        this.cartIDs = (ImmutableSet)Streams.concat((Stream[])new Stream[]{this.cartIDs.stream(), ids.stream()}).collect(ImmutableSet.toImmutableSet());
        this.carts = null;
    }

    @Override
    public boolean updatePositions(NetworkState<MCPos> state) {
        super.updatePositions(state);
        Set<EntityMinecart> carts = this.getCarts();
        if (!carts.isEmpty()) {
            ImmutableSet.Builder positionBuilder = ImmutableSet.builder();
            for (EntityMinecart cart : this.getCarts()) {
                MCPos cartPos = new MCPos(cart.field_70170_p, cart.func_180425_c().func_177977_b());
                if (this.railNetworkManager.getNetwork().railObjects.get(cartPos) == null) {
                    cartPos = new MCPos(cart.field_70170_p, cart.func_180425_c());
                }
                positionBuilder.add((Object)cartPos);
            }
            ImmutableSet positions = positionBuilder.build();
            return this.setPositions(this.railNetworkManager.getNetwork(), state, positions);
        }
        return false;
    }

    @Override
    protected void onPositionChanged(RailNetwork<MCPos> network, NetworkState<MCPos> state) {
        super.onPositionChanged(network, state);
        NetworkHandler.sendToAll(new PacketAddOrUpdateTrain(this));
        NetworkStorage.getInstance(this.railNetworkManager.isClientInstance()).func_76185_a();
    }

    @Override
    public RailRoute<MCPos> pathfind(MCPos start, EnumHeading dir) {
        EntityMinecart cart;
        RailRoute<MCPos> path = null;
        Iterator<EntityMinecart> iterator = this.getCarts().iterator();
        while (iterator.hasNext() && (path = this.pathfind(cart = iterator.next(), start, dir)) == null) {
        }
        return path;
    }

    private RailRoute<MCPos> pathfind(EntityMinecart cart, MCPos start, EnumHeading dir) {
        CapabilityMinecartDestination capability = (CapabilityMinecartDestination)cart.getCapability(CapabilityMinecartDestination.INSTANCE, null);
        int startDestinationIndex = capability.getDestinationIndex();
        boolean firstTry = true;
        if (startDestinationIndex != -1) {
            do {
                String destination = capability.getCurrentDestination();
                Pattern destinationRegex = capability.getCurrentDestinationRegex();
                ArrayList messages = new ArrayList();
                if (!firstTry && capability.getDestinationIndex() == startDestinationIndex) {
                    return null;
                }
                firstTry = false;
                RailRoute.RailRouteResult<MCPos> routeResult = this.railNetworkManager.pathfind(start, this, destinationRegex, dir);
                if (routeResult.routeResult == RailRoute.EnumRouteResult.NO_PATH) {
                    return null;
                }
                if (routeResult.routeResult == RailRoute.EnumRouteResult.SUCCESS) {
                    return routeResult.railRoute;
                }
                capability.nextDestination();
            } while (capability.getDestinationIndex() != startDestinationIndex);
            return null;
        }
        return null;
    }

    @Override
    protected void updateIntersection(RailRoute.RailRouteNode<MCPos> routeNode) {
        World world;
        if (routeNode.isValid() && (world = ((MCPos)routeNode.pos).getWorld()) != null) {
            BlockPos pos = ((MCPos)routeNode.pos).getPos();
            IBlockState state = world.func_180495_p(pos);
            IRail rail = RailManager.getInstance().getRail(world, pos, state);
            ArrayList messages = new ArrayList();
            BlockRailBase.EnumRailDirection requiredDir = DIRS_TO_RAIL_DIR.get(EnumSet.of(routeNode.dirIn, routeNode.dirOut));
            if (requiredDir != null) {
                if (rail.getValidDirections(world, pos, state).contains(requiredDir)) {
                    rail.setDirection(world, pos, state, requiredDir);
                    String[] stringArray = new String[]{Integer.toString(pos.func_177958_n()), Integer.toString(pos.func_177956_o()), Integer.toString(pos.func_177952_p()), "signals.dir." + routeNode.dirIn.toString().toLowerCase(), "signals.dir." + routeNode.dirOut.toString().toLowerCase()};
                } else {
                    Log.warning("Rail with state " + state + " does not allow setting dir " + requiredDir);
                }
            } else {
                Log.warning("Invalid routing node: " + routeNode);
            }
            for (PacketUpdateMessage message : messages) {
                NetworkHandler.sendToAllAround(message, world);
            }
        }
    }

    @Override
    protected boolean isActive() {
        return !this.getCarts().isEmpty();
    }

    public boolean equals(Object obj) {
        return obj instanceof MCTrain && ((MCTrain)obj).cartIDs.equals(this.cartIDs);
    }

    public int hashCode() {
        return this.cartIDs.hashCode();
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList idList = new NBTTagList();
        for (UUID uuid : this.cartIDs) {
            idList.func_74742_a((NBTBase)new NBTTagLong(uuid.getMostSignificantBits()));
            idList.func_74742_a((NBTBase)new NBTTagLong(uuid.getLeastSignificantBits()));
        }
        tag.func_74782_a("cartIDs", (NBTBase)idList);
        NBTTagList posList = new NBTTagList();
        for (MCPos pos : this.positions) {
            NBTTagCompound t = new NBTTagCompound();
            pos.writeToNBT(t);
            posList.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("positions", (NBTBase)posList);
    }

    public static MCTrain fromNBT(RailNetworkManager railNetworkManager, NBTTagCompound tag) {
        ImmutableSet.Builder idBuilder = ImmutableSet.builder();
        NBTTagList idList = tag.func_150295_c("cartIDs", 4);
        for (int i = 0; i < idList.func_74745_c(); i += 2) {
            long most = ((NBTTagLong)idList.func_179238_g(i)).func_150291_c();
            long least = ((NBTTagLong)idList.func_179238_g(i + 1)).func_150291_c();
            idBuilder.add((Object)new UUID(most, least));
        }
        ImmutableSet.Builder posBuilder = ImmutableSet.builder();
        NBTTagList posList = tag.func_150295_c("positions", 10);
        for (int i = 0; i < posList.func_74745_c(); ++i) {
            posBuilder.add((Object)new MCPos(posList.func_150305_b(i)));
        }
        MCTrain train = new MCTrain(railNetworkManager, (ImmutableSet<UUID>)idBuilder.build());
        train.positions = posBuilder.build();
        return train;
    }

    static {
        DIRS_TO_RAIL_DIR.put(EnumSet.of(EnumHeading.NORTH, EnumHeading.SOUTH), BlockRailBase.EnumRailDirection.NORTH_SOUTH);
        DIRS_TO_RAIL_DIR.put(EnumSet.of(EnumHeading.EAST, EnumHeading.WEST), BlockRailBase.EnumRailDirection.EAST_WEST);
        DIRS_TO_RAIL_DIR.put(EnumSet.of(EnumHeading.NORTH, EnumHeading.EAST), BlockRailBase.EnumRailDirection.NORTH_EAST);
        DIRS_TO_RAIL_DIR.put(EnumSet.of(EnumHeading.EAST, EnumHeading.SOUTH), BlockRailBase.EnumRailDirection.SOUTH_EAST);
        DIRS_TO_RAIL_DIR.put(EnumSet.of(EnumHeading.SOUTH, EnumHeading.WEST), BlockRailBase.EnumRailDirection.SOUTH_WEST);
        DIRS_TO_RAIL_DIR.put(EnumSet.of(EnumHeading.WEST, EnumHeading.NORTH), BlockRailBase.EnumRailDirection.NORTH_WEST);
    }
}

