/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network.mc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.IRailLink;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.RailObjectHolder;
import com.minemaarten.signals.rail.network.mc.MCNetworkRail;
import com.minemaarten.signals.rail.network.mc.MCNetworkRailLink;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.NetworkSerializer;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.nbt.NBTTagCompound;

public class MCNetworkTeleportRail
extends MCNetworkRail
implements IRailLink<MCPos> {
    private final MCNetworkRailLink railLink;

    public MCNetworkTeleportRail(MCPos pos, Block railBlock, BlockRailBase.EnumRailDirection curDir, EnumSet<BlockRailBase.EnumRailDirection> validRailDirs, MCPos destination) {
        super(pos, railBlock, curDir, validRailDirs);
        this.railLink = new MCNetworkRailLink(pos, destination, 0);
    }

    public MCNetworkTeleportRail(MCPos pos, String railType, BlockRailBase.EnumRailDirection curDir, EnumSet<BlockRailBase.EnumRailDirection> validRailDirs, MCPos destination) {
        super(pos, railType, curDir, validRailDirs);
        this.railLink = new MCNetworkRailLink(pos, destination, 0);
    }

    @Override
    public MCPos getDestinationPos() {
        return (MCPos)this.railLink.getDestinationPos();
    }

    @Override
    public int getHoldDelay() {
        return this.railLink.getHoldDelay();
    }

    @Override
    public Stream<NetworkRail<MCPos>> getNeighborRails(RailObjectHolder<MCPos> railObjects) {
        NetworkRail<MCPos> rail = railObjects.getRail((MCPos)((IPosition)this.getPos()));
        return rail != null ? Stream.of(rail) : Stream.empty();
    }

    @Override
    protected ImmutableList<MCPos> computePotentialObjectNeighbors() {
        return (ImmutableList)Streams.concat((Stream[])new Stream[]{this.potentialObjectNeighborsStream(), Stream.of(this.getPos())}).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean canRailConnect(MCPos railPos) {
        return railPos.equals(this.getPos());
    }

    @Override
    public NetworkSerializer.EnumNetworkObject getType() {
        return NetworkSerializer.EnumNetworkObject.TELEPORT_RAIL;
    }

    @Override
    public void writeToBuf(ByteBuf b) {
        this.railLink.writeToBuf(b);
        super.writeToBuf(b);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.railLink.writeToNBT(tag);
    }

    public static MCNetworkTeleportRail fromTag(NBTTagCompound tag) {
        MCNetworkRailLink link = MCNetworkRailLink.fromTag(tag);
        return MCNetworkRail.fromTag(tag, (pos, railType, curDir, validDirs) -> new MCNetworkTeleportRail(pos, railType, curDir, (EnumSet<BlockRailBase.EnumRailDirection>)validDirs, (MCPos)link.getDestinationPos()));
    }

    public static MCNetworkTeleportRail fromByteBuf(ByteBuf b) {
        MCNetworkRailLink link = MCNetworkRailLink.fromByteBuf(b);
        return MCNetworkRail.fromByteBuf(b, (pos, railType, curDir, validDirs) -> new MCNetworkTeleportRail(pos, railType, curDir, (EnumSet<BlockRailBase.EnumRailDirection>)validDirs, (MCPos)link.getDestinationPos()));
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof MCNetworkTeleportRail && ((MCNetworkTeleportRail)obj).railLink.equals(this.railLink);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.railLink.hashCode();
    }
}

